/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.PingRequestImpl;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import java.util.LinkedList;
import java.util.List;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class PingRequestFactoryImpl
implements PingRequestFactory {
    public final NetworkManager networkManager;
    private final ConnectionServices connectionServices;

    @Inject
    public PingRequestFactoryImpl(NetworkManager networkManager, ConnectionServices connectionServices) {
        this.networkManager = networkManager;
        this.connectionServices = connectionServices;
    }

    @Override
    public PingRequest createPingRequest(byte[] byArray, byte by, byte by2) {
        return new PingRequestImpl(byArray, by, by2);
    }

    @Override
    public PingRequest createFromNetwork(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) {
        return new PingRequestImpl(byArray, by, by2, byArray2);
    }

    @Override
    public PingRequest createPingRequest(byte by) {
        return new PingRequestImpl(by);
    }

    @Override
    public PingRequest createPingRequest(byte[] byArray, byte by) {
        return new PingRequestImpl(byArray, by);
    }

    @Override
    public PingRequest createQueryKeyRequest() {
        LinkedList linkedList = new LinkedList();
        linkedList.add(new NameValue("QK"));
        return new PingRequestImpl(GUID.makeGuid(), 1, linkedList);
    }

    @Override
    public PingRequest createUDPPing() {
        LinkedList linkedList = new LinkedList();
        return new PingRequestImpl(this.populateUDPGGEPList(linkedList).bytes(), 1, linkedList);
    }

    @Override
    public PingRequest createUDPingWithDHTIPPRequest() {
        LinkedList linkedList = new LinkedList();
        GUID gUID = new GUID();
        linkedList.add(new NameValue("DHTIPP"));
        return new PingRequestImpl(gUID.bytes(), 1, linkedList);
    }

    @Override
    public PingRequest createUHCPing() {
        LinkedList linkedList = new LinkedList();
        GUID gUID = this.populateUDPGGEPList(linkedList);
        linkedList.add(new NameValue("UDPHC"));
        return new PingRequestImpl(gUID.bytes(), 1, linkedList);
    }

    @Override
    public PingRequest createMulticastPing() {
        GUID gUID = new GUID();
        LinkedList linkedList = new LinkedList();
        linkedList.add(new NameValue<byte[]>("SCP", this.getSCPData()));
        return new PingRequestImpl(gUID.bytes(), 1, linkedList);
    }

    private GUID populateUDPGGEPList(List<NameValue<?>> list) {
        GUID gUID;
        if (ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue()) {
            gUID = PingRequest.UDP_GUID;
        } else {
            list.add(new NameValue("IP"));
            gUID = this.networkManager.getSolicitedGUID();
        }
        list.add(new NameValue<byte[]>("SCP", this.getSCPData()));
        return gUID;
    }

    byte[] getSCPData() {
        byte[] byArray = new byte[]{this.connectionServices.isSupernode() ? (byte)1 : 0};
        if (SSLSettings.isIncomingTLSEnabled()) {
            byArray[0] = (byte)(byArray[0] | 2);
        }
        return byArray;
    }
}

