/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.GGEP;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HUGEExtension {
    private GGEP _ggep = null;
    private Set<URN> _urns = null;
    private Set<URN.Type> _urnTypes = null;
    private Set<String> _miscBlocks = null;
    private List<GGEPBlock> _ggepBlocks = null;

    public GGEP getGGEP() {
        return this._ggep;
    }

    public List<GGEPBlock> getGGEPBlocks() {
        if (this._ggepBlocks == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._ggepBlocks);
    }

    public Set<URN> getURNS() {
        if (this._urns == null) {
            return Collections.emptySet();
        }
        return this._urns;
    }

    public Set<URN.Type> getURNTypes() {
        if (this._urnTypes == null) {
            return Collections.emptySet();
        }
        return this._urnTypes;
    }

    public Set<String> getMiscBlocks() {
        if (this._miscBlocks == null) {
            return Collections.emptySet();
        }
        return this._miscBlocks;
    }

    public HUGEExtension(byte[] byArray) {
        int n = 0;
        while (n < byArray.length && byArray[n] != 0) {
            Object object;
            Object object2;
            int n2;
            if (byArray[n] == -61) {
                n2 = n;
                object2 = new int[]{n + 1};
                try {
                    object = new GGEP(byArray, n, (int[])object2);
                    if (this._ggep == null) {
                        this._ggep = new GGEP();
                    }
                    this._ggep.merge((GGEP)object);
                    if (this._ggepBlocks == null) {
                        this._ggepBlocks = new ArrayList<GGEPBlock>(2);
                    }
                    this._ggepBlocks.add(new GGEPBlock((GGEP)object, n2, object2[0]));
                }
                catch (BadGGEPBlockException badGGEPBlockException) {
                    // empty catch block
                }
                n = object2[0];
                continue;
            }
            for (n2 = n; n2 < byArray.length && byArray[n2] != 28; ++n2) {
            }
            if (n2 <= byArray.length) {
                try {
                    object2 = new String(byArray, n, n2 - n, "UTF-8");
                    if (URN.isUrn((String)object2)) {
                        object = URN.createSHA1Urn((String)object2);
                        if (this._urns == null) {
                            this._urns = new UrnSet();
                        }
                        this._urns.add((URN)object);
                    } else if (URN.Type.isSupportedUrnType((String)object2)) {
                        if (this._urnTypes == null) {
                            this._urnTypes = EnumSet.noneOf(URN.Type.class);
                        }
                        this._urnTypes.add(URN.Type.createUrnType((String)object2));
                    } else {
                        if (this._miscBlocks == null) {
                            this._miscBlocks = new HashSet<String>(1);
                        }
                        this._miscBlocks.add((String)object2);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            n = n2 + 1;
        }
    }

    public static class GGEPBlock {
        private int start;
        private int end;
        private GGEP ggep;

        public GGEPBlock(GGEP gGEP, int n, int n2) {
            this.ggep = gGEP;
            this.start = n;
            this.end = n2;
        }

        public GGEP getGGEP() {
            return this.ggep;
        }

        public int getStartPos() {
            return this.start;
        }

        public int getEndPos() {
            return this.end;
        }
    }
}

