/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.URIUtils;
import com.limegroup.gnutella.licenses.BadCCLicense;
import com.limegroup.gnutella.licenses.CCLicense;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseCache;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.licenses.MutableLicense;
import com.limegroup.gnutella.licenses.UnknownLicense;
import com.limegroup.gnutella.licenses.WeedLicense;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class LicenseFactoryImpl
implements LicenseFactory {
    private static final Log LOG = LogFactory.getLog(LicenseFactoryImpl.class);
    private final Provider<LicenseCache> licenseCache;

    @Inject
    public LicenseFactoryImpl(Provider<LicenseCache> provider) {
        this.licenseCache = provider;
    }

    @Override
    public boolean isVerifiedAndValid(URN uRN, String string) {
        URI uRI = LicenseFactoryImpl.getLicenseURI(string);
        return uRI != null && this.licenseCache.get().isVerifiedAndValid(uRN, uRI);
    }

    @Override
    public String getLicenseName(String string) {
        if (LicenseFactoryImpl.isCCLicense(string)) {
            return "Creative Commons License";
        }
        if (LicenseFactoryImpl.isWeedLicense(string)) {
            return "Weed License";
        }
        if (LicenseFactoryImpl.isUnknownLicense(string)) {
            return "Unknown License";
        }
        return null;
    }

    @Override
    public License create(String string) {
        if (string == null) {
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Attempting to create license from: " + string);
        }
        License license = null;
        URI uRI = LicenseFactoryImpl.getLicenseURI(string);
        if (uRI != null) {
            license = this.licenseCache.get().getLicense(string, uRI);
        }
        if (license == null) {
            if (LicenseFactoryImpl.isCCLicense(string)) {
                license = uRI != null ? new CCLicense(string, uRI) : new BadCCLicense(string);
            } else if (LicenseFactoryImpl.isWeedLicense(string) && uRI != null) {
                license = new WeedLicense(uRI);
            } else if (LicenseFactoryImpl.isUnknownLicense(string)) {
                license = new UnknownLicense();
            }
        }
        if (license instanceof MutableLicense) {
            ((MutableLicense)license).setLicenseName(this.getLicenseName(string));
        }
        return license;
    }

    private static boolean isCCLicense(String string) {
        return string.toLowerCase(Locale.US).indexOf("verify at") != -1;
    }

    private static boolean isWeedLicense(String string) {
        return string.startsWith("http://www.shmedlic.com/license/3play.aspx");
    }

    private static boolean isUnknownLicense(String string) {
        return string.startsWith("licensed: ");
    }

    @Override
    public void persistCache() {
        this.licenseCache.get().persistCache();
    }

    static URI getLicenseURI(String string) {
        if (string == null) {
            return null;
        }
        URI uRI = LicenseFactoryImpl.getCCLicenseURI(string);
        if (uRI == null) {
            uRI = LicenseFactoryImpl.getWeedLicenseURI(string);
        }
        return uRI;
    }

    private static URI getCCLicenseURI(String string) {
        int n = (string = string.toLowerCase(Locale.US)).indexOf("verify at");
        if (n == -1) {
            return null;
        }
        int n2 = n + "verify at".length();
        if (n2 >= string.length()) {
            return null;
        }
        String string2 = string.substring(n2).trim();
        URI uRI = null;
        try {
            uRI = URIUtils.toURI(string2);
            String string3 = uRI.getScheme();
            if (string3 == null || !string3.equalsIgnoreCase("http")) {
                throw new URISyntaxException(uRI.toString(), "Invalid scheme: " + string3);
            }
            String string4 = uRI.getAuthority();
            if (string4 == null || string4.equals("") || string4.indexOf(32) != -1) {
                throw new URISyntaxException(uRI.toString(), "Invalid authority: " + string4);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            URIUtils.error(uRISyntaxException);
            uRI = null;
            LOG.error("Unable to create URI", uRISyntaxException);
        }
        return uRI;
    }

    private static URI getWeedLicenseURI(String string) {
        int n = string.indexOf("http://www.shmedlic.com/license/3play.aspx");
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(" cid: ");
        int n3 = string.indexOf(" vid: ");
        if (n2 == -1 || n3 == -1) {
            LOG.debug("No cid or vid, bailing.");
            return null;
        }
        int n4 = string.indexOf(" ", n2 += " cid: ".length());
        int n5 = string.indexOf(" ", n3 += " vid: ".length());
        if (n4 == -1 && n5 == -1) {
            LOG.debug("No endings for both cid & vid, bailing");
            return null;
        }
        if (n4 == -1) {
            n4 = string.length();
        }
        if (n5 == -1) {
            n5 = string.length();
        }
        String string2 = string.substring(n2, n4).trim();
        String string3 = string.substring(n3, n5).trim();
        if (string2.length() == 0 || string3.length() == 0) {
            LOG.debug("cid or vid is empty, bailing");
            return null;
        }
        if (string2.startsWith(" vid: ".trim()) || string3.startsWith(" cid: ".trim())) {
            LOG.debug("cid starts with vid, or vice versa, bailing.");
            return null;
        }
        return WeedLicense.buildURI(string2, string3);
    }
}

