/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.licenses.LicenseCache;
import com.limegroup.gnutella.licenses.MutableLicense;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.limewire.http.LimeHttpClient;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractLicense
implements MutableLicense,
Serializable,
Cloneable {
    private static final Log LOG = LogFactory.getLog(AbstractLicense.class);
    private static final long serialVersionUID = 6508972367931096578L;
    protected transient int verified = 0;
    protected transient URI licenseLocation;
    private transient String licenseName;
    private long lastVerifiedTime;

    AbstractLicense(URI uRI) {
        this.licenseLocation = uRI;
    }

    public void setLicenseName(String string) {
        this.licenseName = string;
    }

    public boolean isVerifying() {
        return this.verified == 1;
    }

    public boolean isVerified() {
        return this.verified == 2;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public URI getLicenseURI() {
        return this.licenseLocation;
    }

    public long getLastVerifiedTime() {
        return this.lastVerifiedTime;
    }

    void setVerified(int n) {
        this.verified = n;
    }

    void setLastVerifiedTime(long l) {
        this.lastVerifiedTime = l;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.verified = 2;
    }

    protected abstract void clear();

    protected String getBody(String string, LimeHttpClient limeHttpClient) {
        return this.getBodyFromURL(string, limeHttpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBodyFromURL(String string, LimeHttpClient limeHttpClient) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Contacting: " + string);
        }
        HttpResponse httpResponse = null;
        try {
            HttpGet httpGet = new HttpGet(string);
            httpGet.addHeader("User-Agent", LimeWireUtils.getHttpServer());
            httpResponse = limeHttpClient.execute(httpGet);
            String string2 = httpResponse.getEntity() != null ? EntityUtils.toString(httpResponse.getEntity()) : null;
            String string3 = string2;
            limeHttpClient.releaseConnection(httpResponse);
            return string3;
        }
        catch (IOException iOException) {
            try {
                LOG.warn("Can't contact license server: " + string, iOException);
                limeHttpClient.releaseConnection(httpResponse);
            }
            catch (Throwable throwable) {
                limeHttpClient.releaseConnection(httpResponse);
                throw throwable;
            }
        }
        return null;
    }

    protected abstract void parseDocumentNode(Node var1, LicenseCache var2, LimeHttpClient var3);

    protected void parseXML(String string, LicenseCache licenseCache, LimeHttpClient limeHttpClient) {
        Document document;
        if (string == null) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Attempting to parse: " + string);
        }
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(string));
            document = documentBuilder.parse(inputSource);
        }
        catch (IOException iOException) {
            LOG.debug("IOX parsing XML\n" + string, iOException);
            return;
        }
        catch (SAXException sAXException) {
            LOG.debug("SAX parsing XML\n" + string, sAXException);
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOG.debug("couldn't instantiate parser", parserConfigurationException);
            return;
        }
        this.parseDocumentNode(document.getDocumentElement(), licenseCache, limeHttpClient);
    }

    public void verify(LicenseCache licenseCache, LimeHttpClient limeHttpClient) {
        this.setVerified(1);
        this.clear();
        String string = this.getBody(this.getLicenseURI().toString(), limeHttpClient);
        this.parseXML(string, licenseCache, limeHttpClient);
        this.setLastVerifiedTime(System.currentTimeMillis());
        this.setVerified(2);
        licenseCache.addVerifiedLicense(this);
    }
}

