/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.FileDesc;
import java.io.File;
import java.io.IOException;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public class SharingUtils {
    public static final File PROGRAM_SHARE;
    public static final File PREFERENCE_SHARE;
    public static final File APPLICATION_SPECIAL_SHARE;

    public static boolean isFilePhysicallyShareable(File file) {
        if (file == null || !file.exists() || file.isDirectory() || !file.canRead() || file.isHidden()) {
            return false;
        }
        long l = file.length();
        return l > 0L && l <= 0xFFFFFFFFFFL;
    }

    public static boolean isSensitiveDirectory(File file) {
        if (file == null) {
            return false;
        }
        String string = System.getProperty("user.home");
        if (file.equals(new File(string))) {
            return true;
        }
        String string2 = string.substring(string.lastIndexOf(File.separator) + 1);
        String[] stringArray = OSUtils.isWindowsVista() ? new String[]{"Documents and Settings", string2 + File.separator + "Documents", "Desktop", "Program Files", "Windows", "WINNT", "Users", "Local Settings", "Application Data", "Temp", "Temporary Internet Files"} : (OSUtils.isWindows() ? new String[]{"Documents and Settings", "My Documents", "Desktop", "Program Files", "Windows", "WINNT", "Users", "Local Settings", "Application Data", "Temp", "Temporary Internet Files"} : (OSUtils.isMacOSX() ? new String[]{"Users", "System", "System Folder", "Previous Systems", "private", "Volumes", "Desktop", "Applications", "Applications (Mac OS 9)", "Network"} : (OSUtils.isPOSIX() ? new String[]{"bin", "boot", "dev", "etc", "home", "mnt", "opt", "proc", "root", "sbin", "usr", "var"} : new String[]{})));
        String string3 = file.getPath();
        for (String string4 : stringArray) {
            if (!string3.endsWith(File.separator + string4)) continue;
            return true;
        }
        return false;
    }

    public static boolean isForcedShare(FileDesc fileDesc) {
        return SharingUtils.isForcedShare(fileDesc.getFile());
    }

    public static boolean isForcedShare(File file) {
        File file2 = file.getParentFile();
        return file2 != null && SharingUtils.isForcedShareDirectory(file2);
    }

    public static boolean isApplicationSpecialShare(File file) {
        File file2 = file.getParentFile();
        return file2 != null && SharingUtils.isApplicationSpecialShareDirectory(file2);
    }

    public static boolean isForcedShareDirectory(File file) {
        return file.equals(PROGRAM_SHARE) || file.equals(PREFERENCE_SHARE);
    }

    public static boolean isApplicationSpecialShareDirectory(File file) {
        return file.equals(APPLICATION_SPECIAL_SHARE);
    }

    static {
        File file = new File(".", ".NetworkShare").getAbsoluteFile();
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PROGRAM_SHARE = file;
        file = new File(CommonUtils.getUserSettingsDir(), ".NetworkShare").getAbsoluteFile();
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PREFERENCE_SHARE = file;
        file = new File(CommonUtils.getUserSettingsDir(), ".AppSpecialShare").getAbsoluteFile();
        file.mkdir();
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        APPLICATION_SPECIAL_SHARE = file;
    }
}

