/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.limewire.collection.MultiRRIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AltLocTracker {
    private Set<DirectAltLoc> writtenLocs = new HashSet<DirectAltLoc>();
    private Set<PushAltLoc> writtenPushLocs = new HashSet<PushAltLoc>();
    private static final int MAX_LOCATIONS = 10;
    private static final int MAX_PUSH_LOCATIONS = 5;
    private int fwtVersion = 0;
    private final URN urn;
    private boolean wantsFAlts;

    public AltLocTracker(URN uRN) {
        if (uRN == null) {
            throw new IllegalArgumentException();
        }
        this.urn = uRN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DirectAltLoc> getNextSetOfAltsToSend(AltLocManager altLocManager) {
        AlternateLocationCollection<DirectAltLoc> alternateLocationCollection = altLocManager.getDirect(this.urn);
        HashSet<DirectAltLoc> hashSet = null;
        long l = System.currentTimeMillis();
        AlternateLocationCollection<DirectAltLoc> alternateLocationCollection2 = alternateLocationCollection;
        synchronized (alternateLocationCollection2) {
            Iterator<DirectAltLoc> iterator = alternateLocationCollection.iterator();
            int n = 0;
            while (iterator.hasNext() && n < 10) {
                DirectAltLoc directAltLoc = iterator.next();
                if (this.writtenLocs.contains(directAltLoc)) continue;
                if (directAltLoc.canBeSent(1)) {
                    this.writtenLocs.add(directAltLoc);
                    if (hashSet == null) {
                        hashSet = new HashSet<DirectAltLoc>();
                    }
                    hashSet.add(directAltLoc);
                    ++n;
                    directAltLoc.send(l, 1);
                    continue;
                }
                if (directAltLoc.canBeSentAny()) continue;
                iterator.remove();
            }
        }
        if (hashSet == null) {
            return Collections.emptySet();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PushAltLoc> getNextSetOfPushAltsToSend(AltLocManager altLocManager) {
        if (!this.wantsFAlts) {
            return Collections.emptySet();
        }
        AlternateLocationCollection<PushAltLoc> alternateLocationCollection = altLocManager.getPushFWT(this.urn);
        AlternateLocationCollection<Object> alternateLocationCollection2 = this.fwtVersion > 0 ? AlternateLocationCollection.getEmptyCollection() : altLocManager.getPushNoFWT(this.urn);
        HashSet<PushAltLoc> hashSet = null;
        long l = System.currentTimeMillis();
        AlternateLocationCollection<Object> alternateLocationCollection3 = alternateLocationCollection2;
        synchronized (alternateLocationCollection3) {
            AlternateLocationCollection<PushAltLoc> alternateLocationCollection4 = alternateLocationCollection;
            synchronized (alternateLocationCollection4) {
                MultiRRIterator<Object> multiRRIterator = new MultiRRIterator<Object>((Iterator<Object>)alternateLocationCollection.iterator(), alternateLocationCollection2.iterator());
                int n = 0;
                while (multiRRIterator.hasNext() && n < 5) {
                    PushAltLoc pushAltLoc = (PushAltLoc)multiRRIterator.next();
                    if (this.writtenPushLocs.contains(pushAltLoc)) continue;
                    if (pushAltLoc.getPushAddress().getProxies().isEmpty()) {
                        multiRRIterator.remove();
                        continue;
                    }
                    if (pushAltLoc.canBeSent(1)) {
                        pushAltLoc.send(l, 1);
                        this.writtenPushLocs.add(pushAltLoc);
                        if (hashSet == null) {
                            hashSet = new HashSet<PushAltLoc>();
                        }
                        hashSet.add(pushAltLoc);
                        ++n;
                        continue;
                    }
                    if (pushAltLoc.canBeSentAny()) continue;
                    multiRRIterator.remove();
                }
            }
        }
        if (hashSet == null) {
            return Collections.emptySet();
        }
        return hashSet;
    }

    public void addLocation(AlternateLocation alternateLocation) {
        if (alternateLocation instanceof DirectAltLoc) {
            this.writtenLocs.add((DirectAltLoc)alternateLocation);
        } else {
            this.writtenPushLocs.add((PushAltLoc)alternateLocation);
        }
    }

    public boolean wantsFAlts() {
        return this.wantsFAlts;
    }

    public void setWantsFAlts(boolean bl) {
        this.wantsFAlts = bl;
    }

    public URN getUrn() {
        return this.urn;
    }

    public int getFwtVersion() {
        return this.fwtVersion;
    }

    public void setFwtVersion(int n) {
        this.fwtVersion = n;
    }
}

