/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.TitledPaddedPanel;
import com.limegroup.gnutella.gui.wizard.Status;
import com.limegroup.gnutella.gui.wizard.Wizard;
import com.limegroup.gnutella.gui.wizard.WizardPage;
import com.limegroup.gnutella.gui.wizard.WizardPageModificationHandler;
import com.limegroup.gnutella.gui.xml.editor.CCRDFOuptut;
import com.limegroup.gnutella.gui.xml.editor.MetaDataEventListener;
import com.limegroup.gnutella.gui.xml.editor.MetaDataSaver;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.PublishedCCLicense;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.limewire.collection.NameValue;
import org.limewire.i18n.I18nMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCPublishWizard
extends Wizard {
    private LimeXMLDocument doc;
    private FileDesc fd;
    private DetailsPage detailsPage;
    private UsagePage usagePage;
    private VerificationPage verificationPage;
    private WarningPage warningPage;
    private LimeXMLSchema schema;

    public CCPublishWizard(FileDesc fileDesc, LimeXMLDocument limeXMLDocument, LimeXMLSchema limeXMLSchema) {
        this.fd = fileDesc;
        this.doc = limeXMLDocument;
        this.schema = limeXMLSchema;
    }

    public void showDialog(Frame frame) {
        this.warningPage = new WarningPage();
        this.detailsPage = new DetailsPage();
        this.usagePage = new UsagePage();
        this.verificationPage = new VerificationPage();
        this.addPage(this.warningPage);
        this.addPage(this.usagePage);
        this.addPage(this.detailsPage);
        this.addPage(this.verificationPage);
        this.initInfo();
        JDialog jDialog = this.createDialog(frame);
        jDialog.setTitle(I18n.tr("Publish License"));
        jDialog.setLocationRelativeTo(MessageService.getParentComponent());
        jDialog.setVisible(true);
    }

    @Override
    public void performFinish() {
        if (this.warningPage.MODIFY_LICENSE.isSelected()) {
            MetaDataSaver metaDataSaver = new MetaDataSaver(new FileDesc[]{this.fd}, this.schema, GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(this.getInputValues(), this.schema.getSchemaURI()).getXMLString());
            metaDataSaver.saveMetaData(this.getFileEventListener());
            this.dialog.dispose();
        } else {
            DialogOption dialogOption = GUIMediator.showYesNoMessage(I18n.tr("Are you sure you want to permanently remove the license from your local copy of this file?"), DialogOption.YES);
            if (dialogOption == DialogOption.YES) {
                List<NameValue<String>> list = CCPublishWizard.getPreviousValList(this.doc, false);
                list.add(new NameValue<String>("audios__audio__license__", ""));
                list.add(new NameValue<String>("audios__audio__licensetype__", ""));
                MetaDataSaver metaDataSaver = new MetaDataSaver(new FileDesc[]{this.fd}, this.schema, GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(list, this.schema.getSchemaURI()).getXMLString());
                metaDataSaver.saveMetaData();
                this.dialog.dispose();
            }
        }
    }

    private void initInfo() {
        License license = this.fd.getLicense();
        if (license != null) {
            String string;
            this.warningPage.setLicenseAvailable(true);
            if (license.getLicenseURI() != null) {
                this.verificationPage.VERIFICATION_URL_FIELD.setText(license.getLicenseURI().toString());
                this.verificationPage.SELF_VERIFICATION.setSelected(true);
                this.verificationPage.updateVerification();
            }
            if ((string = license.getLicenseDeed(this.fd.getSHA1Urn()).toString()) != null) {
                if (string.equals("http://creativecommons.org/licenses/by-nc-nd/2.5/")) {
                    this.usagePage.ALLOW_COMMERCIAL_YES.setSelected(false);
                    this.usagePage.ALLOW_MODIFICATIONS_NO.setSelected(true);
                } else if (string.equals("http://creativecommons.org/licenses/by-nd/2.5/")) {
                    this.usagePage.ALLOW_COMMERCIAL_YES.setSelected(true);
                    this.usagePage.ALLOW_MODIFICATIONS_NO.setSelected(true);
                } else if (string.equals("http://creativecommons.org/licenses/by-nc/2.5/")) {
                    this.usagePage.ALLOW_COMMERCIAL_YES.setSelected(false);
                    this.usagePage.ALLOW_MODIFICATIONS_YES.setSelected(true);
                } else if (string.equals("http://creativecommons.org/licenses/by-nc-sa/2.5/")) {
                    this.usagePage.ALLOW_COMMERCIAL_YES.setSelected(false);
                    this.usagePage.ALLOW_MODIFICATIONS_SHAREALIKE.setSelected(true);
                } else if (string.equals("http://creativecommons.org/licenses/by-sa/2.5/")) {
                    this.usagePage.ALLOW_COMMERCIAL_YES.setSelected(true);
                    this.usagePage.ALLOW_MODIFICATIONS_SHAREALIKE.setSelected(true);
                } else {
                    this.usagePage.ALLOW_COMMERCIAL_YES.setSelected(true);
                    this.usagePage.ALLOW_MODIFICATIONS_YES.setSelected(true);
                }
            }
        } else {
            this.warningPage.setLicenseAvailable(false);
        }
        if (this.doc != null) {
            this.detailsPage.COPYRIGHT_HOLDER.setText(this.doc.getValue("audios__audio__artist__"));
            this.detailsPage.COPYRIGHT_YEAR.setText(this.doc.getValue("audios__audio__year__"));
            this.detailsPage.WORK_TITLE.setText(this.doc.getValue("audios__audio__title__"));
        }
    }

    private MetaDataEventListener getFileEventListener() {
        return new CCRDFOuptut(this.fd, this.detailsPage.COPYRIGHT_HOLDER.getText(), this.detailsPage.WORK_TITLE.getText(), this.detailsPage.COPYRIGHT_YEAR.getText(), this.detailsPage.DESCRIPTION.getText(), this.verificationPage.VERIFICATION_URL_FIELD.getText(), this.getLicenseType());
    }

    private int getLicenseType() {
        int n = 0;
        if (!this.usagePage.ALLOW_COMMERCIAL_YES.isSelected()) {
            n |= 2;
        }
        if (this.usagePage.ALLOW_MODIFICATIONS_SHAREALIKE.isSelected()) {
            n |= 4;
        } else if (this.usagePage.ALLOW_MODIFICATIONS_NO.isSelected()) {
            n |= 1;
        }
        return n;
    }

    private List<NameValue<String>> getInputValues() {
        ArrayList<NameValue<String>> arrayList = new ArrayList<NameValue<String>>();
        String string = this.detailsPage.COPYRIGHT_HOLDER.getText();
        String string2 = this.detailsPage.COPYRIGHT_YEAR.getText();
        String string3 = this.detailsPage.WORK_TITLE.getText();
        String string4 = this.detailsPage.DESCRIPTION.getText();
        int n = this.getLicenseType();
        String string5 = this.verificationPage.VERIFICATION_URL_FIELD.getText();
        boolean bl = this.detailsPage.SAVE_DETAILS_CHECKBOX.isSelected();
        arrayList.addAll(CCPublishWizard.getPreviousValList(this.doc, bl));
        String string6 = PublishedCCLicense.getEmbeddableString(string, string3, string2, string5, string4, n);
        if (string6 != null) {
            arrayList.add(new NameValue<String>("audios__audio__license__", string6));
            arrayList.add(new NameValue<String>("audios__audio__licensetype__", "creativecommons.org/licenses/"));
        }
        if (bl) {
            arrayList.add(new NameValue<String>("audios__audio__title__", string3));
            arrayList.add(new NameValue<String>("audios__audio__year__", string2));
            arrayList.add(new NameValue<String>("audios__audio__artist__", string));
            arrayList.add(new NameValue<String>("audios__audio__comments__", string4));
        }
        return arrayList;
    }

    public static List<NameValue<String>> getPreviousValList(LimeXMLDocument limeXMLDocument, boolean bl) {
        ArrayList<NameValue<String>> arrayList = new ArrayList<NameValue<String>>();
        if (limeXMLDocument != null) {
            for (Map.Entry<String, String> entry : limeXMLDocument.getNameValueSet()) {
                String string = entry.getKey();
                if (CCPublishWizard.isLicenseKey(string) || bl && CCPublishWizard.isDetailsKey(string)) continue;
                arrayList.add(new NameValue<String>(entry.getKey(), entry.getValue()));
            }
        }
        return arrayList;
    }

    private static boolean isLicenseKey(String string) {
        return string.equals("audios__audio__license__") || string.equals("audios__audio__licensetype__");
    }

    private static boolean isDetailsKey(String string) {
        return string.equals("audios__audio__title__") || string.equals("audios__audio__year__") || string.equals("audios__audio__artist__") || string.equals("audios__audio__comments__");
    }

    private class VerificationPage
    extends WizardPage {
        final JTextField VERIFICATION_URL_FIELD;
        final String VERIFICATION_ARCHIVE;
        final String VERIFICATION_SELF;
        final JRadioButton SELF_VERIFICATION;
        private boolean complete;

        public VerificationPage() {
            super("verificationPage", I18nMarker.marktr("Publish License"), I18nMarker.marktr("Where do you want to store the verification URL?"));
            this.VERIFICATION_URL_FIELD = new SizedTextField(20, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
            this.VERIFICATION_ARCHIVE = I18n.tr("I want to use the Internet Archive to host the file.");
            this.VERIFICATION_SELF = I18n.tr("I want to host the verification file myself at the following URL:");
            this.SELF_VERIFICATION = new JRadioButton(this.VERIFICATION_SELF);
            this.setURL(SharingSettings.CREATIVE_COMMONS_VERIFICATION_URL.getValue(), I18nMarker.marktr("What is this?"));
        }

        protected void createPageContent(JPanel jPanel) {
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.SELF_VERIFICATION);
            this.SELF_VERIFICATION.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VerificationPage.this.updateVerification();
                }
            });
            BoxPanel boxPanel = new BoxPanel(0);
            boxPanel.add(new JLabel(I18n.tr("The verification file is hosted at the following URL:")));
            boxPanel.add(Box.createHorizontalGlue());
            jPanel.add(boxPanel);
            jPanel.add(Box.createRigidArea(BoxPanel.VERTICAL_COMPONENT_GAP));
            this.VERIFICATION_URL_FIELD.setText("http://");
            boxPanel = new BoxPanel(0);
            boxPanel.addVerticalComponentGap();
            boxPanel.add(this.VERIFICATION_URL_FIELD);
            this.VERIFICATION_URL_FIELD.getDocument().addDocumentListener(new WizardPageModificationHandler(this));
            boxPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.VERIFICATION_URL_FIELD.getPreferredSize().height));
            jPanel.add(boxPanel);
            jPanel.add(Box.createVerticalGlue());
            this.SELF_VERIFICATION.setSelected(true);
            this.updateVerification();
        }

        public boolean isPageComplete() {
            return this.complete;
        }

        private void updateVerification() {
            this.VERIFICATION_URL_FIELD.setEnabled(true);
            this.validateInput();
        }

        public void validateInput() {
            this.complete = true;
            String string = this.VERIFICATION_URL_FIELD.getText();
            if (string.equals("") || !string.startsWith("http://") || string.length() < 8) {
                this.updateStatus(new Status(I18n.tr("Please enter a verification URL for the license."), Status.Severity.INFO));
                this.complete = false;
            }
            try {
                new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                this.updateStatus(new Status(I18n.tr("Please enter a verification URL for the license."), Status.Severity.ERROR));
                this.complete = false;
            }
            if (this.complete) {
                this.updateStatus(new Status[0]);
            }
            CCPublishWizard.this.updateButtons();
        }
    }

    private class DetailsPage
    extends WizardPage {
        private final JTextField COPYRIGHT_HOLDER;
        private final JTextField WORK_TITLE;
        private final JTextField COPYRIGHT_YEAR;
        private final JTextArea DESCRIPTION;
        final JCheckBox SAVE_DETAILS_CHECKBOX;
        private boolean complete;

        public DetailsPage() {
            super("detailsPage", I18nMarker.marktr("Publish License"), I18nMarker.marktr("This tool helps you publish audio under a Creative Commons license."));
            this.COPYRIGHT_HOLDER = new SizedTextField(24, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
            this.WORK_TITLE = new SizedTextField(24, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
            this.COPYRIGHT_YEAR = new SizedTextField(6, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
            this.DESCRIPTION = new JTextArea(4, 24);
            this.SAVE_DETAILS_CHECKBOX = new JCheckBox(I18n.tr("Save details to file"));
            this.complete = false;
        }

        protected void createPageContent(JPanel jPanel) {
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            BoxPanel boxPanel = new BoxPanel(0);
            jPanel.add(boxPanel);
            LabeledComponent labeledComponent = new LabeledComponent(I18nMarker.marktr("Copyright Holder:"), this.COPYRIGHT_HOLDER, 150, 13);
            this.COPYRIGHT_HOLDER.getDocument().addDocumentListener(new WizardPageModificationHandler(this));
            boxPanel.add(labeledComponent.getComponent());
            boxPanel.add(Box.createRigidArea(BoxPanel.HORIZONTAL_COMPONENT_GAP));
            labeledComponent = new LabeledComponent(I18nMarker.marktr("Copyright Year:"), this.COPYRIGHT_YEAR, 150, 13);
            this.COPYRIGHT_YEAR.getDocument().addDocumentListener(new WizardPageModificationHandler(this));
            boxPanel.add(labeledComponent.getComponent());
            jPanel.add(Box.createRigidArea(BoxPanel.LINE_GAP));
            labeledComponent = new LabeledComponent(I18nMarker.marktr("Title of Work:"), this.WORK_TITLE, 150, 13);
            this.WORK_TITLE.getDocument().addDocumentListener(new WizardPageModificationHandler(this));
            jPanel.add(labeledComponent.getComponent());
            jPanel.add(Box.createRigidArea(BoxPanel.LINE_GAP));
            labeledComponent = new LabeledComponent(I18nMarker.marktr("Comment:"), new JScrollPane(this.DESCRIPTION), 150, 13);
            jPanel.add(labeledComponent.getComponent());
            jPanel.add(labeledComponent.getComponent());
            jPanel.add(Box.createRigidArea(BoxPanel.LINE_GAP));
        }

        public boolean isPageComplete() {
            return this.complete;
        }

        public void validateInput() {
            this.complete = true;
            if ("".equals(this.COPYRIGHT_HOLDER.getText()) || "".equals(this.COPYRIGHT_YEAR.getText()) || "".equals(this.WORK_TITLE.getText())) {
                this.updateStatus(new Status(I18n.tr("Please enter the copyright holder, copright year and title."), Status.Severity.INFO));
                this.complete = false;
            } else {
                try {
                    Integer.parseInt(this.COPYRIGHT_YEAR.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    this.updateStatus(new Status(I18n.tr("Please enter a valid year for the file you want to publish."), Status.Severity.ERROR));
                    this.complete = false;
                }
            }
            if (this.complete) {
                this.updateStatus(new Status[0]);
            }
            CCPublishWizard.this.updateButtons();
        }
    }

    private class UsagePage
    extends WizardPage {
        final JRadioButton ALLOW_COMMERCIAL_YES;
        final JRadioButton ALLOW_COMMERCIAL_NO;
        final JRadioButton ALLOW_MODIFICATIONS_SHAREALIKE;
        final JRadioButton ALLOW_MODIFICATIONS_YES;
        final JRadioButton ALLOW_MODIFICATIONS_NO;

        public UsagePage() {
            super("usagePage", I18nMarker.marktr("Publish License"), I18nMarker.marktr("This tool helps you publish audio under a Creative Commons license."));
            this.ALLOW_COMMERCIAL_YES = new JRadioButton(I18n.tr("Yes"));
            this.ALLOW_COMMERCIAL_NO = new JRadioButton(I18n.tr("No"));
            this.ALLOW_MODIFICATIONS_SHAREALIKE = new JRadioButton(I18n.tr("ShareAlike"));
            this.ALLOW_MODIFICATIONS_YES = new JRadioButton(I18n.tr("Yes"));
            this.ALLOW_MODIFICATIONS_NO = new JRadioButton(I18n.tr("No"));
        }

        protected void createPageContent(JPanel jPanel) {
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            TitledPaddedPanel titledPaddedPanel = new TitledPaddedPanel(I18n.tr("Allow commercial use of your work?"));
            titledPaddedPanel.add(Box.createHorizontalGlue());
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.ALLOW_COMMERCIAL_YES);
            buttonGroup.add(this.ALLOW_COMMERCIAL_NO);
            BoxPanel boxPanel = new BoxPanel();
            titledPaddedPanel.add(boxPanel);
            boxPanel.add(this.ALLOW_COMMERCIAL_YES);
            boxPanel.add(this.ALLOW_COMMERCIAL_NO);
            jPanel.add(titledPaddedPanel);
            jPanel.add(Box.createRigidArea(BoxPanel.LINE_GAP));
            TitledPaddedPanel titledPaddedPanel2 = new TitledPaddedPanel(I18n.tr("Allow modification of your work?"));
            titledPaddedPanel2.add(Box.createHorizontalGlue());
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.ALLOW_MODIFICATIONS_SHAREALIKE);
            buttonGroup.add(this.ALLOW_MODIFICATIONS_YES);
            buttonGroup.add(this.ALLOW_MODIFICATIONS_NO);
            boxPanel = new BoxPanel();
            titledPaddedPanel2.add(boxPanel);
            boxPanel.add(this.ALLOW_MODIFICATIONS_SHAREALIKE);
            boxPanel.add(this.ALLOW_MODIFICATIONS_YES);
            boxPanel.add(this.ALLOW_MODIFICATIONS_NO);
            jPanel.add(titledPaddedPanel2);
            this.ALLOW_COMMERCIAL_NO.setSelected(true);
            this.ALLOW_MODIFICATIONS_NO.setSelected(true);
        }

        public boolean isPageComplete() {
            return true;
        }
    }

    private class WarningPage
    extends WizardPage {
        private final String WARNING_MESSAGE_CREATE;
        private final String WARNING_MESSAGE_MODIFY;
        private final JCheckBox WARNING_CHECKBOX;
        private final TitledPaddedPanel MODE_SELECTION_PANEL;
        final JRadioButton MODIFY_LICENSE;
        final JRadioButton REMOVE_LICENSE;

        public WarningPage() {
            super("warningPage", I18nMarker.marktr("Publish License"), I18nMarker.marktr("This tool helps you publish audio under a Creative Commons license."));
            this.WARNING_MESSAGE_CREATE = I18n.tr("I understand that to publish a file, I must either own its copyrights or be authorized to publish them under a Creative Commons license.");
            this.WARNING_MESSAGE_MODIFY = I18n.tr("This file already has a license. If you want to modify it, click the checkbox to attest that you either own its copyrights or are authorized to publish them under a Creative Commons license.");
            this.WARNING_CHECKBOX = new JCheckBox();
            this.MODE_SELECTION_PANEL = new TitledPaddedPanel();
            this.MODIFY_LICENSE = new JRadioButton(I18n.tr("Modify the license of this file"));
            this.REMOVE_LICENSE = new JRadioButton(I18n.tr("Permanently remove the license from this file"));
            this.setURL(SharingSettings.CREATIVE_COMMONS_INTRO_URL.getValue(), I18nMarker.marktr("How does it work?"));
        }

        protected void createPageContent(JPanel jPanel) {
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.WARNING_CHECKBOX.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    WarningPage.this.updateActions();
                }
            });
            this.WARNING_CHECKBOX.setPreferredSize(new Dimension(540, -1));
            jPanel.add(this.WARNING_CHECKBOX);
            this.MODE_SELECTION_PANEL.add(Box.createHorizontalGlue());
            jPanel.add(this.MODE_SELECTION_PANEL);
            this.MODIFY_LICENSE.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    WarningPage.this.updateActions();
                }
            });
            this.REMOVE_LICENSE.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    WarningPage.this.updateActions();
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.MODIFY_LICENSE);
            buttonGroup.add(this.REMOVE_LICENSE);
            BoxPanel boxPanel = new BoxPanel();
            boxPanel.add(this.MODIFY_LICENSE);
            boxPanel.add(this.REMOVE_LICENSE);
            this.MODE_SELECTION_PANEL.add(boxPanel);
            this.MODIFY_LICENSE.setSelected(true);
            this.updateActions();
            this.setLicenseAvailable(true);
        }

        public void setLicenseAvailable(boolean bl) {
            if (bl) {
                this.WARNING_CHECKBOX.setText("<html>" + this.WARNING_MESSAGE_MODIFY + "</html>");
                this.MODE_SELECTION_PANEL.setVisible(true);
            } else {
                this.WARNING_CHECKBOX.setText("<html>" + this.WARNING_MESSAGE_CREATE + "</html>");
                this.MODIFY_LICENSE.setSelected(true);
                this.MODE_SELECTION_PANEL.setVisible(false);
            }
        }

        public boolean canFlipToNextPage() {
            return this.MODIFY_LICENSE.isSelected();
        }

        public boolean isPageComplete() {
            return this.WARNING_CHECKBOX.isSelected();
        }

        private void updateActions() {
            this.MODIFY_LICENSE.setEnabled(this.WARNING_CHECKBOX.isSelected());
            this.REMOVE_LICENSE.setEnabled(this.WARNING_CHECKBOX.isSelected());
            this.getWizard().updateButtons();
        }
    }
}

