/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.upload;

import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import com.limegroup.gnutella.gui.upload.UploadDataLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UploadModel
extends BasicDataLineModel<UploadDataLine, Uploader> {
    UploadModel() {
        super(UploadDataLine.class);
    }

    @Override
    public UploadDataLine createDataLine() {
        return new UploadDataLine();
    }

    @Override
    public int update(Uploader uploader) {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            UploadDataLine uploadDataLine = (UploadDataLine)this.get(i);
            if (uploadDataLine.getFileIndex() != uploader.getIndex() || !uploadDataLine.getHost().equals(uploader.getHost()) || !uploadDataLine.isInactive()) continue;
            uploadDataLine.initialize(uploader);
            this.fireTableRowsUpdated(i, i);
            return i;
        }
        return -1;
    }

    int countActiveUploads() {
        int n = this.getRowCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            UploadDataLine uploadDataLine = (UploadDataLine)this.get(i);
            if (uploadDataLine.isInactive()) continue;
            ++n2;
        }
        return n2;
    }

    int getCurrentUploads() {
        int n = this.getRowCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            UploadDataLine uploadDataLine = (UploadDataLine)this.get(i);
            if (!uploadDataLine.isUploading()) continue;
            ++n2;
        }
        return n2;
    }

    double getActiveUploadsBandwidth() {
        int n = this.getRowCount();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            UploadDataLine uploadDataLine = (UploadDataLine)this.get(i);
            if (!uploadDataLine.isUploading()) continue;
            d += Math.max(uploadDataLine.getSpeed(), 0.0);
        }
        return d;
    }

    @Override
    public Object refresh() {
        int n = this.getRowCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            UploadDataLine uploadDataLine = (UploadDataLine)this.get(i);
            uploadDataLine.update();
            bl |= uploadDataLine.isInactive();
        }
        this.fireTableRowsUpdated(0, n);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    void clearCompleted() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            UploadDataLine uploadDataLine = (UploadDataLine)this.get(i);
            if (!uploadDataLine.isInactive()) continue;
            this.remove(i);
        }
    }
}

