/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.shell.LimeAssociationOption;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.util.Collection;
import org.limewire.i18n.I18nMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellAssociationManager {
    private final Collection<LimeAssociationOption> associations;

    public ShellAssociationManager(Collection<LimeAssociationOption> collection) {
        this.associations = collection;
    }

    public boolean checkAndGrab(boolean bl) {
        boolean bl2 = true;
        for (LimeAssociationOption object : this.associations) {
            if (!object.isAllowed()) continue;
            if (object.isAvailable()) {
                object.setEnabled(true);
                continue;
            }
            if (object.isEnabled()) continue;
            bl2 = false;
        }
        if (!bl2 && bl) {
            Object object = GUIMediator.showYesNoOtherMessage(I18n.tr("One or more files or protocols that FrostWire uses are no longer associated with FrostWire. Would you like FrostWire to re-associate them?"), QuestionsHandler.GRAB_ASSOCIATIONS, I18n.tr("Details"));
            if (object == DialogOption.YES) {
                for (LimeAssociationOption limeAssociationOption : this.associations) {
                    if (!limeAssociationOption.isAllowed() || limeAssociationOption.isEnabled()) continue;
                    limeAssociationOption.setEnabled(true);
                }
            } else if (object == DialogOption.OTHER) {
                new ConfigureOptionsAction(I18nMarker.marktr("File Associations")).actionPerformed(null);
            }
        }
        return bl2;
    }
}

