/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.shell.FileTypeAssociation;
import com.limegroup.gnutella.gui.shell.LimeAssociationOption;
import com.limegroup.gnutella.gui.shell.MagnetAssociation;
import com.limegroup.gnutella.gui.shell.ShellAssociation;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeAssociations {
    public static final int CURRENT_ASSOCIATIONS = 2;
    private static final String PROGRAM = OSUtils.isWindows() ? "FrostWire" : (OSUtils.isUnix() ? System.getProperty("unix.executable", "") : "");
    private static final String UNSUPPORTED_PLATFORM = "";
    private static Collection<LimeAssociationOption> options;

    public static synchronized Collection<LimeAssociationOption> getSupportedAssociations() {
        if (options == null) {
            options = LimeAssociations.getSupportedAssociationsImpl();
        }
        return options;
    }

    public static synchronized boolean anyAssociationsSupported() {
        return !LimeAssociations.getSupportedAssociations().isEmpty();
    }

    private static Collection<LimeAssociationOption> getSupportedAssociationsImpl() {
        LimeAssociationOption limeAssociationOption;
        Object object;
        if (!ResourceManager.instance().isJdicLibraryLoaded()) {
            return Collections.emptyList();
        }
        ArrayList<LimeAssociationOption> arrayList = new ArrayList<LimeAssociationOption>();
        String string = null;
        String string2 = null;
        Object object2 = null;
        if (OSUtils.isWindows() && (object = SystemUtils.getRunningPath()) != null && ((String)object).endsWith(PROGRAM + ".exe")) {
            object2 = object;
            string = "\"" + (String)object + "\" \"%1\"";
            string2 = ((String)object).replace(".exe", ".ico");
        }
        if (string != null) {
            if (OSUtils.isWindows()) {
                object = new FileTypeAssociation("torrent", "application/x-bittorrent", string, "open", "FrostWire Torrent", string2);
                limeAssociationOption = new LimeAssociationOption((ShellAssociation)object, ApplicationSettings.HANDLE_TORRENTS, ".torrent", I18n.tr("\".torrent\" files"));
                arrayList.add(limeAssociationOption);
            } else {
                object = new FileTypeAssociation("torrent", "Application/x-bittorrent", string, "open", "FrostWire Torrent", string2);
                limeAssociationOption = new LimeAssociationOption((ShellAssociation)object, ApplicationSettings.HANDLE_TORRENTS, ".torrent", I18n.tr("\".torrent\" files"));
                arrayList.add(limeAssociationOption);
            }
        }
        if (object2 != null) {
            object = new MagnetAssociation(PROGRAM, (String)object2);
            limeAssociationOption = new LimeAssociationOption((ShellAssociation)object, ApplicationSettings.HANDLE_MAGNETS, "magnet:", I18n.tr("\"magnet:\" links"));
            arrayList.add(limeAssociationOption);
        }
        return Collections.unmodifiableCollection(arrayList);
    }
}

