/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.shell.ShellAssociation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jdic.filetypes.Action;
import org.jdesktop.jdic.filetypes.Association;
import org.jdesktop.jdic.filetypes.AssociationAlreadyRegisteredException;
import org.jdesktop.jdic.filetypes.AssociationNotRegisteredException;
import org.jdesktop.jdic.filetypes.AssociationService;
import org.jdesktop.jdic.filetypes.RegisterFailedException;
import org.limewire.util.SystemUtils;

public class FileTypeAssociation
implements ShellAssociation {
    private static final Log LOG = LogFactory.getLog(FileTypeAssociation.class);
    private static final AssociationService SERVICE = new AssociationService();
    private final String extention;
    private final String mimeType;
    private final String executable;
    private final String verb;
    private final Association association = new Association();

    public FileTypeAssociation(String string, String string2, String string3, String string4, String string5, String string6) {
        this.extention = string;
        this.mimeType = string2;
        this.executable = string3;
        this.verb = string4;
        Action action = new Action(string4, string3);
        this.association.addAction(action);
        this.association.addFileExtension(string);
        this.association.setMimeType(string2);
        this.association.setName(string5);
        this.association.setDescription(string5);
        if (string6 != null) {
            this.association.setIconFileName(string6);
        }
    }

    public boolean isAvailable() {
        Object object;
        try {
            object = SERVICE.getFileExtensionAssociation(this.extention);
            if (object == null && object == SERVICE.getMimeTypeAssociation(this.mimeType)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn("Can't check availability!", illegalArgumentException);
            return true;
        }
        object = SystemUtils.getDefaultExtentionHandler(this.extention);
        return "".equals(object) && "".equals(SystemUtils.getDefaultMimeHandler(this.mimeType));
    }

    public boolean isRegistered() {
        Association association;
        try {
            association = SERVICE.getFileExtensionAssociation(this.extention);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn("Can't check registration!", illegalArgumentException);
            return false;
        }
        if (association == null) {
            return false;
        }
        Action action = association.getActionByVerb(this.verb);
        if (action == null) {
            return false;
        }
        if (this.executable.equals(action.getCommand())) {
            return true;
        }
        return this.executable.equals(SystemUtils.getDefaultExtentionHandler(this.extention)) && this.executable.equals(SystemUtils.getDefaultMimeHandler(this.mimeType));
    }

    public void register() {
        try {
            SERVICE.registerUserAssociation(this.association);
            SystemUtils.flushIconCache();
        }
        catch (AssociationAlreadyRegisteredException associationAlreadyRegisteredException) {
            LOG.error("can't register", associationAlreadyRegisteredException);
        }
        catch (RegisterFailedException registerFailedException) {
            LOG.error("can't register", registerFailedException);
        }
    }

    public void unregister() {
        try {
            this.forceUnregister(SERVICE.getFileExtensionAssociation(this.extention));
            this.forceUnregister(SERVICE.getMimeTypeAssociation(this.extention));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn("Can't unregister!", illegalArgumentException);
        }
    }

    private void forceUnregister(Association association) {
        if (association == null) {
            return;
        }
        try {
            SERVICE.unregisterUserAssociation(association);
            SystemUtils.flushIconCache();
        }
        catch (AssociationNotRegisteredException associationNotRegisteredException) {
            LOG.error("can't unregister", associationNotRegisteredException);
        }
        catch (RegisterFailedException registerFailedException) {
            LOG.error("can't unregister", registerFailedException);
        }
    }

    public String toString() {
        return this.extention + ":" + this.mimeType + ":" + this.executable + ":" + this.verb;
    }
}

