/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.AbstractSearchResult;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.tables.Linkable;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.util.PopupUtils;
import com.limegroup.gnutella.security.SHA1;
import com.limegroup.gnutella.util.EncodingUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.swing.JPopupMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.Base32;

public class ThirdPartySearchResult
extends AbstractSearchResult
implements Linkable {
    private static final Log LOG = LogFactory.getLog(ThirdPartySearchResult.class);
    private final String name;
    private final String url;
    private final int size;
    private final long creationTime;
    private final LimeXMLDocument xmlDoc;
    private final String vendor;
    private final URN urn;
    private final String type;
    private final String keyword;

    public ThirdPartySearchResult(String string, String string2, String string3, int n, long l, LimeXMLDocument limeXMLDocument, String string4, String string5) {
        this.name = string;
        this.url = string3;
        this.size = n;
        this.creationTime = l;
        this.xmlDoc = limeXMLDocument;
        this.vendor = string4;
        this.type = string2 == null ? "" : string2;
        this.keyword = string5;
        URN uRN = null;
        try {
            String string6;
            SHA1 sHA1 = new SHA1();
            if (string != null) {
                sHA1.update(string.getBytes("UTF-8"));
            }
            if (string3 != null) {
                sHA1.update(string3.getBytes("UTF-8"));
            }
            if (string4 != null) {
                sHA1.update(string4.getBytes("UTF-8"));
            }
            if ((string6 = new String(Base32.encode(sHA1.digest()))).length() > 20) {
                string6 = string6.substring(0, 20);
            }
            uRN = URN.createSHA1UrnFromBytes(string6.getBytes());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.error(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            LOG.error(iOException);
        }
        this.urn = uRN;
    }

    public String getFilenameNoExtension() {
        return this.name;
    }

    public String getExtension() {
        return this.type;
    }

    public boolean isLink() {
        return this.url != null && !"".equals(this.url);
    }

    public String getLinkUrl() {
        return this.url;
    }

    public String getFileName() {
        return this.name;
    }

    public URN getSHA1Urn() {
        return this.urn;
    }

    public long getSize() {
        return this.size;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public LimeXMLDocument getXMLDocument() {
        return this.xmlDoc;
    }

    public boolean isDownloading() {
        return false;
    }

    public String getVendor() {
        return this.vendor == null ? "" : this.vendor;
    }

    public int getSpeed() {
        return 0x7FFFFFFD;
    }

    public boolean isMeasuredSpeed() {
        return true;
    }

    public int getQuality() {
        return 5;
    }

    public int getSecureStatus() {
        return 0;
    }

    public float getSpamRating() {
        return 0.0f;
    }

    public String getHost() {
        return null;
    }

    String getURL() {
        return this.url;
    }

    public Color getEvenRowColor() {
        return ThemeFileHandler.TABLE_SPECIAL_BACKGROUND_COLOR.getValue();
    }

    public Color getOddRowColor() {
        return ThemeFileHandler.TABLE_SPECIAL_ALTERNATE_COLOR.getValue();
    }

    public void takeAction(TableLine tableLine, GUID gUID, File file, String string, boolean bl, SearchInformation searchInformation) {
        GUIMediator.openURL(LimeWireUtils.addLWInfoToUrl(this.getURL(), GuiCoreMediator.getApplicationServices().getMyGUID()) + "&keyword=" + EncodingUtils.encode(this.keyword) + "&client=true");
    }

    public void initialize(TableLine tableLine) {
    }

    public JPopupMenu createMenu(JPopupMenu jPopupMenu, final TableLine[] tableLineArray, boolean bl, boolean bl2, final ResultPanel resultPanel) {
        PopupUtils.addMenuItem(I18n.tr("View in Browser..."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchMediator.downloadFromPanel(resultPanel, tableLineArray);
            }
        }, jPopupMenu, tableLineArray.length > 0, 0);
        jPopupMenu.add((Component)new JPopupMenu.Separator(), 1);
        return jPopupMenu;
    }
}

