/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.AbstractSearchResult;
import com.limegroup.gnutella.gui.search.MySharedFilesResultPanel;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Color;
import java.io.File;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedSearchResult
extends AbstractSearchResult {
    private FileDesc fileDesc;
    private RemoteFileDesc rfd;
    private Set<? extends IpPort> _alts;

    public SharedSearchResult(FileDesc fileDesc, RemoteFileDesc remoteFileDesc, Set<? extends IpPort> set) {
        this.fileDesc = fileDesc;
        this.rfd = remoteFileDesc;
        this._alts = set;
    }

    public FileDesc getFileDesc() {
        return this.fileDesc;
    }

    RemoteFileDesc getRemoteFileDesc() {
        return this.rfd;
    }

    Set<? extends IpPort> getAlts() {
        return this._alts;
    }

    void clearAlts() {
        this._alts = null;
    }

    @Override
    public String getFileName() {
        return this.rfd.getFileName();
    }

    @Override
    public long getSize() {
        return this.rfd.getSize();
    }

    @Override
    public URN getSHA1Urn() {
        return this.rfd.getSHA1Urn();
    }

    @Override
    public LimeXMLDocument getXMLDocument() {
        return this.rfd.getXMLDocument();
    }

    @Override
    public long getCreationTime() {
        return this.rfd.getCreationTime();
    }

    @Override
    public boolean isDownloading() {
        return this.rfd.isDownloading();
    }

    @Override
    public String getVendor() {
        return this.rfd.getVendor();
    }

    @Override
    public int getQuality() {
        return this.rfd.getQuality();
    }

    @Override
    public int getSecureStatus() {
        return this.rfd.getSecureStatus();
    }

    @Override
    public int getSpeed() {
        return 0;
    }

    @Override
    public boolean isMeasuredSpeed() {
        return false;
    }

    @Override
    public float getSpamRating() {
        return this.rfd.getSpamRating();
    }

    @Override
    public String getHost() {
        return this.rfd.getHost();
    }

    @Override
    public Color getEvenRowColor() {
        return ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
    }

    @Override
    public Color getOddRowColor() {
        return ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue();
    }

    @Override
    public void takeAction(TableLine tableLine, GUID gUID, File file, String string, boolean bl, SearchInformation searchInformation) {
    }

    @Override
    public JPopupMenu createMenu(JPopupMenu jPopupMenu, TableLine[] tableLineArray, boolean bl, boolean bl2, ResultPanel resultPanel) {
        JPopupMenu jPopupMenu2 = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(I18n.tr("Path") + ": " + this.getFileDesc().getPath());
        jPopupMenu2.add(jMenuItem);
        jPopupMenu2.addSeparator();
        jPopupMenu2.add(new JMenuItem(((MySharedFilesResultPanel)resultPanel).STOP_SHARING_FILE_LISTENER));
        return jPopupMenu2;
    }

    @Override
    public void initialize(TableLine tableLine) {
        tableLine.createEndpointHolder("127.0.0.1", this.rfd.getPort(), false);
        tableLine.setAddedOn(this.rfd.getCreationTime());
    }
}

