/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ProgTabUIFactory;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.search.CancelSearchIconProxy;
import com.limegroup.gnutella.gui.search.MySharedFilesResultPanel;
import com.limegroup.gnutella.gui.search.OverlayAd;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SearchSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.limewire.util.DebugRunnable;

public final class SearchResultDisplayer
implements ThemeObserver,
RefreshListener {
    private final JPanel MAIN_PANEL = new BoxPanel(1);
    private JTabbedPane tabbedPane = new JTabbedPane();
    private static final List<ResultPanel> entries = new ArrayList<ResultPanel>();
    private JPanel results = new JPanel();
    private CardLayout switcher = new CardLayout();
    private ResultPanel DUMMY;
    private JPanel mainScreen;
    private OverlayAd OVERLAY;
    private ChangeListener _activeSearchListener;
    private final PaneListener PANE_LISTENER = new PaneListener();

    public SearchResultDisplayer() {
        this.MAIN_PANEL.setMinimumSize(new Dimension(0, 0));
        this.results.setPreferredSize(new Dimension(10000, 10000));
        this.results.setLayout(this.switcher);
        this.OVERLAY = new OverlayAd();
        this.DUMMY = new ResultPanel(this.OVERLAY);
        this.mainScreen = new JPanel(new BorderLayout());
        this.mainScreen.add((Component)this.DUMMY.getComponent(), "Center");
        this.results.add("dummy", this.mainScreen);
        this.switcher.first(this.results);
        this.setupTabbedPane();
        this.MAIN_PANEL.add(this.results);
        ThemeMediator.addThemeObserver(this);
        CancelSearchIconProxy.updateTheme();
    }

    public OverlayAd getOverlayAd() {
        return this.OVERLAY;
    }

    public void setOverlayAd(OverlayAd overlayAd) {
        this.OVERLAY = null;
        this.OVERLAY = overlayAd;
    }

    public void refreshOverlayAd() throws InterruptedException {
        this.getOverlayAd().loadOverlay();
        this.results.getComponent(0).invalidate();
    }

    void setSearchListener(ChangeListener changeListener) {
        this._activeSearchListener = changeListener;
    }

    void updateResults() {
        for (int i = 0; i < entries.size(); ++i) {
            entries.get(i).refresh();
        }
    }

    ResultPanel addResultTab(GUID gUID, SearchInformation searchInformation) {
        ResultPanel resultPanel = new ResultPanel(gUID, searchInformation);
        return this.addResultPanelInternal(resultPanel, searchInformation.getTitle());
    }

    ResultPanel addMyFilesResultTab(String string) {
        FileManager fileManager = GuiCoreMediator.getFileManager();
        MySharedFilesResultPanel mySharedFilesResultPanel = new MySharedFilesResultPanel(string, fileManager);
        return this.addResultPanelInternal(mySharedFilesResultPanel, string);
    }

    private void removeTabbedPaneListeners() {
        if (this.tabbedPane != null) {
            this.tabbedPane.removeMouseListener(this.PANE_LISTENER);
            this.tabbedPane.removeMouseMotionListener(this.PANE_LISTENER);
            this.tabbedPane.removeChangeListener(this.PANE_LISTENER);
        }
    }

    private void addTabbedPaneListeners() {
        if (this.tabbedPane != null) {
            this.tabbedPane.addMouseListener(this.PANE_LISTENER);
            this.tabbedPane.addMouseMotionListener(this.PANE_LISTENER);
            this.tabbedPane.addChangeListener(this.PANE_LISTENER);
        }
    }

    private void setupTabbedPane() {
        this.removeTabbedPaneListeners();
        this.tabbedPane = new JTabbedPane();
        ProgTabUIFactory.extendUI(this.tabbedPane);
        this.tabbedPane.setRequestFocusEnabled(false);
        this.results.add("tabbedPane", this.tabbedPane);
        this.addTabbedPaneListeners();
    }

    private void resetTabbedPane() {
        int n;
        ArrayList<ResultPanel> arrayList = new ArrayList<ResultPanel>();
        ArrayList<Component> arrayList2 = new ArrayList<Component>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (n = 0; n < this.tabbedPane.getTabCount() && n < entries.size(); ++n) {
            arrayList2.add(this.tabbedPane.getComponent(n));
            arrayList3.add(this.tabbedPane.getTitleAt(n));
            arrayList.add(entries.get(n));
        }
        this.tabbedPane.removeAll();
        entries.clear();
        this.setupTabbedPane();
        for (n = 0; n < arrayList2.size(); ++n) {
            entries.add((ResultPanel)arrayList.get(n));
            this.tabbedPane.addTab((String)arrayList3.get(n), (Component)arrayList2.get(n));
        }
    }

    private ResultPanel addResultPanelInternal(ResultPanel resultPanel, String string) {
        entries.add(resultPanel);
        try {
            this.tabbedPane.addTab(string, CancelSearchIconProxy.createSelected(), resultPanel.getComponent());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.resetTabbedPane();
            entries.add(resultPanel);
            this.tabbedPane.addTab(string, CancelSearchIconProxy.createSelected(), resultPanel.getComponent());
        }
        try {
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.resetTabbedPane();
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.resetTabbedPane();
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        if (entries.size() > SearchSettings.PARALLEL_SEARCH.getValue()) {
            this.killSearchAtIndex(0);
        }
        GUIMediator.instance().setSearching(true);
        if (this.OVERLAY != null) {
            this.OVERLAY.searchPerformed();
        }
        this.switcher.last(this.results);
        this.MAIN_PANEL.revalidate();
        return resultPanel;
    }

    void addQueryResult(byte[] byArray, SearchResult searchResult, ResultPanel resultPanel) {
        if (!resultPanel.matches(new GUID(byArray))) {
            throw new IllegalArgumentException("guids don't match");
        }
        resultPanel.add(searchResult);
        int n = -1;
        n = entries.indexOf(resultPanel);
        if (n == -1) {
            return;
        }
        this.tabbedPane.setTitleAt(n, this.titleOf(resultPanel));
    }

    void addChangeListener(ChangeListener changeListener) {
        this.tabbedPane.addChangeListener(changeListener);
    }

    void addFocusListener(FocusListener focusListener) {
        this.tabbedPane.addFocusListener(focusListener);
    }

    void showMenu(MouseEvent mouseEvent) {
        ResultPanel resultPanel = this.getSelectedResultPanel();
        if (resultPanel != null) {
            JPopupMenu jPopupMenu = resultPanel.createPopupMenu(new TableLine[0]);
            Point point = mouseEvent.getPoint();
            if (jPopupMenu != null) {
                try {
                    jPopupMenu.show(this.MAIN_PANEL, point.x + 1, point.y - 6);
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
            }
        }
    }

    ResultPanel getSelectedResultPanel() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        try {
            return entries.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    ResultPanel getResultPanelForGUID(GUID gUID) {
        for (int i = 0; i < entries.size(); ++i) {
            ResultPanel resultPanel = entries.get(i);
            if (!resultPanel.matches(gUID)) continue;
            return resultPanel;
        }
        return null;
    }

    ResultPanel getPanelAtIndex(int n) {
        return entries.get(n);
    }

    int getIndexForGUID(GUID gUID) {
        for (int i = 0; i < entries.size(); ++i) {
            ResultPanel resultPanel = entries.get(i);
            if (!resultPanel.matches(gUID)) continue;
            return i;
        }
        return -1;
    }

    int getIndexForPoint(int n, int n2) {
        TabbedPaneUI tabbedPaneUI = this.tabbedPane.getUI();
        return tabbedPaneUI.tabForCoordinate(this.tabbedPane, n, n2);
    }

    void killSearch() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n >= entries.size()) {
            this.resetTabbedPane();
            n = this.tabbedPane.getSelectedIndex();
        }
        if (n == -1) {
            return;
        }
        this.killSearchAtIndex(n);
    }

    void killSearchAtIndex(int n) {
        ResultPanel resultPanel = entries.remove(n);
        final GUID gUID = new GUID(resultPanel.getGUID());
        BackgroundExecutorService.schedule(new DebugRunnable(new Runnable(){

            public void run() {
                GuiCoreMediator.getSearchServices().stopQuery(gUID);
            }
        }));
        try {
            this.tabbedPane.removeTabAt(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.resetTabbedPane();
            this.tabbedPane.removeTabAt(n);
        }
        this.fixIcons();
        SearchMediator.searchKilled(resultPanel);
        ThemeMediator.removeThemeObserver(resultPanel);
        if (entries.size() == 0) {
            try {
                this.switcher.first(this.results);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            GUIMediator.instance().setSearching(false);
        } else {
            this.checkToStopLime();
        }
    }

    void browseHostFailed(GUID gUID) {
        int n = this.getIndexForGUID(gUID);
        if (n > -1) {
            ResultPanel resultPanel = this.getPanelAtIndex(n);
            this.killSearchAtIndex(n);
            GUIMediator.showError(I18n.tr("Could not browse host {0}.", resultPanel.getTitle()), QuestionsHandler.BROWSE_HOST_FAILED);
        }
    }

    void checkToStopLime() {
        if (entries == null || entries.size() == 0) {
            GUIMediator.instance().setSearching(false);
            return;
        }
        long l = System.currentTimeMillis();
        boolean bl = true;
        for (int i = 0; i < entries.size(); ++i) {
            ResultPanel resultPanel = entries.get(i);
            bl &= resultPanel.isStopped() || resultPanel.calculatePercentage(l) >= 1.0;
        }
        if (bl) {
            GUIMediator.instance().setSearching(false);
        }
    }

    void setTabDisplayCount(ResultPanel resultPanel) {
        int n;
        boolean bl = false;
        for (n = 0; n < entries.size(); ++n) {
            ResultPanel resultPanel2 = entries.get(n);
            if (resultPanel2 != resultPanel) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.tabbedPane.setTitleAt(n, this.titleOf(resultPanel));
        }
    }

    private void fixIcons() {
        int n = this.tabbedPane.getSelectedIndex();
        for (int i = 0; i < entries.size() && i < this.tabbedPane.getTabCount(); ++i) {
            this.tabbedPane.setIconAt(i, i == n ? CancelSearchIconProxy.createSelected() : CancelSearchIconProxy.createPlain());
        }
    }

    ResultPanel getDummyResultPanel() {
        return this.DUMMY;
    }

    JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    public void updateTheme() {
        ProgTabUIFactory.extendUI(this.tabbedPane);
        this.DUMMY.updateTheme();
        this.OVERLAY.updateTheme();
        CancelSearchIconProxy.updateTheme();
        this.fixIcons();
        for (ResultPanel resultPanel : entries) {
            resultPanel.updateTheme();
        }
    }

    public void refresh() {
        this.checkToStopLime();
        if (this.tabbedPane.isVisible() && this.tabbedPane.isShowing()) {
            Rectangle rectangle = this.tabbedPane.getBounds();
            Component component = null;
            try {
                component = this.tabbedPane.getSelectedComponent();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.resetTabbedPane();
                component = this.tabbedPane.getSelectedComponent();
            }
            if (component != null) {
                Rectangle rectangle2 = component.getBounds();
                Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - 1);
                this.tabbedPane.repaint(rectangle3);
            }
        }
    }

    private String titleOf(ResultPanel resultPanel) {
        int n;
        int n2 = resultPanel.filteredSources();
        if (n2 < (n = resultPanel.totalSources())) {
            return resultPanel.getTitle() + " (" + n2 + "/" + n + ")";
        }
        return resultPanel.getTitle() + " (" + n + ")";
    }

    private class PaneListener
    implements MouseListener,
    MouseMotionListener,
    ChangeListener {
        private int lastIdx = -1;

        private PaneListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.tryPopup(mouseEvent)) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                int n;
                int n2 = mouseEvent.getX();
                int n3 = this.shouldKillIndex(n2, n = mouseEvent.getY());
                if (n3 != -1) {
                    this.lastIdx = -1;
                    SearchResultDisplayer.this.killSearchAtIndex(n3);
                }
                if (n3 == -1) {
                    this.stateChanged(null);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = this.shouldKillIndex(n2, n = mouseEvent.getY());
            if (n3 != this.lastIdx && this.lastIdx != -1) {
                this.resetIcon();
            }
            if (n3 != -1) {
                SearchResultDisplayer.this.tabbedPane.setIconAt(n3, CancelSearchIconProxy.createArmed());
                this.lastIdx = n3;
            }
        }

        private int shouldKillIndex(int n, int n2) {
            Icon icon;
            int n3 = SearchResultDisplayer.this.getIndexForPoint(n, n2);
            if (n3 != -1 && (icon = SearchResultDisplayer.this.tabbedPane.getIconAt(n3)) != null && icon instanceof CancelSearchIconProxy && ((CancelSearchIconProxy)icon).shouldKill(n, n2)) {
                return n3;
            }
            return -1;
        }

        private void resetIcon() {
            if (this.lastIdx != -1 && this.lastIdx < SearchResultDisplayer.this.tabbedPane.getTabCount()) {
                if (this.lastIdx == SearchResultDisplayer.this.tabbedPane.getSelectedIndex()) {
                    SearchResultDisplayer.this.tabbedPane.setIconAt(this.lastIdx, CancelSearchIconProxy.createSelected());
                } else {
                    SearchResultDisplayer.this.tabbedPane.setIconAt(this.lastIdx, CancelSearchIconProxy.createPlain());
                }
                this.lastIdx = -1;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.tryPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.tryPopup(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.resetIcon();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        private boolean tryPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = SearchResultDisplayer.this.getIndexForPoint(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    try {
                        SearchResultDisplayer.this.tabbedPane.setSelectedIndex(n);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        SearchResultDisplayer.this.resetTabbedPane();
                        SearchResultDisplayer.this.tabbedPane.setSelectedIndex(n);
                    }
                }
                SearchResultDisplayer.this.showMenu(mouseEvent);
                return true;
            }
            return false;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SearchResultDisplayer.this._activeSearchListener.stateChanged(changeEvent);
            SearchResultDisplayer.this.fixIcons();
        }
    }
}

