/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.ClearableAutoCompleteTextField;
import com.limegroup.gnutella.settings.SearchSettings;
import java.awt.Toolkit;
import java.util.Arrays;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.limewire.util.I18NConvert;

public class SearchField
extends ClearableAutoCompleteTextField {
    private static final char[] ILLEGAL_CHARS = SearchSettings.ILLEGAL_CHARS.getValue();
    private static int MAX_QUERY_LENGTH = SearchSettings.MAX_QUERY_LENGTH.getValue();
    private static final Toolkit TOOLKIT;

    public SearchField() {
    }

    public SearchField(int n) {
        super(n);
    }

    protected Document createDefaultModel() {
        return new SearchFieldDocument();
    }

    static {
        Arrays.sort(ILLEGAL_CHARS);
        TOOLKIT = Toolkit.getDefaultToolkit();
    }

    public static class SearchFieldDocument
    extends PlainDocument {
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            MAX_QUERY_LENGTH = SearchSettings.MAX_QUERY_LENGTH.getValue();
            if (string == null) {
                super.insertString(n, string, attributeSet);
                return;
            }
            if (n >= MAX_QUERY_LENGTH) {
                TOOLKIT.beep();
                return;
            }
            String string2 = I18NConvert.instance().getNorm(string);
            if (this.getMaxLength() + Math.max(string.length(), string2.length()) > MAX_QUERY_LENGTH) {
                TOOLKIT.beep();
                return;
            }
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                if (Arrays.binarySearch(ILLEGAL_CHARS, cArray[i]) < 0) {
                    cArray2[n2++] = cArray[i];
                    continue;
                }
                TOOLKIT.beep();
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }

        private int getMaxLength() {
            try {
                String string = this.getText(0, this.getLength());
                return Math.max(string.length(), I18NConvert.instance().getNorm(string).length());
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }
    }
}

