/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.OverlayLayout;

public class OverlayAd
extends JPanel
implements ThemeObserver {
    public final int NOT_READY_YET = -1000;
    private final Icon CLOSER;
    private ImageIcon _image = null;
    private boolean _searchDone;
    private Future<Void> introFuture;
    private LoadImageThenRun introRunner;
    private UISettings.ImageInfo introInfo = UISettings.INTRO_IMAGE_INFO;
    private UISettings.ImageInfo afterSearchInfo = UISettings.AFTER_SEARCH_IMAGE_INFO;
    private JPanel lastIntroPanel;
    private JPanel introPanel;
    private JPanel afterSearchPanel;

    public OverlayAd() {
        this.setLayout(new OverlayLayout(this));
        this.CLOSER = GUIMediator.getThemeImage("kill_on");
        this.loadOverlay();
    }

    public void loadOverlay() {
        this._searchDone = false;
        this.introInfo = UISettings.INTRO_IMAGE_INFO;
        this.afterSearchInfo = UISettings.AFTER_SEARCH_IMAGE_INFO;
        LateImageRunner lateImageRunner = new LateImageRunner(){

            public void runWithImage(ImageIcon imageIcon, boolean bl) {
                OverlayAd.this._image = imageIcon;
                Dimension dimension = new Dimension(OverlayAd.this._image.getIconWidth(), OverlayAd.this._image.getIconHeight());
                OverlayAd.this.setMaximumSize(dimension);
                OverlayAd.this.setPreferredSize(dimension);
                try {
                    if (bl) {
                        OverlayAd.this.add(OverlayAd.this.createTextPanel(OverlayAd.this.introInfo));
                    } else if (!OverlayAd.this.afterSearchInfo.canProShowPic() && LimeWireUtils.isPro()) {
                        OverlayAd.this.add(OverlayAd.this.createCloserPanel());
                    }
                    OverlayAd.this.removeLastIntroPanel();
                    OverlayAd.this.introPanel = OverlayAd.this.createImagePanel(OverlayAd.this.getUrl(OverlayAd.this.introInfo, bl), OverlayAd.this.introInfo.getTorrentUrl());
                    OverlayAd.this.lastIntroPanel = OverlayAd.this.introPanel;
                    OverlayAd.this.add(OverlayAd.this.introPanel);
                    if (OverlayAd.this.afterSearchPanel != null && !OverlayAd.this._searchDone) {
                        OverlayAd.this.afterSearchPanel.setVisible(false);
                    }
                    GUIUtils.setOpaque(false, OverlayAd.this);
                }
                catch (NullPointerException nullPointerException) {
                    OverlayAd.this.setVisible(false);
                    OverlayAd.this._searchDone = true;
                }
            }
        };
        this.introRunner = new LoadImageThenRun(this.introInfo, lateImageRunner, "intro", null);
        this.introFuture = this.introRunner.run();
    }

    public void removeLastIntroPanel() {
        if (this.lastIntroPanel != null) {
            this.lastIntroPanel.setVisible(false);
            this.remove(this.lastIntroPanel);
        }
    }

    public int getIntroFutureRunnerIconImageLoadStatus() {
        if (this.introRunner == null) {
            return -1000;
        }
        return this.introRunner.getImageIconLoadStatus();
    }

    public ImageIcon getIntroImageIcon() {
        if (this.introRunner == null) {
            return null;
        }
        return this.introRunner.getImageIcon();
    }

    public UISettings.ImageInfo getImageInfo() {
        return this.introInfo;
    }

    public void updateIntroInfo(UISettings.ImageInfo imageInfo) {
        UISettings.INTRO_IMAGE_INFO = imageInfo;
        UISettings.instance().save();
        this.introInfo = UISettings.INTRO_IMAGE_INFO;
    }

    public void updateAfterSearchInfo(UISettings.ImageInfo imageInfo) {
        UISettings.AFTER_SEARCH_IMAGE_INFO = imageInfo;
        UISettings.instance().save();
        this.afterSearchInfo = UISettings.AFTER_SEARCH_IMAGE_INFO;
    }

    public void updateTheme() {
        GUIUtils.setOpaque(false, this);
    }

    void searchPerformed() {
        if (this._searchDone) {
            System.out.println("OverlayAd.searchPerformed() - already did it sorry");
            return;
        }
        LoadImageThenRun loadImageThenRun = new LoadImageThenRun(this.afterSearchInfo, new LateImageRunner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runWithImage(ImageIcon imageIcon, boolean bl) {
                OverlayAd.this.introFuture.cancel(false);
                OverlayAd.this._image = imageIcon;
                Dimension dimension = new Dimension(OverlayAd.this._image.getIconWidth(), OverlayAd.this._image.getIconHeight());
                OverlayAd.this.setMaximumSize(dimension);
                OverlayAd.this.setPreferredSize(dimension);
                try {
                    OverlayAd.this.removeAll();
                    if (bl) {
                        OverlayAd.this.add(OverlayAd.this.createTextPanel(OverlayAd.this.afterSearchInfo));
                    }
                    OverlayAd.this.afterSearchPanel = OverlayAd.this.createImagePanel(OverlayAd.this.getUrl(OverlayAd.this.afterSearchInfo, bl), OverlayAd.this.afterSearchInfo.getTorrentUrl());
                    OverlayAd.this.add(OverlayAd.this.afterSearchPanel);
                    if (OverlayAd.this.introPanel != null) {
                        OverlayAd.this.introPanel.setVisible(false);
                        OverlayAd.this.afterSearchPanel.setVisible(true);
                    }
                    GUIUtils.setOpaque(false, OverlayAd.this);
                }
                catch (NullPointerException nullPointerException) {
                    OverlayAd.this.setVisible(false);
                }
                finally {
                    OverlayAd.this._searchDone = true;
                }
            }
        }, "afterSearch", null);
        loadImageThenRun.run();
    }

    private String getUrl(UISettings.ImageInfo imageInfo, boolean bl) {
        if (!imageInfo.canLink()) {
            return null;
        }
        if (bl) {
            return imageInfo.getLocalLinkUrl();
        }
        return imageInfo.getNetworkLinkUrl();
    }

    private JPanel createImagePanel(String string, String string2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        try {
            MediaTracker mediaTracker = new MediaTracker(jPanel);
            mediaTracker.addImage(this._image.getImage(), 0);
            mediaTracker.waitForID(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        jPanel.add((Component)new JLabel(this._image), "Center");
        jPanel.setMaximumSize(this.getMaximumSize());
        jPanel.setPreferredSize(this.getPreferredSize());
        jPanel.addMouseListener(new Launcher(string, string2));
        jPanel.validate();
        return jPanel;
    }

    private JPanel createTextPanel(UISettings.ImageInfo imageInfo) {
        JPanel jPanel = new JPanel(new BorderLayout());
        if (LimeWireUtils.isPro() || !imageInfo.isIntro()) {
            jPanel.add((Component)this.createNorthPanel(LimeWireUtils.isPro()), "North");
        }
        jPanel.add(Box.createHorizontalStrut(18), "West");
        JPanel jPanel2 = !imageInfo.isIntro() ? this.createGoProCenter() : this.createGettingStartedCenter();
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add(Box.createHorizontalStrut(18), "East");
        jPanel.setMaximumSize(this.getMaximumSize());
        jPanel.setPreferredSize(this.getPreferredSize());
        return jPanel;
    }

    private JPanel createCloserPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createNorthPanel(false), "North");
        return jPanel;
    }

    private JPanel createNorthPanel(boolean bl) {
        BoxPanel boxPanel = new BoxPanel(0);
        boxPanel.add(Box.createHorizontalGlue());
        if (bl) {
            JLabel jLabel = new JLabel(this.CLOSER);
            jLabel.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    OverlayAd.this.setVisible(false);
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
            boxPanel.add(jLabel);
        } else {
            boxPanel.add(Box.createVerticalStrut(this.CLOSER.getIconHeight()));
        }
        return boxPanel;
    }

    private JPanel createGettingStartedCenter() {
        JLabel jLabel = new JLabel(I18n.tr("Getting Started"));
        jLabel.setFont(new Font("Dialog", 0, 24));
        jLabel.setForeground(new Color(90, 118, 148));
        JTextArea jTextArea = new JTextArea(I18n.tr("To start using FrostWire, find the text field on the left, type in what you are looking for and click the \"Search\" button. If you are looking for only one type of content (music, video, etc...), you can narrow your search results by using the buttons above the text field."));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setForeground(new Color(0, 0, 0));
        jTextArea.setFont(new Font("Dialog", 0, 14));
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(40, 0, 5, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        String string = this.getUrl(this.introInfo, true);
        if (string != null && !string.equals("")) {
            Launcher launcher = new Launcher(string, null);
            jPanel.addMouseListener(launcher);
            jTextArea.addMouseListener(launcher);
            jLabel.addMouseListener(launcher);
            this.addMouseListener(launcher);
        }
        return jPanel;
    }

    private JPanel createGoProCenter() {
        return null;
    }

    private static interface LateImageRunner {
        public void runWithImage(ImageIcon var1, boolean var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoadImageThenRun {
        private UISettings.ImageInfo imageInfo;
        private LateImageRunner runner;
        private String backupImage;
        private ImageIcon imageIcon;
        private String newMD5;

        public LoadImageThenRun(UISettings.ImageInfo imageInfo, LateImageRunner lateImageRunner, String string, String string2) {
            this.imageInfo = imageInfo;
            this.runner = lateImageRunner;
            this.backupImage = string;
            this.newMD5 = string2;
        }

        public int getImageIconLoadStatus() {
            if (this.imageIcon == null) {
                return -1000;
            }
            return this.imageIcon.getImageLoadStatus();
        }

        public ImageIcon getImageIcon() {
            return this.imageIcon;
        }

        private ImageIcon image() {
            String string = this.imageInfo.getImageUrl();
            if (!this.imageInfo.useNetworkImage() || string == null || string.length() == 0) {
                System.out.println("LoadImageThenRun.image() - Returning simple new ImageIcon()");
                this.imageIcon = new ImageIcon();
                return this.imageIcon;
            }
            try {
                System.out.println("**OverlayAd.image() - OVERLAY AD, im going to load:" + string);
                this.imageIcon = new ImageIcon(new URL(string));
                return this.imageIcon;
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("OverlayAd.image() - MalformedURLException fail: " + malformedURLException.getMessage());
                return new ImageIcon();
            }
            catch (Exception exception) {
                System.out.println("OverlayAd.image() - Coudn't load the image...");
                exception.printStackTrace();
                return new ImageIcon();
            }
        }

        Future<Void> run() {
            return BackgroundExecutorService.submit(new Callable<Void>(){

                @Override
                public Void call() {
                    boolean bl;
                    ImageIcon imageIcon = LoadImageThenRun.this.image();
                    LoadImageThenRun.this.imageIcon = imageIcon;
                    if (imageIcon.getIconHeight() <= 0 || imageIcon.getIconHeight() <= 0) {
                        bl = true;
                        imageIcon = GUIMediator.getThemeImage(LoadImageThenRun.this.backupImage);
                    } else {
                        bl = false;
                    }
                    final ImageIcon imageIcon2 = imageIcon;
                    GUIMediator.safeInvokeLater(new Runnable(){

                        public void run() {
                            LoadImageThenRun.this.runner.runWithImage(imageIcon2, bl);
                        }
                    });
                    return null;
                }
            });
        }
    }

    private static class Launcher
    implements MouseListener {
        private final String url;
        private final String torrentUrl;

        Launcher(String string, String string2) {
            this.url = string;
            this.torrentUrl = string2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                mouseEvent.consume();
                byte[] byArray = GuiCoreMediator.getApplicationServices().getMyGUID();
                if (this.url != null && !this.url.equals("")) {
                    GUIMediator.openURL(this.url);
                }
                if (this.torrentUrl != null && !this.torrentUrl.equals("")) {
                    this.openTorrent(this.torrentUrl);
                }
            }
        }

        public void openTorrent(String string) {
            if (string == null || string.equals("")) {
                return;
            }
            try {
                URI uRI = new URI(string);
                String string2 = uRI.getScheme();
                if (string2 == null || !string2.equalsIgnoreCase("http")) {
                    return;
                }
                String string3 = uRI.getAuthority();
                if (string3 == null || string3.equals("") || string3.indexOf(32) != -1) {
                    return;
                }
                GUIMediator.instance().openTorrentURI(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                System.out.println(uRISyntaxException);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ((JComponent)mouseEvent.getComponent()).getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ((JComponent)mouseEvent.getComponent()).getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
        }
    }
}

