/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.NoGroupTableRowFilter;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultMenu;
import com.limegroup.gnutella.gui.search.SharedSearchResult;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableRowFilter;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.limewire.io.NetworkUtils;

public class MySharedFilesResultPanel
extends ResultPanel {
    protected static final String MY_SHARED_FILES_TABLE = "MY_SHARED_FILES_TABLE";
    Action STOP_SHARING_FILE_LISTENER;
    private JLabel filesLabel;
    private final HostData blankHostData;
    private final FileEventListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MySharedFilesResultPanel(String string, FileManager fileManager) {
        super(string, MY_SHARED_FILES_TABLE);
        this.TABLE.setDragEnabled(false);
        this.TABLE.setTransferHandler(null);
        this.BUTTON_ROW.setButtonsEnabled(false);
        this.SOUTH_PANEL.setVisible(false);
        this.blankHostData = new HostData(GuiCoreMediator.getApplicationServices().getMyGUID(), this.guid.bytes(), ConnectionSettings.CONNECTION_SPEED.getValue(), !GuiCoreMediator.getNetworkManager().acceptedIncomingConnection(), false, false, ChatSettings.CHAT_ENABLED.getValue(), false, false, NetworkUtils.ip2string(GuiCoreMediator.getNetworkManager().getAddress()), GuiCoreMediator.getNetworkManager().getPort(), 0, "LIME", GuiCoreMediator.getConnectionManager().getPushProxies(), GuiCoreMediator.getNetworkManager().canDoFWT(), GuiCoreMediator.getNetworkManager().supportsFWTVersion(), SSLSettings.isIncomingTLSEnabled());
        FileManager fileManager2 = fileManager;
        synchronized (fileManager2) {
            int n = 0;
            while (fileManager.isValidIndex(n)) {
                FileDesc fileDesc = fileManager.get(n);
                if (fileDesc != null && this.shouldDisplayAddedFile(fileDesc)) {
                    this.addFile(fileDesc);
                }
                ++n;
            }
        }
        this.listener = this.createUpdateListener();
    }

    private boolean shouldDisplayAddedFile(FileDesc fileDesc) {
        if (fileDesc instanceof IncompleteFileDesc) {
            return false;
        }
        return !SharingUtils.isForcedShare(fileDesc);
    }

    private void addFile(FileDesc fileDesc) {
        Response response = GuiCoreMediator.getResponseFactory().createResponse(fileDesc);
        List<LimeXMLDocument> list = fileDesc.getLimeXMLDocuments();
        if (list.size() == 1) {
            response.setDocument(list.get(0));
        }
        Set set = Collections.emptySet();
        RemoteFileDesc remoteFileDesc = response.toRemoteFileDesc(this.blankHostData, GuiCoreMediator.getRemoteFileDescFactory());
        SharedSearchResult sharedSearchResult = new SharedSearchResult(fileDesc, remoteFileDesc, set);
        this.add(sharedSearchResult);
    }

    private void removeFile(FileDesc fileDesc) {
        for (int i = 0; i < ((TableRowFilter)this.DATA_MODEL).getRowCount(); ++i) {
            TableLine tableLine = this.getLine(i);
            SearchResult searchResult = (SearchResult)tableLine.getInitializeObject();
            if (!((SharedSearchResult)searchResult).getFileDesc().equals(fileDesc)) continue;
            this.remove(searchResult);
        }
    }

    protected void buildListeners() {
        super.buildListeners();
        this.STOP_SHARING_FILE_LISTENER = new UnshareFileAction();
    }

    public JPopupMenu createPopupMenu() {
        TableLine[] tableLineArray = this.getAllSelectedLines();
        if (tableLineArray.length == 0) {
            return null;
        }
        return new SearchResultMenu(this).addToMenu(new JPopupMenu(), tableLineArray, true, false);
    }

    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
    }

    protected void setupDataModel() {
        this.DATA_MODEL = new NoGroupTableRowFilter(this.FILTER);
    }

    public void handleNoSelection() {
        this.BUTTON_ROW.setButtonsEnabled(false);
    }

    public void handleSelection(int n) {
        this.BUTTON_ROW.setButtonsEnabled(false);
    }

    public void handleActionKey() {
    }

    protected void setupMainPanel() {
        this.MAIN_PANEL.add(this.createMyFilesInfoPanel());
        this.setupMainPanelBase();
    }

    private void refreshNumFiles() {
        String string = I18n.tr("You are sharing {0} files. You can control which files FrostWire shares.", GuiCoreMediator.getFileManager().getNumFiles());
        this.filesLabel.setText("<html><font color=\"#7B5100\"><b>" + string + "</b></font></html>");
    }

    private JComponent createMyFilesInfoPanel() {
        JPanel jPanel = this.createWarningDitherPanel();
        String string = I18n.tr("Configure");
        String string2 = I18n.tr("Library");
        jPanel.setLayout(new FlowLayout(0, 3, 3));
        jPanel.add(new JLabel(GUIMediator.getThemeImage("warn-triangle")));
        this.filesLabel = new JLabel();
        this.refreshNumFiles();
        jPanel.add(this.filesLabel);
        jPanel.add(Box.createHorizontalStrut(2));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsMediator optionsMediator = OptionsMediator.instance();
                optionsMediator.setOptionsVisible(true, "OPTIONS_SHARED_MAIN_TITLE");
            }
        };
        abstractAction.putValue("Name", "<b>" + string + "</b>");
        abstractAction.putValue("LimeColor", new Color(172, 113, 0));
        jPanel.add(new URLLabel(abstractAction));
        jPanel.add(Box.createHorizontalStrut(2));
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().getMainFrame().setSelectedTab(GUIMediator.Tabs.LIBRARY);
            }
        };
        abstractAction2.putValue("Name", "<b>" + string2 + "</b>");
        abstractAction2.putValue("LimeColor", new Color(172, 113, 0));
        jPanel.add(new URLLabel(abstractAction2));
        Dimension dimension = jPanel.getPreferredSize();
        dimension.width = Short.MAX_VALUE;
        jPanel.setMaximumSize(dimension);
        return jPanel;
    }

    public void cleanup() {
        GuiCoreMediator.getFileManager().removeFileEventListener(this.listener);
    }

    private FileEventListener createUpdateListener() {
        FileEventListener fileEventListener = new FileEventListener(){

            public void handleFileEvent(final FileManagerEvent fileManagerEvent) {
                switch (fileManagerEvent.getType()) {
                    case ADD_FILE: 
                    case REMOVE_FILE: {
                        GUIMediator.safeInvokeLater(new Runnable(){

                            public void run() {
                                if (fileManagerEvent.getType() == FileManagerEvent.Type.ADD_FILE) {
                                    if (MySharedFilesResultPanel.this.shouldDisplayAddedFile(fileManagerEvent.getFileDescs()[0])) {
                                        MySharedFilesResultPanel.this.addFile(fileManagerEvent.getFileDescs()[0]);
                                    }
                                } else {
                                    MySharedFilesResultPanel.this.removeFile(fileManagerEvent.getFileDescs()[0]);
                                }
                                MySharedFilesResultPanel.this.refreshNumFiles();
                            }
                        });
                    }
                }
            }
        };
        GuiCoreMediator.getFileManager().addFileEventListener(fileEventListener);
        return fileEventListener;
    }

    private class UnshareFileAction
    extends AbstractAction {
        public UnshareFileAction() {
            this.putValue("Name", I18n.tr("Stop Sharing File"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = MySharedFilesResultPanel.this.TABLE.getSelectedRows();
            final FileDesc[] fileDescArray = new FileDesc[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                FileDesc fileDesc;
                TableLine tableLine = MySharedFilesResultPanel.this.getLine(nArray[n]);
                SearchResult searchResult = (SearchResult)tableLine.getInitializeObject();
                fileDescArray[n] = fileDesc = ((SharedSearchResult)searchResult).getFileDesc();
            }
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    for (int i = 0; i < fileDescArray.length; ++i) {
                        FileDesc fileDesc = fileDescArray[i];
                        GuiCoreMediator.getFileManager().stopSharingFile(fileDesc.getFile());
                    }
                }
            });
            for (n = fileDescArray.length - 1; n >= 0; --n) {
                ((TableRowFilter)MySharedFilesResultPanel.this.DATA_MODEL).remove(nArray[n]);
            }
            MySharedFilesResultPanel.this.refreshNumFiles();
        }
    }
}

