/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.CheckBoxListPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagnetClipboardListener
extends WindowAdapter {
    private static final Log LOG = LogFactory.getLog(MagnetClipboardListener.class);
    private static final MagnetClipboardListener instance = new MagnetClipboardListener();
    private final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final StringSelection empty = new StringSelection("");
    private volatile String copiedText;
    private final ExecutorService clipboardParser = ExecutorsHelper.newProcessingQueue("clipboard parser");
    private Runnable parser = new Runnable(){

        public void run() {
            MagnetClipboardListener.this.parseAndLaunch();
        }
    };

    private void parseAndLaunch() {
        Transferable transferable = null;
        try {
            transferable = this.CLIPBOARD.getContents(this);
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        if (transferable == null) {
            return;
        }
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        String string = null;
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (IOException iOException) {
            LOG.info("problem occured while trying to parse clipboard, do nothing", iOException);
            return;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            LOG.error("UnsupportedFlavor??", unsupportedFlavorException);
            return;
        }
        if (string == null) {
            return;
        }
        String string2 = this.copiedText;
        if (string2 != null && string2.equals(string)) {
            return;
        }
        MagnetOptions[] magnetOptionsArray = MagnetOptions.parseMagnets(string);
        if (magnetOptionsArray.length == 0) {
            return;
        }
        LOG.info("clipboard contains " + string);
        this.purgeClipboard();
        MagnetClipboardListener.handleMagnets(magnetOptionsArray, true);
    }

    private MagnetClipboardListener() {
    }

    public static MagnetClipboardListener getInstance() {
        return instance;
    }

    public void setCopiedText(String string) {
        this.copiedText = string;
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.clipboardParser.execute(this.parser);
    }

    private void purgeClipboard() {
        try {
            this.CLIPBOARD.setContents(this.empty, this.empty);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void handleMagnets(final MagnetOptions[] magnetOptionsArray, final boolean bl) {
        final MagnetOptions[] magnetOptionsArray2 = MagnetClipboardListener.extractDownloadableMagnets(magnetOptionsArray);
        Runnable runnable = new Runnable(){

            public void run() {
                Object object;
                int n;
                Object object2;
                if (!bl) {
                    object2 = magnetOptionsArray2;
                    n = ((MagnetOptions[])object2).length;
                    for (int i = 0; i < n; ++i) {
                        object = object2[i];
                        DownloaderUtils.createDownloader((MagnetOptions)object);
                    }
                } else if (magnetOptionsArray2.length > 0) {
                    object2 = MagnetClipboardListener.showStartDownloadsDialog(magnetOptionsArray2);
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        MagnetOptions magnetOptions = (MagnetOptions)iterator.next();
                        DownloaderUtils.createDownloader(magnetOptions);
                    }
                }
                boolean bl2 = false;
                for (n = 0; n < magnetOptionsArray.length; ++n) {
                    String string;
                    if (magnetOptionsArray[n].isDownloadable() || !magnetOptionsArray[n].isKeywordTopicOnly() || bl2 || SearchMediator.validateInfo((SearchInformation)(object = SearchInformation.createKeywordSearch(string = QueryUtils.createQueryString(magnetOptionsArray[n].getKeywordTopic()), null, MediaType.getAnyTypeMediaType()))) != 0) continue;
                    bl2 = true;
                    SearchMediator.triggerSearch((SearchInformation)object);
                }
                GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
            }
        };
        GUIMediator.safeInvokeLater(runnable);
    }

    private static MagnetOptions[] extractDownloadableMagnets(MagnetOptions[] magnetOptionsArray) {
        ArrayList<MagnetOptions> arrayList = new ArrayList<MagnetOptions>(magnetOptionsArray.length);
        for (int i = 0; i < magnetOptionsArray.length; ++i) {
            MagnetOptions magnetOptions = magnetOptionsArray[i];
            if (magnetOptions.isKeywordTopicOnly()) continue;
            arrayList.add(magnetOptionsArray[i]);
        }
        if (arrayList.size() == magnetOptionsArray.length) {
            return magnetOptionsArray;
        }
        return arrayList.toArray(new MagnetOptions[0]);
    }

    private static List<MagnetOptions> showStartDownloadsDialog(MagnetOptions[] magnetOptionsArray) {
        CheckBoxListPanel<MagnetOptions> checkBoxListPanel = new CheckBoxListPanel<MagnetOptions>(Arrays.asList(magnetOptionsArray), new MagnetOptionsTextProvider(), true);
        checkBoxListPanel.getList().setVisibleRowCount(5);
        Object[] objectArray = new Object[]{new MultiLineLabel(I18n.tr("Would you like to start downloads from the following magnets?"), 400), Box.createVerticalStrut(6), checkBoxListPanel, Box.createVerticalStrut(6), new MultiLineLabel(I18n.tr("All folders you select will also have their subfolders shared."), 400)};
        int n = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), objectArray, I18n.tr("Message"), 0);
        List<MagnetOptions> list = checkBoxListPanel.getSelectedElements();
        if (n == 0) {
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MagnetOptionsTextProvider
    implements CheckBoxList.TextProvider<MagnetOptions> {
        private MagnetOptionsTextProvider() {
        }

        @Override
        public String getText(MagnetOptions magnetOptions) {
            String string = magnetOptions.getDisplayName();
            if (string == null) {
                string = I18n.tr("No Filename");
            }
            return string;
        }

        @Override
        public String getToolTipText(MagnetOptions magnetOptions) {
            return GUIUtils.restrictWidth(magnetOptions.toString(), 400);
        }

        @Override
        public Icon getIcon(MagnetOptions magnetOptions) {
            return null;
        }
    }
}

