/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.gui.xml.XMLValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;

class FieldFilter
implements TableLineFilter {
    private final String SCHEMA;
    private final String FIELD;
    private final XMLValue VALUE;

    FieldFilter(String string, String string2, XMLValue xMLValue) {
        if (string == null) {
            throw new NullPointerException("null schema");
        }
        if (string2 == null) {
            throw new NullPointerException("null field");
        }
        if (xMLValue == null) {
            throw new NullPointerException("null value");
        }
        this.SCHEMA = string;
        this.FIELD = string2;
        this.VALUE = xMLValue;
    }

    public boolean allow(TableLine tableLine) {
        LimeXMLDocument limeXMLDocument = tableLine.getXMLDocument();
        return limeXMLDocument != null && this.SCHEMA.equals(limeXMLDocument.getSchema().getDescription()) && this.VALUE.getValue().equalsIgnoreCase(limeXMLDocument.getValue(this.FIELD));
    }

    public boolean equals(Object object) {
        if (!(object instanceof FieldFilter)) {
            return false;
        }
        FieldFilter fieldFilter = (FieldFilter)object;
        return this.SCHEMA.equals(fieldFilter.SCHEMA) && this.FIELD.equals(fieldFilter.FIELD) && this.VALUE.equals(fieldFilter.VALUE);
    }
}

