/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.FilterSettings;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EndpointHolder
implements Comparable<EndpointHolder> {
    private static final String MULTIPLE = I18n.tr("Multiple");
    private final String _hostName;
    private final int _port;
    private boolean _isPrivate;
    private String _tag;
    private Set<String> _hosts;
    private int _hardCodedNumLocations = -1;

    EndpointHolder(String string, int n, boolean bl) {
        this._hostName = string;
        this._port = n;
        this._isPrivate = !bl && GuiCoreMediator.getNetworkInstanceUtils().isPrivateAddress(string);
        this._tag = string;
    }

    void addHost(String string, int n) {
        if (this._hosts == null) {
            this._hosts = new HashSet<String>();
            this._hosts.add(this._hostName + ":" + this._port);
        }
        this._hosts.add(string + ":" + n);
        this._tag = MULTIPLE + " (" + this._hosts.size() + ")";
        this._isPrivate = false;
    }

    void addHosts(Set set) {
        if (this._hosts == null) {
            this._hosts = new HashSet<String>();
            this._hosts.add(this._hostName + ":" + this._port);
        }
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && n++ < FilterSettings.MAX_ALTS_TO_DISPLAY.getValue()) {
            IpPort ipPort = (IpPort)iterator.next();
            this._hosts.add(ipPort.getAddress() + ":" + ipPort.getPort());
        }
        this._tag = MULTIPLE + " (" + this._hosts.size() + ")";
        this._isPrivate = false;
    }

    Set<String> getHosts() {
        return this._hosts;
    }

    public void setHardCodedNumLocations(int n) {
        this._hardCodedNumLocations = n;
    }

    int numLocations() {
        if (this._hardCodedNumLocations != -1) {
            return this._hardCodedNumLocations;
        }
        return this._hosts == null ? 1 : this._hosts.size();
    }

    boolean isPrivateAddress() {
        return this._isPrivate;
    }

    public String toString() {
        return this._tag;
    }

    @Override
    public int compareTo(EndpointHolder endpointHolder) {
        int n = this.numLocations();
        int n2 = endpointHolder.numLocations();
        if (n == 1 && n2 == 1) {
            return this._tag.compareTo(endpointHolder._tag);
        }
        return n - n2;
    }
}

