/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import org.limewire.util.OSUtils;

final class CancelSearchIconProxy
implements Icon {
    private static final int PLAIN = 0;
    private static final int SELECTED = 1;
    private static final int ARMED = 2;
    private static Icon PLAIN_ICON;
    private static Icon SELECTED_ICON;
    private static Icon ARMED_ICON;
    private Icon _cancelIcon;
    private int _width;
    private int _height;
    private int _x;
    private int _y;
    private final int style;

    static CancelSearchIconProxy createPlain() {
        return new CancelSearchIconProxy(0);
    }

    static CancelSearchIconProxy createSelected() {
        return new CancelSearchIconProxy(1);
    }

    static CancelSearchIconProxy createArmed() {
        return new CancelSearchIconProxy(2);
    }

    CancelSearchIconProxy(int n) {
        this.style = n;
        this.setIcon();
    }

    private void setIcon() {
        switch (this.style) {
            case 2: {
                this._cancelIcon = ARMED_ICON;
                break;
            }
            case 1: {
                this._cancelIcon = SELECTED_ICON;
                break;
            }
            case 0: {
                this._cancelIcon = PLAIN_ICON;
            }
        }
        this._width = this._cancelIcon.getIconWidth();
        this._height = this._cancelIcon.getIconHeight();
        this._x = 0;
        this._y = 0;
    }

    static void updateTheme() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                if (ThemeSettings.isWindowsTheme() && WindowsXPIcon.isAvailable()) {
                    try {
                        PLAIN_ICON = new WindowsXPIcon(0);
                        SELECTED_ICON = new WindowsXPIcon(1);
                        ARMED_ICON = new WindowsXPIcon(2);
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (ArithmeticException arithmeticException) {
                        // empty catch block
                    }
                }
                PLAIN_ICON = GUIMediator.getThemeImage("kill");
                try {
                    SELECTED_ICON = GUIMediator.getThemeImage("kill_on");
                }
                catch (MissingResourceException missingResourceException) {
                    SELECTED_ICON = PLAIN_ICON;
                }
                ARMED_ICON = SELECTED_ICON;
            }
        });
    }

    public int getIconWidth() {
        return this._width;
    }

    public int getIconHeight() {
        return this._height;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this._x = n;
        this._y = n2;
        this._cancelIcon.paintIcon(component, graphics, n, n2);
    }

    boolean shouldKill(int n, int n2) {
        int n3 = this._x + this._width;
        int n4 = this._y + this._height;
        if (n < this._x || n > n3) {
            return false;
        }
        return n2 >= this._y && n2 <= n4;
    }

    private static class WindowsXPIcon
    implements Icon {
        private static Icon _windowsCloseIcon;
        private static final Icon NULL;
        private Component component;
        private Icon _resizedIcon;

        static boolean isAvailable() {
            if (!OSUtils.isWindowsXP() && !OSUtils.isWindowsVista() || !Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) || System.getProperty("swing.noxp") != null) {
                return false;
            }
            if (_windowsCloseIcon == NULL) {
                return false;
            }
            if (_windowsCloseIcon != null) {
                return true;
            }
            try {
                Class<?> clazz = Class.forName("com.sun.java.swing.plaf.windows.WindowsIconFactory");
                Method method = clazz.getDeclaredMethod("createFrameCloseIcon", new Class[0]);
                _windowsCloseIcon = (Icon)method.invoke(clazz, new Object[0]);
                if (_windowsCloseIcon.getIconHeight() == 0 || _windowsCloseIcon.getIconWidth() == 0) {
                    _windowsCloseIcon = NULL;
                    return false;
                }
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (SecurityException securityException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            _windowsCloseIcon = NULL;
            return false;
        }

        WindowsXPIcon(final int n) {
            Icon icon;
            JButton jButton = new JButton();
            jButton.getModel().setArmed(false);
            jButton.getModel().setPressed(false);
            jButton.getModel().setRollover(n == 2);
            jButton.getModel().setEnabled(true);
            JInternalFrame jInternalFrame = new JInternalFrame(){

                public boolean isSelected() {
                    return n != 0;
                }
            };
            jInternalFrame.getContentPane().add(jButton);
            this.component = jButton;
            this._resizedIcon = icon = ImageManipulator.resize(this, 14, 14);
            this.component = null;
        }

        public int getIconHeight() {
            if (this._resizedIcon != null) {
                return this._resizedIcon.getIconHeight();
            }
            return _windowsCloseIcon.getIconHeight();
        }

        public int getIconWidth() {
            if (this._resizedIcon != null) {
                return this._resizedIcon.getIconWidth();
            }
            return _windowsCloseIcon.getIconWidth();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this._resizedIcon != null) {
                this._resizedIcon.paintIcon(component, graphics, n, n2);
            } else {
                graphics.translate(n, n2);
                _windowsCloseIcon.paintIcon(this.component, graphics, 0, 0);
                graphics.translate(-n, -n2);
            }
        }

        static {
            NULL = new ImageIcon();
        }
    }
}

