/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.StatusBarSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class StatusBarSharedFilesPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Shared Files Indicator");
    public static final String LABEL = I18n.tr("You can display how many files you are sharing in the status bar.");
    private final String CHECK_BOX_LABEL = I18nMarker.marktr("Show Shared Files Indicator:");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public StatusBarSharedFilesPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        this.CHECK_BOX.setSelected(StatusBarSettings.SHARED_FILES_DISPLAY_ENABLED.getValue());
    }

    public boolean applyOptions() throws IOException {
        if (!this.isDirty()) {
            return false;
        }
        StatusBarSettings.SHARED_FILES_DISPLAY_ENABLED.setValue(this.CHECK_BOX.isSelected());
        GUIMediator.instance().getStatusLine().refresh();
        return false;
    }

    public boolean isDirty() {
        return StatusBarSettings.SHARED_FILES_DISPLAY_ENABLED.getValue() != this.CHECK_BOX.isSelected();
    }
}

