/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.limewire.i18n.I18nMarker;

public final class SearchSpeedPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Search Result Speed");
    public static final String LABEL = I18n.tr("You can select the minimum speed of search results to display.");
    private final JRadioButton T3_BUTTON = new JRadioButton();
    private final JRadioButton T1_BUTTON = new JRadioButton();
    private final JRadioButton CABLE_BUTTON = new JRadioButton();
    private final JRadioButton ALL_BUTTON = new JRadioButton();

    public SearchSpeedPaneItem() {
        super(TITLE, LABEL);
        String string = I18nMarker.marktr("Show Only Results of T3 Speed or Higher");
        String string2 = I18nMarker.marktr("Show Only Results of T1 Speed or Higher");
        String string3 = I18nMarker.marktr("Show Only Results of Cable/DSL Speed or Higher");
        String string4 = I18nMarker.marktr("Show All Speeds");
        String string5 = I18n.tr(string);
        String string6 = I18n.tr(string2);
        String string7 = I18n.tr(string3);
        String string8 = I18n.tr(string4);
        this.T3_BUTTON.setText(string5);
        this.T1_BUTTON.setText(string6);
        this.CABLE_BUTTON.setText(string7);
        this.ALL_BUTTON.setText(string8);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.T3_BUTTON);
        buttonGroup.add(this.T1_BUTTON);
        buttonGroup.add(this.CABLE_BUTTON);
        buttonGroup.add(this.ALL_BUTTON);
        BoxPanel boxPanel = new BoxPanel();
        boxPanel.add(Box.createHorizontalGlue());
        boxPanel.add(this.T3_BUTTON);
        boxPanel.add(this.T1_BUTTON);
        boxPanel.add(this.CABLE_BUTTON);
        boxPanel.add(this.ALL_BUTTON);
        this.add(boxPanel);
    }

    public void initOptions() {
        int n = SearchSettings.MINIMUM_SEARCH_SPEED.getValue();
        switch (n) {
            case 3000: {
                this.T3_BUTTON.setSelected(true);
                break;
            }
            case 1000: {
                this.T1_BUTTON.setSelected(true);
                break;
            }
            case 350: {
                this.CABLE_BUTTON.setSelected(true);
                break;
            }
            default: {
                this.ALL_BUTTON.setSelected(true);
            }
        }
    }

    public boolean applyOptions() throws IOException {
        int n = 3;
        n = this.T3_BUTTON.isSelected() ? 3000 : (this.T1_BUTTON.isSelected() ? 1000 : (this.CABLE_BUTTON.isSelected() ? 350 : 0));
        SearchSettings.MINIMUM_SEARCH_SPEED.setValue(n);
        return false;
    }

    public boolean isDirty() {
        switch (SearchSettings.MINIMUM_SEARCH_SPEED.getValue()) {
            case 3000: {
                return !this.T3_BUTTON.isSelected();
            }
            case 1000: {
                return !this.T1_BUTTON.isSelected();
            }
            case 350: {
                return !this.CABLE_BUTTON.isSelected();
            }
            case 0: {
                return !this.ALL_BUTTON.isSelected();
            }
        }
        return true;
    }
}

