/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.MediaSliderUI;
import com.limegroup.gnutella.gui.mp3.SongProgressBar;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JSlider;

public class SongProgressBarUI
extends MediaSliderUI {
    protected BufferedImage progressImageCache;
    private boolean paintThumb = false;
    private ThumbMouse thumbMouseListener;

    public SongProgressBarUI(SongProgressBar songProgressBar) {
        super(songProgressBar);
    }

    protected void installListeners(JSlider jSlider) {
        super.installListeners(jSlider);
        this.thumbMouseListener = new ThumbMouse();
        jSlider.addMouseListener(this.thumbMouseListener);
    }

    protected void uninstallListeners(JSlider jSlider) {
        super.uninstallListeners(jSlider);
        jSlider.removeMouseListener(this.thumbMouseListener);
    }

    public void paintTrack(Graphics graphics) {
        if (((SongProgressBar)this.slider).getProgressImage() == null) {
            super.paintTrack(graphics);
            return;
        }
        try {
            if (this.trackImageCache == null || this.progressImageCache == null) {
                this.createTrackCache();
                this.createProgressCache();
            } else if (this.isDirty) {
                if (this.slider.getOrientation() == 0) {
                    if (this.trackImageCache.getWidth() != this.contentRect.width) {
                        this.createTrackCache();
                    }
                    if (this.progressImageCache.getWidth() != this.contentRect.width / 4) {
                        this.createProgressCache();
                    }
                } else {
                    if (this.trackImageCache.getHeight() != this.contentRect.height) {
                        this.createTrackCache();
                    }
                    if (this.progressImageCache.getHeight() != this.contentRect.height / 4) {
                        this.createProgressCache();
                    }
                }
            }
            this.isDirty = false;
        }
        catch (IOException iOException) {
            super.paintTrack(graphics);
            return;
        }
        if (this.slider.getOrientation() == 0) {
            Rectangle rectangle = this.contentRect;
            int n = (rectangle.height - this.trackImageCache.getHeight()) / 2;
            SongProgressBar songProgressBar = (SongProgressBar)this.slider;
            graphics.translate(rectangle.x, rectangle.y + n);
            graphics.drawImage(this.trackImageCache, 0, 0, null);
            if (this.progressImageCache != null && this.slider.getValue() > this.slider.getMinimum()) {
                if (this.progressImageCache.getWidth() < rectangle.width / 4) {
                    this.createProgressCache();
                }
                int n2 = this.trackRect.width * songProgressBar.getValue() / this.slider.getMaximum();
                graphics.drawImage(this.progressImageCache, this.trackRect.x, 0, n2, this.progressImageCache.getHeight(), null);
            }
            if (songProgressBar.isStringPainted() && songProgressBar.getString().length() > 0) {
                FontMetrics fontMetrics = graphics.getFontMetrics(this.slider.getFont());
                int n3 = fontMetrics.getHeight();
                int n4 = this.trackRect.x + 6;
                int n5 = rectangle.height / 2 + n3 / 3 - n;
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setFont(songProgressBar.getFont());
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString(songProgressBar.getString(), n4, n5);
            }
            graphics.translate(-rectangle.x, -(rectangle.y + n));
        } else {
            super.paintTrack(graphics);
        }
    }

    public void createProgressCache() {
        if (this.slider.getOrientation() == 0) {
            SongProgressBar songProgressBar = (SongProgressBar)this.slider;
            BufferedImage bufferedImage = new BufferedImage(this.contentRect.width / 4, songProgressBar.getProgressImage().getHeight(), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(songProgressBar.getProgressImage(), 0, 0, this.contentRect.width / 4, songProgressBar.getProgressImage().getHeight(), null);
            this.progressImageCache = bufferedImage;
            graphics2D.dispose();
        } else {
            SongProgressBar songProgressBar = (SongProgressBar)this.slider;
            BufferedImage bufferedImage = new BufferedImage(songProgressBar.getProgressImage().getWidth(), (int)(this.contentRect.getHeight() / 4.0), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(songProgressBar.getProgressImage(), 0, 0, songProgressBar.getProgressImage().getWidth(), (int)(this.contentRect.getHeight() / 4.0), null);
            this.progressImageCache = bufferedImage;
            graphics2D.dispose();
        }
    }

    public void paintThumb(Graphics graphics) {
        if (!this.paintThumb || !this.slider.isEnabled()) {
            return;
        }
        super.paintThumb(graphics);
    }

    protected void mouseSkip(int n) {
        this.slider.setValue(this.valueForXPosition(n));
        this.slider.repaint();
    }

    private class ThumbMouse
    extends MouseAdapter {
        private ThumbMouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SongProgressBarUI.this.slider.isEnabled()) {
                return;
            }
            SongProgressBarUI.this.mouseSkip(mouseEvent.getX());
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!SongProgressBarUI.this.slider.isEnabled()) {
                return;
            }
            SongProgressBarUI.this.paintThumb = true;
            SongProgressBarUI.this.slider.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!SongProgressBarUI.this.slider.isEnabled()) {
                return;
            }
            SongProgressBarUI.this.paintThumb = false;
            SongProgressBarUI.this.slider.repaint();
        }
    }
}

