/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAudioInputStream
extends InputStream {
    private final RandomAccessFile file;
    private long fileBytePosition;

    public RandomAudioInputStream(RandomAccessFile randomAccessFile) {
        this.file = randomAccessFile;
        this.fileBytePosition = 0L;
    }

    public int read() throws IOException {
        int n = this.file.read();
        ++this.fileBytePosition;
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.file == null) {
            return -1;
        }
        int n3 = this.file.read(byArray, n, n2);
        this.fileBytePosition += (long)n3;
        return n3;
    }

    public int available() throws IOException {
        return (int)(this.file.length() - this.fileBytePosition);
    }

    public long skip(long l) throws IOException {
        int n = this.file.skipBytes((int)l);
        this.fileBytePosition = n;
        return n;
    }

    public void close() throws IOException {
        this.file.close();
    }
}

