/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.mp3.AudioSource;
import com.limegroup.gnutella.gui.mp3.RandomAudioInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;
import org.tritonus.share.sampled.TAudioFormat;
import org.tritonus.share.sampled.file.TAudioFileFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeAudioFormat {
    public static final String AUDIO_LENGTH_BYTES = "audio.length.bytes";
    public static final String AUDIO_LENGTH_FRAMES = "audio.length.frames";
    public static final String AUDIO_TYPE = "audio.type";
    public static final String AUDIO_FRAMERATE_FPS = "audio.framerate.fps";
    public static final String AUDIO_FRAMESIZE_BYTES = "audio.framesize.bytes";
    public static final String AUDIO_SAMPLERATE_HZ = "audio.samplerate.hz";
    public static final String AUDIO_SAMPLESIZE_BITS = "audio.samplesize.bits";
    public static final String AUDIO_CHANNELS = "audio.channels";
    private final AudioInputStream audioInputStream;
    private final SourceDataLine sourceDataLine;
    private final AudioInputStream encodedAudioInputStream;
    private final AudioSource audioSource;
    private final Map<String, Object> properties;
    private final long totalLength;
    private FloatControl gainControl;

    public LimeAudioFormat(File file, long l) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this(new AudioSource(file), l);
    }

    public LimeAudioFormat(InputStream inputStream, long l) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this(new AudioSource(inputStream), l);
    }

    public LimeAudioFormat(AudioSource audioSource, long l) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        if (audioSource == null) {
            throw new NullPointerException("Couldn't load song");
        }
        this.audioSource = audioSource;
        this.encodedAudioInputStream = LimeAudioFormat.createAudioInputStream(audioSource, l);
        this.properties = LimeAudioFormat.createProperties(audioSource);
        this.totalLength = audioSource.getFile() != null ? audioSource.getFile().length() : (long)this.encodedAudioInputStream.available();
        this.audioInputStream = LimeAudioFormat.createDecodedAudioInputStream(this.encodedAudioInputStream);
        this.sourceDataLine = this.createSourceDataLine(this.audioInputStream);
    }

    public static AudioInputStream createAudioInputStream(AudioSource audioSource, long l) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream;
        if (audioSource.getFile() != null) {
            if (l < 0L || l > audioSource.getFile().length() - 10000L) {
                l = 0L;
            }
            if (audioSource.getFile().getName().toLowerCase(Locale.US).endsWith(".mp3")) {
                RandomAudioInputStream randomAudioInputStream = new RandomAudioInputStream(new RandomAccessFile(audioSource.getFile(), "rw"));
                randomAudioInputStream.skip(l);
                try {
                    audioInputStream = AudioSystem.getAudioInputStream(randomAudioInputStream);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw iOException;
                }
            } else {
                audioInputStream = AudioSystem.getAudioInputStream(audioSource.getFile());
                audioInputStream.skip(l);
            }
        } else if (audioSource.getStream() != null) {
            audioInputStream = AudioSystem.getAudioInputStream(audioSource.getStream());
        } else if (audioSource.getURL() != null) {
            audioInputStream = AudioSystem.getAudioInputStream(audioSource.getURL().openStream());
        } else {
            throw new IllegalArgumentException("Attempting to open invalid audio source");
        }
        return audioInputStream;
    }

    public static AudioInputStream createDecodedAudioInputStream(AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, 16384);
        if (AudioSystem.isLineSupported(info)) {
            return audioInputStream;
        }
        int n = audioFormat.getSampleSizeInBits();
        if (n <= 0) {
            n = 16;
        }
        if (audioFormat.getEncoding() == AudioFormat.Encoding.ULAW || audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
            n = 16;
        }
        if (n != 8) {
            n = 16;
        }
        AudioFormat audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), n, audioFormat.getChannels(), audioFormat.getChannels() * (n / 8), audioFormat.getSampleRate(), false);
        info = new DataLine.Info(SourceDataLine.class, audioFormat2, 16384);
        return AudioSystem.getAudioInputStream(audioFormat2, audioInputStream);
    }

    private SourceDataLine createSourceDataLine(AudioInputStream audioInputStream) throws LineUnavailableException {
        return this.createSourceDataLine(audioInputStream, -1);
    }

    private SourceDataLine createSourceDataLine(AudioInputStream audioInputStream, int n) throws LineUnavailableException {
        if (audioInputStream == null) {
            throw new NullPointerException("input stream is null");
        }
        AudioFormat audioFormat = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
        SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
        if (n <= 0) {
            n = sourceDataLine.getBufferSize();
        }
        sourceDataLine.open(audioFormat, n);
        if (sourceDataLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            this.gainControl = (FloatControl)sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
        }
        return sourceDataLine;
    }

    private static Map<String, Object> createProperties(AudioSource audioSource) throws UnsupportedAudioFileException, IOException {
        Object object;
        AudioFileFormat audioFileFormat;
        Object object2 = new HashMap<String, Object>();
        if (audioSource.getFile() != null) {
            audioFileFormat = AudioSystem.getAudioFileFormat(audioSource.getFile());
        } else if (audioSource.getStream() != null) {
            audioFileFormat = AudioSystem.getAudioFileFormat(audioSource.getStream());
        } else {
            return object2;
        }
        if (audioFileFormat instanceof TAudioFileFormat) {
            object2 = GenericsUtils.scanForMap(((TAudioFileFormat)audioFileFormat).properties(), String.class, Object.class, GenericsUtils.ScanMode.REMOVE);
            object2 = object = new HashMap<String, Object>((Map<String, Object>)object2);
        }
        if (audioFileFormat.getByteLength() > 0) {
            object2.put((String)AUDIO_LENGTH_BYTES, audioFileFormat.getByteLength());
        }
        if (audioFileFormat.getFrameLength() > 0) {
            object2.put((String)AUDIO_LENGTH_FRAMES, audioFileFormat.getFrameLength());
        }
        if (audioFileFormat.getType() != null) {
            object2.put((String)AUDIO_TYPE, (Object)audioFileFormat.getType().toString());
        }
        if (((AudioFormat)(object = audioFileFormat.getFormat())).getFrameRate() > 0.0f) {
            object2.put(AUDIO_FRAMERATE_FPS, Float.valueOf(((AudioFormat)object).getFrameRate()));
        }
        if (((AudioFormat)object).getFrameSize() > 0) {
            object2.put(AUDIO_FRAMESIZE_BYTES, ((AudioFormat)object).getFrameSize());
        }
        if (((AudioFormat)object).getSampleRate() > 0.0f) {
            object2.put(AUDIO_SAMPLERATE_HZ, Float.valueOf(((AudioFormat)object).getSampleRate()));
        }
        if (((AudioFormat)object).getSampleSizeInBits() > 0) {
            object2.put(AUDIO_SAMPLESIZE_BITS, ((AudioFormat)object).getSampleSizeInBits());
        }
        if (((AudioFormat)object).getChannels() > 0) {
            object2.put(AUDIO_CHANNELS, ((AudioFormat)object).getChannels());
        }
        if (object instanceof TAudioFormat) {
            Map<String, Object> map = GenericsUtils.scanForMap(((TAudioFormat)object).properties(), String.class, Object.class, GenericsUtils.ScanMode.REMOVE);
            object2.putAll(map);
        }
        return object2;
    }

    public AudioSource getSource() {
        return this.audioSource;
    }

    public AudioInputStream getAudioInputStream() {
        return this.audioInputStream;
    }

    public SourceDataLine getSourceDataLine() {
        return this.sourceDataLine;
    }

    public Map<String, Object> getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        return new HashMap<String, Object>();
    }

    public long totalLength() {
        return this.totalLength;
    }

    public int available() {
        int n = -1;
        if (this.encodedAudioInputStream != null) {
            try {
                n = this.encodedAudioInputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n;
    }

    public void startSourceDataLine() {
        if (this.sourceDataLine != null && !this.sourceDataLine.isRunning()) {
            if (!this.sourceDataLine.isOpen()) {
                try {
                    this.sourceDataLine.open();
                }
                catch (LineUnavailableException lineUnavailableException) {
                    System.out.println("LimeAudioFormat.startSoutceDataLine() EXCEPTION");
                    lineUnavailableException.printStackTrace();
                    System.out.println("====");
                }
            }
            this.sourceDataLine.start();
        }
    }

    public void stopSourceDataLine() {
        if (this.sourceDataLine != null && this.sourceDataLine.isRunning()) {
            this.sourceDataLine.flush();
            this.sourceDataLine.stop();
        }
    }

    public int getEncodedStreamPosition() {
        return (int)(this.totalLength - (long)this.available());
    }

    public long seek(long l) {
        return -1L;
    }

    public void closeStreams() {
        FileUtils.close(this.encodedAudioInputStream);
        FileUtils.close(this.audioInputStream);
        if (this.sourceDataLine != null) {
            this.sourceDataLine.stop();
            this.sourceDataLine.close();
        }
    }

    public float getGainValue() {
        if (this.hasGainControl()) {
            return this.gainControl.getValue();
        }
        return 0.0f;
    }

    public float getMaximumGain() {
        if (this.hasGainControl()) {
            return this.gainControl.getMaximum();
        }
        return 0.0f;
    }

    public float getMinimumGain() {
        if (this.hasGainControl()) {
            return this.gainControl.getMinimum();
        }
        return 0.0f;
    }

    public boolean hasGainControl() {
        if (this.gainControl == null && this.sourceDataLine != null && this.sourceDataLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            this.gainControl = (FloatControl)this.sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
        }
        return this.gainControl != null;
    }

    public void setGain(double d) throws IOException {
        if (!this.hasGainControl()) {
            throw new IOException("Volume error");
        }
        double d2 = 0.5f * this.getMaximumGain() - this.getMinimumGain();
        double d3 = Math.log(10.0) / 20.0;
        double d4 = (double)this.getMinimumGain() + 1.0 / d3 * Math.log(1.0 + (Math.exp(d3 * d2) - 1.0) * d);
        this.gainControl.setValue((float)d4);
    }
}

