/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.library.RecursiveSharingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveSharingDialog
extends JDialog {
    private static final long serialVersionUID = 5104889057583433880L;
    private State state = State.CANCELLED;
    private RecursiveSharingPanel sharingPanel;
    private MultiLineLabel titleLabel;

    public RecursiveSharingDialog(Frame frame, File ... fileArray) {
        super(frame);
        this.initialize(fileArray);
    }

    public RecursiveSharingDialog(Dialog dialog, File ... fileArray) {
        super(dialog);
        this.initialize(fileArray);
    }

    private void initialize(File ... fileArray) {
        this.sharingPanel = new RecursiveSharingPanel(fileArray);
        this.sharingPanel.setRootsExpanded();
        JTree jTree = this.sharingPanel.getTree();
        jTree.setRootVisible(false);
        this.setTitle(I18n.tr("Folders to share"));
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        jComponent.setBorder(new EmptyBorder(6, 6, OSUtils.isMacOSX() ? 12 : 6, 6));
        this.titleLabel = new MultiLineLabel(I18n.tr("The following folders and subfolders will be shared.  You can uncheck any folders you do not want to share.  (You can change your shared folders at any time in FrostWire's options.)"), 400, true);
        this.titleLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
        jComponent.add((Component)this.titleLabel, "North");
        jComponent.add((Component)this.sharingPanel, "Center");
        ButtonRow buttonRow = new ButtonRow(new Action[]{new OkayAction(), new CancelAction()}, 0, 12);
        buttonRow.setBorder(new EmptyBorder(6, 0, 0, 0));
        jComponent.add((Component)buttonRow, "South");
        GUIUtils.addHideAction(this);
        this.pack();
    }

    public void setTitleText(String string) {
        this.titleLabel.setText(string, 400);
    }

    public State showChooseDialog(Component component) {
        return this.showChooseDialog(component, true);
    }

    public State showChooseDialog(Component component, boolean bl) {
        Set<File> set = this.getRootsToShare();
        if (bl && set.size() == this.sharingPanel.getTree().getRowCount()) {
            return State.OK;
        }
        this.setModal(true);
        this.setLocationRelativeTo(component);
        this.setVisible(true);
        set = this.getRootsToShare();
        if (set.isEmpty()) {
            this.state = State.CANCELLED;
        }
        return this.state;
    }

    public Set<File> getRootsToShare() {
        return this.sharingPanel.getRootsToShare();
    }

    public Set<File> getFoldersToExclude() {
        return this.sharingPanel.getFoldersToExclude();
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(I18n.tr("Cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RecursiveSharingDialog.this.state = State.CANCELLED;
            RecursiveSharingDialog.this.dispose();
        }
    }

    private class OkayAction
    extends AbstractAction {
        public OkayAction() {
            super(I18n.tr("OK"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RecursiveSharingDialog.this.state = State.OK;
            RecursiveSharingDialog.this.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        OK,
        CANCELLED;

    }
}

