/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.ShareFileSpeciallyAction;
import com.limegroup.gnutella.gui.actions.ShareNewFolderAction;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.FileTransfer;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import com.limegroup.gnutella.gui.library.DirectoryHolder;
import com.limegroup.gnutella.gui.library.IncompleteDirectoryHolder;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibrarySearchResultsHolder;
import com.limegroup.gnutella.gui.library.LibraryTreeTransferHandler;
import com.limegroup.gnutella.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.library.SavedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.library.SharedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.library.SpeciallySharedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.library.TorrentMetaFileDirectoryHolder;
import com.limegroup.gnutella.gui.options.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.MouseObserver;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.limewire.setting.FileSetting;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;

final class LibraryTree
extends JTree
implements MouseObserver {
    private final LibraryTreeNode ROOT_NODE = new LibraryTreeNode(new RootNodeDirectoryHolder(""));
    private RootSharedFilesDirectoryHolder rsfdh = new RootSharedFilesDirectoryHolder();
    private final DefaultTreeModel TREE_MODEL = new DefaultTreeModel(this.ROOT_NODE);
    private LibraryTreeNode savedFilesNode;
    private final SavedFilesDirectoryHolder sfdh = new SavedFilesDirectoryHolder(SharingSettings.DIRECTORY_FOR_SAVING_FILES, I18n.tr("Saved Files"));
    private LibraryTreeNode sharedFilesNode;
    private LibraryTreeNode incompleteFilesNode;
    private final IncompleteDirectoryHolder idh = new IncompleteDirectoryHolder();
    private LibraryTreeNode speciallySharedFilesNode;
    private final SpeciallySharedFilesDirectoryHolder ssfdh = new SpeciallySharedFilesDirectoryHolder();
    private LibraryTreeNode searchResultsNode;
    private final LibrarySearchResultsHolder lsrdh = new LibrarySearchResultsHolder();
    private LibraryTreeNode torrentsMetaFilesNode;
    private final TorrentMetaFileDirectoryHolder tmfh = new TorrentMetaFileDirectoryHolder();
    private static final LibraryTree INSTANCE = new LibraryTree();
    private final JPopupMenu DIRECTORY_POPUP = new JPopupMenu();
    private Action shareAction = new ShareAction();
    private Action unshareAction = new UnshareAction();
    private Action addDirToPlaylistAction = new AddDirectoryToPlaylistAction();
    private Action refreshAction = new RefreshAction();
    private Action exploreAction = new ExploreAction();
    private Action showTorrentMetaAction = new ShowHideTorrentMetaAction();
    private ButtonRow BUTTON_ROW;

    public static LibraryTree instance() {
        return INSTANCE;
    }

    private LibraryTree() {
        this.setModel(this.TREE_MODEL);
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setEditable(false);
        this.setInvokesStopCellEditing(true);
        this.setShowsRootHandles(true);
        this.putClientProperty("JTree.lineStyle", "None");
        this.setCellRenderer(new LibraryTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.makePopupMenu();
        this.makeButtonRow();
        this.addMouseListener(new DefaultMouseListener(this));
        this.sharedFilesNode = new LibraryTreeNode(this.rsfdh);
        this.addNode(this.ROOT_NODE, this.sharedFilesNode);
        this.speciallySharedFilesNode = new LibraryTreeNode(this.ssfdh);
        this.savedFilesNode = new LibraryTreeNode(this.sfdh);
        this.addNode(this.ROOT_NODE, this.savedFilesNode);
        this.addPerMediaTypeDirectories();
        this.incompleteFilesNode = new LibraryTreeNode(this.idh);
        this.addNode(this.ROOT_NODE, this.incompleteFilesNode);
        this.searchResultsNode = new LibraryTreeNode(this.lsrdh);
        this.addNode(this.ROOT_NODE, this.searchResultsNode);
        this.torrentsMetaFilesNode = new LibraryTreeNode(this.tmfh);
        if (SharingSettings.SHOW_TORRENT_META_FILES.getValue()) {
            this.addNode(this.sharedFilesNode, this.torrentsMetaFilesNode);
        }
        this.updateTheme();
        this.setDragEnabled(true);
        this.setTransferHandler(new MulticastTransferHandler(new LibraryTreeTransferHandler(), DNDUtils.DEFAULT_TRANSFER_HANDLERS));
        this.addTreeSelectionListener(new LibraryTreeSelectionListener());
    }

    private void addNode(LibraryTreeNode libraryTreeNode, LibraryTreeNode libraryTreeNode2, boolean bl) {
        int n;
        if (libraryTreeNode.getIndex(libraryTreeNode2) != -1) {
            if (bl) {
                this.expandPath(new TreePath(libraryTreeNode.getPath()));
            }
            return;
        }
        int n2 = libraryTreeNode.getChildCount();
        if (!(libraryTreeNode2.getDirectoryHolder() instanceof SharedFilesDirectoryHolder)) {
            n = n2;
            if (n != 0 && libraryTreeNode2 == this.speciallySharedFilesNode && libraryTreeNode.getChildAt(n2 - 1) == this.torrentsMetaFilesNode) {
                --n;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                LibraryTreeNode libraryTreeNode3 = (LibraryTreeNode)libraryTreeNode.getChildAt(n);
                File file = libraryTreeNode3.getFile();
                if (libraryTreeNode3 == this.torrentsMetaFilesNode || file == null || StringUtils.compareFullPrimary(file.getName(), libraryTreeNode2.getFile().getName()) >= 0) break;
            }
        }
        this.TREE_MODEL.insertNodeInto(libraryTreeNode2, libraryTreeNode, n);
        if (bl || libraryTreeNode == this.sharedFilesNode && !this.isExpanded(new TreePath(this.sharedFilesNode.getPath()))) {
            this.expandPath(new TreePath(libraryTreeNode.getPath()));
        }
    }

    private void addNode(LibraryTreeNode libraryTreeNode, LibraryTreeNode libraryTreeNode2) {
        this.addNode(libraryTreeNode, libraryTreeNode2, false);
    }

    private void removeNode(LibraryTreeNode libraryTreeNode, LibraryTreeNode libraryTreeNode2) {
        if (libraryTreeNode == null || libraryTreeNode2 == null) {
            return;
        }
        if (libraryTreeNode.getIndex(libraryTreeNode2) == -1) {
            return;
        }
        this.TREE_MODEL.removeNodeFromParent(libraryTreeNode2);
    }

    private void addPerMediaTypeDirectories() {
        for (NamedMediaType namedMediaType : NamedMediaType.getAllNamedMediaTypes()) {
            if (namedMediaType.getMediaType().getMimeType().equals("*")) continue;
            FileSetting fileSetting = SharingSettings.getFileSettingForMediaType(namedMediaType.getMediaType());
            MediaTypeSavedFilesDirectoryHolder mediaTypeSavedFilesDirectoryHolder = new MediaTypeSavedFilesDirectoryHolder(fileSetting, namedMediaType.getName(), namedMediaType.getMediaType());
            LibraryTreeNode libraryTreeNode = new LibraryTreeNode(mediaTypeSavedFilesDirectoryHolder);
            this.addNode(this.savedFilesNode, libraryTreeNode, true);
        }
    }

    public void updateTheme() {
        Color color = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.setBackground(color);
        this.setCellRenderer(new LibraryTreeCellRenderer());
    }

    public void setInitialSelection() {
        TreePath treePath = new TreePath(this.sharedFilesNode.getPath());
        this.setSelectionPath(treePath);
    }

    private void addDirectoryToNode(File file, LibraryTreeNode libraryTreeNode, boolean bl) {
        LibraryTreeNode libraryTreeNode2;
        SharedFilesDirectoryHolder sharedFilesDirectoryHolder = new SharedFilesDirectoryHolder(file, bl);
        LibraryTreeNode libraryTreeNode3 = new LibraryTreeNode(sharedFilesDirectoryHolder);
        int n = libraryTreeNode.getChildCount();
        for (int i = n - 1; i >= 0; --i) {
            libraryTreeNode2 = (LibraryTreeNode)libraryTreeNode.getChildAt(i);
            File file2 = libraryTreeNode2.getFile();
            if (file2 == null || !file.equals(file2.getParentFile())) continue;
            this.TREE_MODEL.removeNodeFromParent(libraryTreeNode2);
            this.addNode(libraryTreeNode3, libraryTreeNode2);
        }
        File file3 = file.getParentFile();
        libraryTreeNode2 = null;
        if (file3 != null) {
            libraryTreeNode2 = this.getNodeForFolder(file3, libraryTreeNode);
        }
        if (libraryTreeNode2 == null) {
            libraryTreeNode2 = libraryTreeNode;
        }
        this.addNode(libraryTreeNode2, libraryTreeNode3);
    }

    public void handleFileManagerEvent(FileManagerEvent fileManagerEvent) {
        switch (fileManagerEvent.getType()) {
            case ADD_FILE: {
                if (!this.ssfdh.accept(fileManagerEvent.getFileDescs()[0].getFile())) break;
                this.addNode(this.sharedFilesNode, this.speciallySharedFilesNode, true);
                break;
            }
            case REMOVE_FILE: {
                if (!this.ssfdh.isEmpty()) break;
                if (this.ssfdh == this.getSelectedDirectoryHolder()) {
                    this.setSelectionPath(new TreePath(this.savedFilesNode.getPath()));
                }
                this.removeNode(this.sharedFilesNode, this.speciallySharedFilesNode);
                break;
            }
            case ADD_FOLDER: {
                File[] fileArray = fileManagerEvent.getFiles();
                this.addDirectoryToNode(fileArray[0], this.sharedFilesNode, false);
                break;
            }
            case REMOVE_FOLDER: {
                File file = fileManagerEvent.getFiles()[0];
                this.removeFolder(file, this.sharedFilesNode);
            }
        }
    }

    void removeFolder(File file, LibraryTreeNode libraryTreeNode) {
        LibraryTreeNode libraryTreeNode2 = this.getNodeForFolder(file, libraryTreeNode);
        if (libraryTreeNode2 == null) {
            return;
        }
        if (this.getSelectedNode() == libraryTreeNode2) {
            this.setSelectionPath(new TreePath(libraryTreeNode.getPath()));
        }
        int n = libraryTreeNode2.getChildCount();
        for (int i = n - 1; i >= 0; --i) {
            LibraryTreeNode libraryTreeNode3 = (LibraryTreeNode)libraryTreeNode2.getChildAt(i);
            this.TREE_MODEL.removeNodeFromParent(libraryTreeNode3);
            this.addNode(libraryTreeNode, libraryTreeNode3);
        }
        this.TREE_MODEL.removeNodeFromParent(libraryTreeNode2);
    }

    LibraryTreeNode getNodeForFolder(File file, LibraryTreeNode libraryTreeNode) {
        int n = libraryTreeNode.getChildCount();
        for (int i = n - 1; i >= 0; --i) {
            LibraryTreeNode libraryTreeNode2 = (LibraryTreeNode)libraryTreeNode.getChildAt(i);
            File file2 = libraryTreeNode2.getFile();
            if (file2 == null) continue;
            if (file2.equals(file)) {
                return libraryTreeNode2;
            }
            if (!libraryTreeNode2.isAncestorOf(file)) continue;
            return this.getNodeForFolder(file, libraryTreeNode2);
        }
        return null;
    }

    void addPlayListEntries() {
        if (this.incompleteDirectoryIsSelected() || !GUIMediator.isPlaylistVisible()) {
            return;
        }
        DirectoryHolder directoryHolder = this.getSelectedDirectoryHolder();
        if (directoryHolder == null) {
            return;
        }
        if (PlaylistMediator.getInstance() == null) {
            return;
        }
        PlaylistMediator playlistMediator = GUIMediator.getPlayList();
        if (playlistMediator == null) {
            return;
        }
        playlistMediator.addFilesToPlaylist(directoryHolder.getFiles());
    }

    private boolean canBeUnshared(LibraryTreeNode libraryTreeNode) {
        if (libraryTreeNode == null) {
            return false;
        }
        if (libraryTreeNode == this.speciallySharedFilesNode) {
            return false;
        }
        if (libraryTreeNode == this.incompleteFilesNode) {
            return false;
        }
        if (libraryTreeNode == this.sharedFilesNode) {
            return false;
        }
        if (libraryTreeNode == this.torrentsMetaFilesNode) {
            return false;
        }
        if (libraryTreeNode.getParent() == null) {
            return false;
        }
        if (libraryTreeNode.getParent() == this.sharedFilesNode) {
            return true;
        }
        return this.canBeUnshared((LibraryTreeNode)libraryTreeNode.getParent());
    }

    private boolean canBeShared(LibraryTreeNode libraryTreeNode) {
        if (libraryTreeNode == null || libraryTreeNode == this.incompleteFilesNode || libraryTreeNode == this.torrentsMetaFilesNode) {
            return false;
        }
        File file = libraryTreeNode.getDirectoryHolder().getDirectory();
        return file != null && !GuiCoreMediator.getFileManager().isFolderShared(file) && !GuiCoreMediator.getFileManager().isStoreDirectory(file);
    }

    public DirectoryHolder getSelectedDirectoryHolder() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            return ((LibraryTreeNode)treePath.getLastPathComponent()).getDirectoryHolder();
        }
        return null;
    }

    public DirectoryHolder getHolderForPoint(Point point) {
        LibraryTreeNode libraryTreeNode;
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath != null && (libraryTreeNode = (LibraryTreeNode)treePath.getLastPathComponent()) != null) {
            return libraryTreeNode.getDirectoryHolder();
        }
        return null;
    }

    boolean droppingToIncompleteFolder(Point point) {
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)treePath.getLastPathComponent();
        return libraryTreeNode == this.incompleteFilesNode;
    }

    File getSelectedDirectory() {
        LibraryTreeNode libraryTreeNode = this.getSelectedNode();
        if (libraryTreeNode == null) {
            return null;
        }
        return libraryTreeNode.getDirectoryHolder().getDirectory();
    }

    LibraryTreeNode getSelectedNode() {
        return (LibraryTreeNode)this.getLastSelectedPathComponent();
    }

    File[] getSharedDirectories() {
        int n = this.sharedFilesNode.getChildCount();
        ArrayList<File> arrayList = new ArrayList<File>(n);
        for (int i = 0; i < n - 1; ++i) {
            LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.sharedFilesNode.getChildAt(i);
            if (libraryTreeNode == this.speciallySharedFilesNode || libraryTreeNode == this.torrentsMetaFilesNode) continue;
            arrayList.add(libraryTreeNode.getDirectoryHolder().getDirectory());
        }
        return arrayList.toArray(new File[0]);
    }

    void clear() {
        boolean bl = false;
        int n = this.sharedFilesNode.getChildCount();
        for (int i = n - 1; i >= 0; --i) {
            TreeNode treeNode = this.sharedFilesNode.getChildAt(i);
            if (treeNode == this.getSelectedNode()) {
                bl = true;
            }
            if (treeNode == this.torrentsMetaFilesNode) continue;
            this.sharedFilesNode.remove(i);
        }
        if (bl) {
            this.setSelectionPath(new TreePath(this.sharedFilesNode));
        }
        bl = false;
        this.TREE_MODEL.reload();
    }

    void unshareLibraryFolder() {
        LibraryTreeNode libraryTreeNode = this.getSelectedNode();
        if (libraryTreeNode == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            this.showIncompleteFolderMessage();
        } else if (!this.canBeUnshared(libraryTreeNode)) {
            GUIMediator.showMessage(I18n.tr("FrostWire cannot stop sharing this folder."));
        } else {
            String string = I18n.tr("Are you sure you want to stop sharing this folder?");
            DialogOption dialogOption = GUIMediator.showYesNoMessage(string, QuestionsHandler.UNSHARE_DIRECTORY, DialogOption.YES);
            if (dialogOption != DialogOption.YES) {
                return;
            }
            final File file = libraryTreeNode.getFile();
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    GuiCoreMediator.getFileManager().removeFolderIfShared(file);
                }
            });
        }
    }

    boolean incompleteDirectoryIsSelected() {
        LibraryTreeNode libraryTreeNode = this.getSelectedNode();
        return this.incompleteFilesNode == libraryTreeNode;
    }

    boolean searchResultDirectoryIsSelected() {
        LibraryTreeNode libraryTreeNode = this.getSelectedNode();
        return libraryTreeNode == this.searchResultsNode;
    }

    boolean savedDirectoryIsSelected() {
        return this.isSavedDirectory(this.getSelectedNode());
    }

    boolean sharedFoldersNodeIsSelected() {
        return this.getSelectedNode() == this.sharedFilesNode;
    }

    private boolean isSavedDirectory(LibraryTreeNode libraryTreeNode) {
        return libraryTreeNode == this.savedFilesNode || libraryTreeNode != null && libraryTreeNode.getParent() == this.savedFilesNode;
    }

    private void showIncompleteFolderMessage() {
        GUIMediator.showError(I18n.tr("FrostWire will not allow you delete to the folder reserved for incomplete files."));
    }

    private boolean isEnqueueable() {
        File[] fileArray;
        LibraryTreeNode libraryTreeNode = this.getSelectedNode();
        boolean bl = false;
        if (libraryTreeNode != null && libraryTreeNode != this.incompleteFilesNode && libraryTreeNode != this.sharedFilesNode && (fileArray = libraryTreeNode.getDirectoryHolder().getFiles()) != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!GUIMediator.isPlaylistVisible() || !PlaylistMediator.isPlayableFile(fileArray[i])) continue;
                bl = true;
            }
        }
        return bl;
    }

    public void setPlayerEnabled(boolean bl) {
        this.addDirToPlaylistAction.setEnabled(this.isEnqueueable());
    }

    private void makePopupMenu() {
        this.DIRECTORY_POPUP.add(new JMenuItem(this.shareAction));
        this.DIRECTORY_POPUP.add(new JMenuItem(this.unshareAction));
        this.DIRECTORY_POPUP.add(new JMenuItem(this.addDirToPlaylistAction));
        this.DIRECTORY_POPUP.addSeparator();
        this.DIRECTORY_POPUP.add(new JMenuItem(new ShareFileSpeciallyAction()));
        this.DIRECTORY_POPUP.add(new JMenuItem(new ShareNewFolderAction()));
        this.DIRECTORY_POPUP.addSeparator();
        this.DIRECTORY_POPUP.add(new JMenuItem(this.showTorrentMetaAction));
        this.DIRECTORY_POPUP.addSeparator();
        this.DIRECTORY_POPUP.add(new JMenuItem(this.refreshAction));
        if (this.hasExploreAction()) {
            this.DIRECTORY_POPUP.add(new JMenuItem(this.exploreAction));
        }
        this.DIRECTORY_POPUP.addSeparator();
        this.DIRECTORY_POPUP.add(new JMenuItem(new ConfigureOptionsAction("OPTIONS_SHARED_MAIN_TITLE", I18n.tr("Configure Sharing Options"), I18n.tr("You can configure the folders you share in FrostWire's Options."))));
    }

    private boolean hasExploreAction() {
        return OSUtils.isWindows() || OSUtils.isMacOSX();
    }

    private void makeButtonRow() {
        this.BUTTON_ROW = this.hasExploreAction() ? new ButtonRow(new Action[]{this.refreshAction, this.exploreAction}, 0, 14) : new ButtonRow(new Action[]{this.refreshAction}, 0, 14);
    }

    public Component getButtonRow() {
        return this.BUTTON_ROW;
    }

    public void handleMouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void handleRightMouseClick(MouseEvent mouseEvent) {
    }

    public void handlePopupMenu(MouseEvent mouseEvent) {
        int n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n == -1) {
            return;
        }
        this.setSelectionRow(n);
        this.DIRECTORY_POPUP.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    public boolean setSelectedDirectory(File file) {
        if (file == null || !file.isDirectory()) {
            return false;
        }
        LibraryTreeNode libraryTreeNode = this.getNodeForFolder(file, this.sharedFilesNode);
        if (libraryTreeNode == null) {
            return false;
        }
        this.setSelectionPath(new TreePath(libraryTreeNode.getPath()));
        return true;
    }

    void setSearchResultsNodeSelected() {
        this.clearSelection();
        TreePath treePath = new TreePath(new Object[]{this.ROOT_NODE, this.searchResultsNode});
        this.scrollPathToVisible(treePath);
        this.setSelectionPath(treePath);
    }

    LibrarySearchResultsHolder getSearchResultsHolder() {
        return this.lsrdh;
    }

    private class ExploreAction
    extends AbstractAction {
        public ExploreAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Library Folder"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = LibraryTree.this.getSelectedDirectory();
            if (file == null) {
                return;
            }
            GUIMediator.launchExplorer(file);
        }
    }

    private class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            this.putValue("Name", I18n.tr("Refresh"));
            this.putValue("ShortDescription", I18n.tr("Reload Shared Folders"));
            this.putValue("LimeIconName", "LIBRARY_REFRESH");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GuiCoreMediator.getFileManager().loadSettings();
        }
    }

    private class ShowHideTorrentMetaAction
    extends AbstractAction {
        private String hideMetaFilesLabel = I18n.tr("Hide .torrent Files");
        private String showMetaFilesLabel = I18n.tr("Show .torrent Files");

        public ShowHideTorrentMetaAction() {
            if (SharingSettings.SHOW_TORRENT_META_FILES.getValue()) {
                this.putValue("Name", this.hideMetaFilesLabel);
            } else {
                this.putValue("Name", this.showMetaFilesLabel);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!LibraryTree.this.sharedFilesNode.isNodeChild(LibraryTree.this.torrentsMetaFilesNode)) {
                LibraryTree.this.addNode(LibraryTree.this.sharedFilesNode, LibraryTree.this.torrentsMetaFilesNode);
                this.putValue("Name", this.hideMetaFilesLabel);
                SharingSettings.SHOW_TORRENT_META_FILES.setValue(true);
            } else {
                LibraryTree.this.removeNode(LibraryTree.this.sharedFilesNode, LibraryTree.this.torrentsMetaFilesNode);
                this.putValue("Name", this.showMetaFilesLabel);
                SharingSettings.SHOW_TORRENT_META_FILES.setValue(false);
            }
        }
    }

    private class ShareAction
    extends AbstractAction {
        public ShareAction() {
            this.putValue("Name", I18n.tr("Share Folder"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryMediator.instance().addSharedLibraryFolder(LibraryTree.this.getSelectedDirectory());
        }
    }

    private class LibraryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public LibraryTreeCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            LibraryTreeNode libraryTreeNode = (LibraryTreeNode)object;
            DirectoryHolder directoryHolder = libraryTreeNode.getDirectoryHolder();
            this.setText(directoryHolder.getName());
            this.setToolTipText(directoryHolder.getDescription());
            Icon icon = directoryHolder.getIcon();
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }

    private class AddDirectoryToPlaylistAction
    extends AbstractAction {
        public AddDirectoryToPlaylistAction() {
            this.putValue("Name", I18n.tr("Add Folder Contents to Playlist"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTree.this.addPlayListEntries();
        }
    }

    private class LWSDirectoryHolder
    extends RootNodeDirectoryHolder {
        public LWSDirectoryHolder() {
            super(I18n.tr("Store"));
        }

        public Icon getIcon() {
            return GUIMediator.getThemeImage("lws_small");
        }
    }

    private class UnshareAction
    extends AbstractAction {
        public UnshareAction() {
            this.putValue("Name", I18n.tr("Stop Sharing Folder"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTree.this.unshareLibraryFolder();
        }
    }

    private class RootSharedFilesDirectoryHolder
    extends RootNodeDirectoryHolder {
        public RootSharedFilesDirectoryHolder() {
            super(I18n.tr("Shared Files"));
        }

        public boolean accept(File file) {
            return GuiCoreMediator.getFileManager().isFileInCompletelySharedDirectory(file);
        }

        public Icon getIcon() {
            return GUIMediator.getThemeImage("shared_folder");
        }
    }

    private class RootNodeDirectoryHolder
    implements DirectoryHolder {
        private String name;

        public RootNodeDirectoryHolder(String string) {
            this.name = string;
        }

        public File getDirectory() {
            return null;
        }

        public String getDescription() {
            return "";
        }

        public File[] getFiles() {
            return new File[0];
        }

        public FileDesc[] getFileDescs() {
            return new FileDesc[0];
        }

        public String getName() {
            return this.name;
        }

        public boolean accept(File file) {
            return false;
        }

        public int size() {
            return 0;
        }

        public Icon getIcon() {
            return null;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean isStoreNode() {
            return false;
        }
    }

    public final class LibraryTreeNode
    extends DefaultMutableTreeNode
    implements FileTransfer {
        private DirectoryHolder _holder;

        private LibraryTreeNode(DirectoryHolder directoryHolder) {
            super(directoryHolder);
            this._holder = directoryHolder;
        }

        public DirectoryHolder getDirectoryHolder() {
            return this._holder;
        }

        public File getFile() {
            return this._holder.getDirectory();
        }

        public boolean isAncestorOf(File file) {
            File file2 = this.getFile();
            return file2 != null && file.getPath().startsWith(file2.getPath());
        }

        public boolean isParentOf(File file) {
            return file.getParentFile().equals(this.getFile());
        }

        public String toString() {
            return this.getClass().getName() + ", file: " + this.getFile();
        }
    }

    private class LibraryTreeSelectionListener
    implements TreeSelectionListener {
        private LibraryTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            LibraryTreeNode libraryTreeNode = LibraryTree.this.getSelectedNode();
            LibraryTree.this.unshareAction.setEnabled(LibraryTree.this.canBeUnshared(libraryTreeNode));
            LibraryTree.this.shareAction.setEnabled(LibraryTree.this.canBeShared(libraryTreeNode));
            LibraryTree.this.addDirToPlaylistAction.setEnabled(LibraryTree.this.isEnqueueable());
            if (libraryTreeNode == null) {
                return;
            }
            if (libraryTreeNode == LibraryTree.this.sharedFilesNode) {
                LibraryMediator.showSharedFiles();
            } else {
                LibraryMediator.updateTableFiles(libraryTreeNode.getDirectoryHolder());
            }
        }
    }
}

