/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableDataLine;
import com.limegroup.gnutella.gui.tables.ColoredCellImpl;
import com.limegroup.gnutella.gui.tables.HashBasedDataLineModel;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import java.io.File;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LibraryTableModel
extends HashBasedDataLineModel<LibraryTableDataLine, File> {
    private JTable _table;

    LibraryTableModel() {
        super(LibraryTableDataLine.class);
    }

    @Override
    public LibraryTableDataLine createDataLine() {
        return new LibraryTableDataLine(this);
    }

    void setTable(JTable jTable) {
        this._table = jTable;
    }

    @Override
    public Object refresh() {
        this.fireTableRowsUpdated(0, this.getRowCount());
        return null;
    }

    @Override
    public int add(File file) {
        return this.add(file, this.getRowCount());
    }

    @Override
    public int add(LibraryTableDataLine libraryTableDataLine, int n) {
        File file = (File)libraryTableDataLine.getInitializeObject();
        if (!this.contains(file)) {
            return this.forceAdd(libraryTableDataLine, n);
        }
        FileDesc fileDesc = libraryTableDataLine.getFileDesc();
        if (fileDesc != null) {
            n = this.getRow(file);
            ((LibraryTableDataLine)this.get(n)).setFileDesc(fileDesc);
            this.fireTableRowsUpdated(n, n);
        }
        libraryTableDataLine.cleanup();
        return -1;
    }

    void reinitialize(File file) {
        if (this.contains(file)) {
            int n = this.getRow(file);
            ((LibraryTableDataLine)this.get(n)).initialize(file);
            this.fireTableRowsUpdated(n, n);
        }
    }

    void reinitialize(File file, File file2) {
        if (this.contains(file)) {
            int n = this.getRow(file);
            ((LibraryTableDataLine)this.get(n)).initialize(file2);
            this.initializeObjectChanged(file, file2);
            this.fireTableRowsUpdated(n, n);
        }
    }

    String getType(int n) {
        return (String)((ColoredCellImpl)((LibraryTableDataLine)this.get(n)).getValueAt(3)).getValue();
    }

    File getFile(int n) {
        return (File)((LibraryTableDataLine)this.get(n)).getInitializeObject();
    }

    String getName(int n) {
        return (String)((ColoredCellImpl)((LibraryTableDataLine)this.get(n)).getValueAt(1)).getValue();
    }

    long getSize(int n) {
        return ((SizeHolder)((ColoredCellImpl)((LibraryTableDataLine)this.get(n)).getValueAt(2)).getValue()).getSize();
    }

    FileDesc getFileDesc(int n) {
        return ((LibraryTableDataLine)this.get(n)).getFileDesc();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        int n3;
        if (!LibraryMediator.isRenameEnabled()) {
            return false;
        }
        if (this.getFile(n).isDirectory()) {
            return false;
        }
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        int n4 = listSelectionModel.getMinSelectionIndex();
        return n4 == (n3 = listSelectionModel.getMaxSelectionIndex()) && n2 == 1 && this._table.getSelectedRow() == n;
    }
}

