/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.frostwire.gnutella.gui.chat.ChatMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.WindowsUtils;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.MacOSXUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.OSUtils;

final class MiscWindow
extends SetupWindow {
    private ButtonGroup _speedGroup;
    private JRadioButton _modem;
    private JRadioButton _cable;
    private JRadioButton _t1;
    private JRadioButton _t3;
    private JTextField _ircNickField;
    private JCheckBox _startup;
    private JCheckBox _filter;

    MiscWindow(SetupManager setupManager) {
        super(setupManager, I18nMarker.marktr("Miscellaneous Settings"), I18nMarker.marktr("Below, are several options that affect the performance and functionality of FrostWire."));
    }

    protected void createWindow() {
        super.createWindow();
        JPanel jPanel = new JPanel(new GridBagLayout());
        Serializable serializable = new GridBagConstraints();
        JComponent jComponent = new JPanel(new GridBagLayout());
        jComponent.setBorder(new TitledBorder(I18n.tr("Network Speed")));
        this._speedGroup = new ButtonGroup();
        this._t1 = new JRadioButton(I18n.tr("T1"));
        this._t3 = new JRadioButton(I18n.tr("T3"));
        this._modem = new JRadioButton(I18n.tr("Dial Up"));
        this._cable = new JRadioButton(I18n.tr("Broadband (or unsure)"));
        this._speedGroup.add(this._t3);
        this._speedGroup.add(this._t1);
        this._speedGroup.add(this._cable);
        this._speedGroup.add(this._modem);
        Object object = new SetupWindow.MultiLineLabel(I18n.tr("Please choose the speed of your internet connection. Setting this speed correctly is important for optimum network performance."));
        ((JComponent)object).setOpaque(false);
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
        ((JComponent)object).setForeground(Color.black);
        ((JTextArea)object).setFont(((Component)object).getFont().deriveFont(0));
        ((GridBagConstraints)serializable).anchor = 12;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 0.0;
        jComponent.add((Component)object, serializable);
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).anchor = 16;
        ((GridBagConstraints)serializable).gridwidth = 1;
        jComponent.add((Component)this._t3, serializable);
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 1;
        jComponent.add((Component)this._t1, serializable);
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).gridwidth = -1;
        jComponent.add((Component)this._cable, serializable);
        ((GridBagConstraints)serializable).insets = new Insets(0, 20, 0, 0);
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        jComponent.add((Component)this._modem, serializable);
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 10, 0);
        ((GridBagConstraints)serializable).weightx = 1.0;
        jPanel.add((Component)jComponent, serializable);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            serializable = new GridBagConstraints();
            jComponent = new JPanel(new GridBagLayout());
            jComponent.setBorder(new TitledBorder(I18n.tr("System Startup")));
            this._startup = new JCheckBox(I18n.tr("Start Automatically"));
            this._startup.setSelected(StartupSettings.RUN_ON_STARTUP.getValue());
            System.out.println("********START UP AUTOMAGICALLY?: ******" + StartupSettings.RUN_ON_STARTUP.getValue());
            object = new SetupWindow.MultiLineLabel(I18n.tr("Would you like FrostWire to start when you log into your computer? This will cause FrostWire to start faster when you use it later."));
            ((JComponent)object).setOpaque(false);
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
            ((JComponent)object).setForeground(Color.black);
            ((JTextArea)object).setFont(((Component)object).getFont().deriveFont(0));
            ((GridBagConstraints)serializable).anchor = 18;
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).weightx = 1.0;
            jComponent.add((Component)object, serializable);
            jComponent.add((Component)this._startup, serializable);
            ((GridBagConstraints)serializable).insets = new Insets(0, 0, 10, 0);
            jPanel.add((Component)jComponent, serializable);
        }
        serializable = new JPanel(new GridLayout(2, 0));
        ((JComponent)serializable).setBorder(new TitledBorder(I18n.tr("Chat Community")));
        jComponent = new SetupWindow.MultiLineLabel(I18n.tr("FrostWire's Community Chat Tab requires you to have a nickname to communicate with others in the chatrooms."));
        jComponent.setOpaque(false);
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
        jComponent.setForeground(Color.black);
        ((JTextArea)jComponent).setFont(jComponent.getFont().deriveFont(0));
        this._ircNickField = new SizedTextField(new Dimension(100, 20));
        object = new LabeledComponent(I18n.tr("Type your chat nickname here (any name):"), this._ircNickField, 130, 10);
        ((LabeledComponent)object).getBoxPanelComponent().setBorder(new EmptyBorder(0, 10, 5, 5));
        ((Container)serializable).add(jComponent);
        ((Container)serializable).add(((LabeledComponent)object).getComponent());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = -1;
        jPanel.add((Component)serializable, gridBagConstraints);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).fill = 3;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        jPanel.add((Component)new JPanel(), serializable);
        this.setSetupComponent(jPanel);
        int n = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (56 == n) {
            this._modem.setSelected(true);
        } else if (350 == n) {
            this._cable.setSelected(true);
        } else if (1000 == n) {
            this._t1.setSelected(true);
        } else if (3000 == n) {
            this._t3.setSelected(true);
        } else {
            this._cable.setSelected(true);
        }
    }

    public void applySettings(boolean bl) {
        int bl2 = this.getSpeed();
        this.setDownloadSlots(bl2);
        if (bl2 < 0 || 20000 < bl2) {
            throw new IllegalArgumentException();
        }
        ConnectionSettings.CONNECTION_SPEED.setValue(bl2);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            boolean bl3 = this._startup.isSelected();
            if (OSUtils.isMacOSX()) {
                MacOSXUtils.setLoginStatus(bl3);
            } else if (WindowsUtils.isLoginStatusAvailable()) {
                WindowsUtils.setLoginStatus(bl3);
            }
            StartupSettings.RUN_ON_STARTUP.setValue(bl3);
        }
        ChatSettings.CHAT_IRC_NICK.setValue(this._ircNickField.getText());
        ChatMediator.instance().reloadConfiguration();
    }

    private int getSpeed() {
        if (this._cable.isSelected()) {
            return 350;
        }
        if (this._t1.isSelected()) {
            return 1000;
        }
        if (this._t3.isSelected()) {
            return 3000;
        }
        return 56;
    }

    private void setDownloadSlots(int n) {
        if (n == 56) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(3);
        } else if (n == 350) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(8);
        } else if (n == 1000) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(12);
        } else if (n == 3000) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(16);
        } else {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(3);
        }
    }
}

