/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.Line;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class IntentPanel
extends JPanel {
    private final JRadioButton mightUseButton = new JRadioButton();
    private final JRadioButton willNotButton = new JRadioButton();

    public IntentPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mightUseButton);
        buttonGroup.add(this.willNotButton);
        this.setBackground(GUIUtils.hexToColor("F7F7F7"));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(GUIUtils.hexToColor("C8C8C8"), 1), BorderFactory.createLineBorder(GUIUtils.hexToColor("FBFBFB"), 3)));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        JLabel jLabel = new JLabel(I18n.tr("You're almost done!"));
        JLabel jLabel2 = new JLabel(I18n.tr("State your intent below to start using FrostWire " + LimeWireUtils.getLimeWireVersion()));
        Line line = new Line();
        MultiLineLabel multiLineLabel = new MultiLineLabel(I18n.tr("FrostWire is a peer-to-peer program for sharing authorized files only.  Installing and using the program does not consitute a license for obtaining or distributing unauthorized content."), 500);
        URLLabel uRLLabel = new URLLabel("http://www.frostwire.com/?id=terms", I18n.tr("Find out more..."));
        Ditherer ditherer = new Ditherer(GUIUtils.hexToColor("E2E2E2"), GUIUtils.hexToColor("ECECEC"), 1, new Ditherer.PolygonShader(2.0f));
        DitherPanel ditherPanel = new DitherPanel(ditherer);
        ditherPanel.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.willNotButton.setText(I18n.tr("<html><div display=\"block\" color=\"#515151\" size=\"13\">I <b>will not</b> use FrostWire {0} for copyright infringement.</div></html>", LimeWireUtils.getLimeWireVersion()));
        this.willNotButton.setOpaque(false);
        this.willNotButton.setIconTextGap(10);
        ditherPanel.add((Component)this.willNotButton, gridBagConstraints);
        ditherPanel.setBorder(BorderFactory.createEtchedBorder(GUIUtils.hexToColor("C8C8C8"), GUIUtils.hexToColor("FBFBFB")));
        DitherPanel ditherPanel2 = new DitherPanel(ditherer);
        ditherPanel2.setLayout(new GridBagLayout());
        this.mightUseButton.setText(I18n.tr("<html><div display=\"block\" color=\"#515151\" size=\"13\">I <b>might use</b> FrostWire {0} for copyright infringement.</div></html>", LimeWireUtils.getLimeWireVersion()));
        this.mightUseButton.setOpaque(false);
        this.mightUseButton.setIconTextGap(10);
        ditherPanel2.add((Component)this.mightUseButton, gridBagConstraints);
        ditherPanel2.setBorder(BorderFactory.createEtchedBorder(GUIUtils.hexToColor("C8C8C8"), GUIUtils.hexToColor("FBFBFB")));
        jLabel.setFont(jLabel.getFont().deriveFont(24.0f));
        jLabel.setForeground(GUIUtils.hexToColor("0086CA"));
        jLabel2.setFont(jLabel2.getFont().deriveFont(16.0f));
        jLabel2.setForeground(GUIUtils.hexToColor("333333"));
        multiLineLabel.setFont(multiLineLabel.getFont().deriveFont(14.0f));
        multiLineLabel.setForeground(GUIUtils.hexToColor("333333"));
        line.setColor(GUIUtils.hexToColor("C8C8C8"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 1;
        this.add((Component)jLabel, gridBagConstraints);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)line, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)multiLineLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)uRLLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(20, 70, 0, 0);
        this.add((Component)ditherPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(13, 70, 0, 0);
    }

    boolean hasSelection() {
        return this.willNotButton.isSelected() || this.mightUseButton.isSelected();
    }

    boolean isWillNot() {
        return this.willNotButton.isSelected();
    }

    void addButtonListener(ActionListener actionListener) {
        this.willNotButton.addActionListener(actionListener);
        this.mightUseButton.addActionListener(actionListener);
    }
}

