/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.bittorrent.BTDownloaderImpl;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.gui.download.DownloadDataLine;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DownloadModel
extends BasicDataLineModel<DownloadDataLine, Downloader> {
    DownloadModel() {
        super(DownloadDataLine.class);
    }

    @Override
    public DownloadDataLine createDataLine() {
        return new DownloadDataLine();
    }

    int countActiveDownloads() {
        int n = this.getRowCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)this.get(i);
            if (downloadDataLine.isInactive()) continue;
            ++n2;
        }
        return n2;
    }

    int getCurrentDownloads() {
        int n = this.getRowCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)this.get(i);
            if (!downloadDataLine.isDownloading()) continue;
            ++n2;
        }
        return n2;
    }

    double getActiveDownloadsBandwidth() {
        int n = this.getRowCount();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)this.get(i);
            if (downloadDataLine.isInactive()) continue;
            d += Math.max(downloadDataLine.getSpeed(), 0.0);
        }
        return d;
    }

    @Override
    public Object refresh() {
        int n = this.getRowCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)this.get(i);
            downloadDataLine.update();
            bl |= downloadDataLine.isInactive();
        }
        this.fireTableRowsUpdated(0, n);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    void clearCompleted() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)this.get(i);
            if (!downloadDataLine.isInactive()) continue;
            this.remove(i);
            if (downloadDataLine.getState() != Downloader.DownloadStatus.GAVE_UP) continue;
            downloadDataLine.cleanup();
        }
    }

    @Override
    public void remove(int n) {
        DownloadDataLine downloadDataLine = (DownloadDataLine)this.get(n);
        if (downloadDataLine.getState() == Downloader.DownloadStatus.COMPLETE && downloadDataLine.getDownloader() instanceof BTDownloaderImpl) {
            BTDownloaderImpl bTDownloaderImpl = (BTDownloaderImpl)downloadDataLine.getDownloader();
            bTDownloaderImpl.removeFromDownloadManager();
        }
        super.remove(n);
    }
}

