/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;

public class MagnetTransferHandler
extends LimeTransferHandler {
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, DropInfo dropInfo) {
        return this.canImport(jComponent, dataFlavorArray);
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return DNDUtils.contains(dataFlavorArray, FileTransferable.URIFlavor);
    }

    public boolean importData(JComponent jComponent, Transferable transferable, DropInfo dropInfo) {
        return this.importData(jComponent, transferable);
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            return false;
        }
        try {
            String string = (String)transferable.getTransferData(FileTransferable.URIFlavor);
            if (string.contains("xt=urn:btih")) {
                GUIMediator.instance().openTorrentMagnet(string);
                return true;
            }
            MagnetOptions[] magnetOptionsArray = MagnetOptions.parseMagnets((String)transferable.getTransferData(FileTransferable.URIFlavor));
            if (magnetOptionsArray.length > 0) {
                MagnetClipboardListener.handleMagnets(magnetOptionsArray, false);
                return true;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

