/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TitledIconBorder
extends TitledBorder {
    protected Icon icon;
    private Point textLoc = new Point();
    private Point iconLoc = new Point();
    private static final int BORDER_SPACING = 2;
    private static final int ICON_SPACING = 4;
    protected static final int TITLE_INSET_H = 8;
    private static final int EMPTY_SPACE = 4;

    public TitledIconBorder() {
        super(UIManager.getBorder("TitledBorder.border"));
    }

    public TitledIconBorder(Border border) {
        super(border);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        if (this.icon == null) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
            return;
        }
        Border border = this.getBorder();
        String string = this.getTitle();
        int n6 = n5 = this.getTitlePosition() == 0 ? 2 : this.getTitlePosition();
        if (string == null || string.equals("")) {
            if (border != null) {
                border.paintBorder(component, graphics, n, n2, n3, n4);
            }
            return;
        }
        Rectangle rectangle = new Rectangle(n + 2, n2 + 2, n3 - 4, n4 - 4);
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setFont(this.getFont(component));
        JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
        FontMetrics fontMetrics = jComponent == null ? Toolkit.getDefaultToolkit().getFontMetrics(font) : jComponent.getFontMetrics(font);
        int n7 = Math.max(this.icon.getIconHeight(), fontMetrics.getHeight());
        int n8 = fontMetrics.getDescent();
        int n9 = fontMetrics.getAscent();
        int n10 = fontMetrics.stringWidth(string) + 4 + this.icon.getIconWidth();
        Insets insets = border != null ? border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
        switch (n5) {
            case 1: {
                int n11 = n9 + n8 + (Math.max(2, 4) - 2);
                rectangle.y += n11;
                rectangle.height -= n11;
                this.textLoc.y = rectangle.y - (n8 + 2);
                this.iconLoc.y = rectangle.y + 2;
                break;
            }
            case 2: {
                int n12 = Math.max(0, n9 / 2 + 2 - 2);
                rectangle.y += n12;
                rectangle.height -= n12;
                this.textLoc.y = rectangle.y - n8 + (insets.top + n9 + n8) / 2;
                this.iconLoc.y = rectangle.y - insets.top / 2;
                break;
            }
            case 3: {
                this.textLoc.y = rectangle.y + insets.top + n9 + 2;
                this.iconLoc.y = rectangle.y - insets.top - 2;
                break;
            }
            case 4: {
                this.textLoc.y = rectangle.y + rectangle.height - (insets.bottom + n8 + 2);
                this.iconLoc.y = rectangle.y + rectangle.height + insets.bottom + 2;
                break;
            }
            case 5: {
                rectangle.height -= n7 / 2;
                this.textLoc.y = rectangle.y + rectangle.height - n8 + (n9 + n8 - insets.bottom) / 2;
                this.iconLoc.y = rectangle.y + rectangle.height + insets.bottom / 2;
                break;
            }
            case 6: {
                rectangle.height -= n7;
                this.textLoc.y = rectangle.y + rectangle.height + n9 + 2;
                this.iconLoc.y = rectangle.y + rectangle.height - 2;
            }
        }
        int n13 = 1;
        switch (n13) {
            case 1: {
                this.iconLoc.x = rectangle.x + 8 + insets.left;
                this.textLoc.x = this.iconLoc.x + this.icon.getIconWidth() + 4;
                break;
            }
            case 3: {
                this.iconLoc.x = rectangle.x + rectangle.width - (n10 + 8 + insets.right);
                this.textLoc.x = this.iconLoc.x - this.icon.getIconWidth() - 4;
                break;
            }
            case 2: {
                this.iconLoc.x = rectangle.x + (rectangle.width - n10) / 2;
                this.textLoc.x = this.iconLoc.x + this.icon.getIconWidth() + 4;
            }
        }
        if (border != null) {
            if (n5 == 2 && rectangle.y > this.textLoc.y - n9 || n5 == 5 && rectangle.y + rectangle.height < this.textLoc.y + n8) {
                Rectangle rectangle2 = new Rectangle();
                Rectangle rectangle3 = graphics.getClipBounds();
                rectangle2.setBounds(rectangle3);
                if (TitledIconBorder.computeIntersection(rectangle2, n, n2, this.iconLoc.x - 4 - n, n4)) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                rectangle2.setBounds(rectangle3);
                if (TitledIconBorder.computeIntersection(rectangle2, this.iconLoc.x + n10 + 4 + 2, n2, n + n3 - (this.iconLoc.x + n10 + 4 + 2), n4)) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (n5 == 2) {
                    rectangle2.setBounds(rectangle3);
                    if (TitledIconBorder.computeIntersection(rectangle2, this.iconLoc.x - 4, this.textLoc.y + n8, n10 + 8 + 2, n2 + n4 - this.textLoc.y - n8)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                } else {
                    rectangle2.setBounds(rectangle3);
                    if (TitledIconBorder.computeIntersection(rectangle2, this.iconLoc.x - 4, n2, n10 + 8 + 2, this.textLoc.y - n9 - n2)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
                graphics.setClip(rectangle3);
            } else {
                border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        graphics.setColor(this.getTitleColor());
        if (string.length() > 0) {
            graphics.drawString(this.getTitle(), this.textLoc.x, this.textLoc.y);
        }
        this.icon.paintIcon(component, graphics, this.iconLoc.x, this.iconLoc.y - 5);
        graphics.setFont(font);
        graphics.setColor(color);
    }

    private static boolean computeIntersection(Rectangle rectangle, int n, int n2, int n3, int n4) {
        int n5 = Math.max(n, rectangle.x);
        int n6 = Math.min(n + n3, rectangle.x + rectangle.width);
        int n7 = Math.max(n2, rectangle.y);
        int n8 = Math.min(n2 + n4, rectangle.y + rectangle.height);
        rectangle.x = n5;
        rectangle.y = n7;
        rectangle.width = n6 - n5;
        rectangle.height = n8 - n7;
        return rectangle.width > 0 && rectangle.height > 0;
    }
}

