/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.FileIconController;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UISettings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import org.limewire.collection.FixedsizeForgetfulHashMap;
import org.limewire.collection.FixedsizeForgetfulHashSet;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public class NativeFileIconController
implements FileIconController {
    private final SmartFileView VIEW;
    private final Map<String, Icon> EXTENSIONS = new HashMap<String, Icon>();
    private final Icon NULL = new ImageIcon();

    NativeFileIconController() {
        SmartFileView smartFileView = this.getNativeFileView();
        if (smartFileView == null) {
            this.VIEW = null;
        } else {
            this.VIEW = new DelegateFileView(smartFileView);
            if (UISettings.PRELOAD_NATIVE_ICONS.getValue()) {
                this.preload();
            }
        }
    }

    public boolean isValid() {
        return this.VIEW != null && this.VIEW.isViewAvailable();
    }

    public boolean isIconForFileAvailable(File file) {
        return this.VIEW.isIconCached(file);
    }

    private SmartFileView getNativeFileView() {
        if (OSUtils.isWindows()) {
            return this.constructFSVView();
        }
        return this.constructFileChooserView();
    }

    private SmartFileView constructFileChooserView() {
        JFileChooser jFileChooser = null;
        for (int i = 0; i < 10; ++i) {
            try {
                jFileChooser = new JFileChooser(){
                    {
                        FileChooserUI fileChooserUI = (FileChooserUI)ResourceManager.getNativeUI(this);
                        this.setUI(fileChooserUI);
                        this.setFileView(fileChooserUI.getFileView(this));
                    }
                };
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (jFileChooser != null) break;
        }
        if (jFileChooser == null) {
            return null;
        }
        return new SmartChooserView(jFileChooser.getFileView());
    }

    public SmartFileView constructFSVView() {
        final AtomicReference atomicReference = new AtomicReference();
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                atomicReference.set(new FSVFileView());
            }
        });
        return (SmartFileView)atomicReference.get();
    }

    public Icon getIconForFile(File file) {
        if (file == null) {
            return null;
        }
        if (this.VIEW.isIconCached(file) || file.exists()) {
            return this.VIEW.getIcon(file);
        }
        String string = FileUtils.getFileExtension(file);
        if (string != null) {
            return this.getIconForExtension(string);
        }
        return null;
    }

    public Icon getIconForExtension(String string) {
        Icon icon = this.EXTENSIONS.get(string = string.trim().toLowerCase());
        if (icon != null) {
            if (icon != this.NULL) {
                return icon;
            }
            return null;
        }
        File file = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        File file2 = new File(file, ".LimeWireIconFinder." + string);
        if (file2.exists()) {
            icon = this.VIEW.getIcon(file2);
        } else {
            try {
                FileUtils.touch(file2);
                icon = this.VIEW.getIcon(file2);
                if (icon == null) {
                    icon = this.NULL;
                }
            }
            catch (IOException iOException) {
                icon = this.NULL;
            }
        }
        file2.delete();
        this.EXTENSIONS.put(string, icon);
        this.VIEW.removeFromCache(file2);
        return icon;
    }

    private void preload() {
        ExecutorService executorService = ExecutorsHelper.newProcessingQueue("IconLoader");
        MediaType[] mediaTypeArray = MediaType.getDefaultMediaTypes();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        for (int i = 0; i < mediaTypeArray.length && atomicBoolean.get(); ++i) {
            Set<String> set = mediaTypeArray[i].getExtensions();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext() && atomicBoolean.get()) {
                final String string = iterator.next();
                executorService.execute(new Runnable(){

                    public void run() {
                        GUIMediator.safeInvokeAndWait(new Runnable(){

                            public void run() {
                                NativeFileIconController.this.getIconForExtension(string);
                                if (!NativeFileIconController.this.VIEW.isViewAvailable()) {
                                    atomicBoolean.set(false);
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    private static class SmartChooserView
    extends SmartFileView {
        private final FileView DELEGATE;
        private final Set<File> CACHE = new FixedsizeForgetfulHashSet<File>(5000, 1000);

        public SmartChooserView(FileView fileView) {
            this.DELEGATE = fileView;
        }

        public String getDescription(File file) {
            return this.DELEGATE.getDescription(file);
        }

        public Icon getIcon(File file) {
            this.CACHE.add(file);
            return this.DELEGATE.getIcon(file);
        }

        public String getName(File file) {
            return this.DELEGATE.getName(file);
        }

        public String getTypeDescription(File file) {
            return this.DELEGATE.getTypeDescription(file);
        }

        public Boolean isTraversable(File file) {
            return this.DELEGATE.isTraversable(file);
        }

        public boolean isIconCached(File file) {
            return this.CACHE.contains(file);
        }

        public boolean removeFromCache(File file) {
            return this.CACHE.remove(file);
        }
    }

    private static class FSVFileView
    extends SmartFileView {
        private final FileSystemView VIEW = FileSystemView.getFileSystemView();
        private final Map<File, Icon> CACHE = new FixedsizeForgetfulHashMap<File, Icon>(50000);

        private FSVFileView() {
        }

        public String getDescription(File file) {
            return this.VIEW.getSystemTypeDescription(file);
        }

        public Icon getIcon(File file) {
            Icon icon = this.CACHE.get(file);
            if (icon == null) {
                icon = this.VIEW.getSystemIcon(file);
                this.CACHE.put(file, icon);
            }
            return icon;
        }

        public String getName(File file) {
            return this.VIEW.getSystemDisplayName(file);
        }

        public String getTypeDescription(File file) {
            return this.VIEW.getSystemTypeDescription(file);
        }

        public Boolean isTraversable(File file) {
            return this.VIEW.isTraversable(file);
        }

        public boolean isIconCached(File file) {
            return this.CACHE.containsKey(file);
        }

        public boolean removeFromCache(File file) {
            return this.CACHE.remove(file) != null;
        }
    }

    private static class DelegateFileView
    extends SmartFileView {
        private final SmartFileView DELEGATE;
        private boolean linkFailed = false;

        DelegateFileView(SmartFileView smartFileView) {
            this.DELEGATE = smartFileView;
        }

        public boolean isViewAvailable() {
            return !this.linkFailed;
        }

        public Icon getIcon(File file) {
            try {
                Icon icon = this.DELEGATE.getIcon(file);
                return icon;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.linkFailed = true;
                return null;
            }
        }

        public String getDescription(File file) {
            try {
                return this.DELEGATE.getDescription(file);
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.linkFailed = true;
                return null;
            }
        }

        public String getName(File file) {
            try {
                return this.DELEGATE.getName(file);
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.linkFailed = true;
                return null;
            }
        }

        public String getTypeDescription(File file) {
            try {
                return this.DELEGATE.getTypeDescription(file);
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.linkFailed = true;
                return null;
            }
        }

        public Boolean isTraversable(File file) {
            try {
                return this.DELEGATE.isTraversable(file);
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.linkFailed = true;
                return null;
            }
        }

        public boolean isIconCached(File file) {
            return this.DELEGATE.isIconCached(file);
        }

        public boolean removeFromCache(File file) {
            return this.DELEGATE.removeFromCache(file);
        }
    }

    private static abstract class SmartFileView
    extends FileView {
        private SmartFileView() {
        }

        public abstract boolean isIconCached(File var1);

        public abstract boolean removeFromCache(File var1);

        public boolean isViewAvailable() {
            return true;
        }
    }
}

