/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LimeTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListEditor
extends JPanel {
    protected Vector<String> model;
    protected DefaultListModel realModel;
    protected Vector<ListDataListener> listeners = new Vector();
    private static final int DEFAULT_COLUMNS = 10;
    protected JTextField editor;
    protected JButton addButton;
    protected JButton removeButton;
    protected JList list;
    private boolean addTail = true;

    public ListEditor() {
        this(new Vector<String>());
    }

    public ListEditor(Vector<String> vector) {
        this.setLayout(new GridBagLayout());
        this.editor = new LimeTextField("");
        this.editor.setColumns(10);
        this.editor.setPreferredSize(new Dimension(500, 20));
        this.editor.setMaximumSize(new Dimension(500, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.editor, gridBagConstraints);
        AddAction addAction = new AddAction();
        this.addButton = new JButton(addAction);
        GUIUtils.bindKeyToAction(this.editor, KeyStroke.getKeyStroke(10, 0), addAction);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        RemoveAction removeAction = new RemoveAction();
        this.removeButton = new JButton(removeAction);
        this.removeButton.setEnabled(false);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.removeButton, gridBagConstraints);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListListener());
        GUIUtils.bindKeyToAction(this.list, KeyStroke.getKeyStroke(127, 0), removeAction);
        JScrollPane jScrollPane = new JScrollPane(this.list, 22, 30);
        this.setModel(vector);
        jScrollPane.setPreferredSize(new Dimension(500, 50));
        jScrollPane.setMaximumSize(new Dimension(500, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    public Vector<String> getModel() {
        return this.model;
    }

    public synchronized void setModel(Vector<String> vector) {
        this.model = vector;
        this.realModel = new DefaultListModel();
        for (int i = 0; i < vector.size(); ++i) {
            this.realModel.addElement(vector.get(i));
        }
        this.list.setModel(this.realModel);
    }

    public void setAddTail(boolean bl) {
        this.addTail = bl;
    }

    public boolean getAddTail() {
        return this.addTail;
    }

    public synchronized void removeItem(int n) {
        this.model.remove(n);
        this.realModel.remove(n);
        this.editor.setText("");
        ListDataEvent listDataEvent = new ListDataEvent(this.model, 2, n, n);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListDataListener listDataListener = this.listeners.get(i);
            listDataListener.intervalRemoved(listDataEvent);
        }
    }

    public synchronized void addListDataListener(ListDataListener listDataListener) {
        this.listeners.add(listDataListener);
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", I18n.tr("Remove"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ListEditor.this.list.getSelectedIndex();
            if (n != -1) {
                ListEditor.this.removeItem(n);
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("Name", I18n.tr("Add"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ListEditor.this.editor.getText();
            if (string.trim().equals("")) {
                return;
            }
            int n = ListEditor.this.list.getSelectedIndex();
            if (n != -1) {
                ListEditor.this.model.setElementAt(string, n);
                ListEditor.this.realModel.setElementAt(string, n);
                ListDataEvent listDataEvent = new ListDataEvent(ListEditor.this.model, 0, n, n);
                for (int i = 0; i < ListEditor.this.listeners.size(); ++i) {
                    ListDataListener listDataListener = ListEditor.this.listeners.get(i);
                    listDataListener.contentsChanged(listDataEvent);
                }
            } else {
                int n2;
                if (ListEditor.this.addTail) {
                    ListEditor.this.model.addElement(string);
                    ListEditor.this.realModel.addElement(string);
                    n2 = ListEditor.this.model.size() - 1;
                } else {
                    ListEditor.this.model.add(0, string);
                    ListEditor.this.realModel.add(0, string);
                    n2 = 0;
                }
                ListDataEvent listDataEvent = new ListDataEvent(ListEditor.this.model, 1, n2, n2);
                for (int i = 0; i < ListEditor.this.listeners.size(); ++i) {
                    ListDataListener listDataListener = ListEditor.this.listeners.get(i);
                    listDataListener.intervalAdded(listDataEvent);
                }
            }
            ListEditor.this.editor.setText("");
            ListEditor.this.list.clearSelection();
        }
    }

    private class ListListener
    implements ListSelectionListener {
        private ListListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ListEditor.this.list.isSelectionEmpty()) {
                ListEditor.this.removeButton.setEnabled(false);
            } else {
                ListEditor.this.removeButton.setEnabled(true);
            }
            Object e = ListEditor.this.list.getSelectedValue();
            if (e == null) {
                return;
            }
            ListEditor.this.editor.setText((String)e);
        }
    }
}

