/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.nio.DaapConnectionNIO;
import de.kapsi.net.daap.nio.DaapServerNIO;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.SocketFactory;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.AcceptObserver;

public class LimeDaapServerNIO
extends DaapServerNIO {
    private static final Log LOG = LogFactory.getLog(LimeDaapServerNIO.class);
    private final Map<DaapConnectionNIO, DaapController> allConnections = new HashMap<DaapConnectionNIO, DaapController>();
    private ServerSocket serverSocket;

    public LimeDaapServerNIO(Library library) {
        super(library);
        this.scheduleServices();
    }

    public LimeDaapServerNIO(Library library, DaapConfig daapConfig) {
        super(library, daapConfig);
        this.scheduleServices();
    }

    private void scheduleServices() {
        GuiCoreMediator.getCoreBackgroundExecutor().scheduleWithFixedDelay(new Runnable(){

            public void run() {
                NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        LimeDaapServerNIO limeDaapServerNIO = LimeDaapServerNIO.this;
                        synchronized (limeDaapServerNIO) {
                            if (!LimeDaapServerNIO.this.running) {
                                return;
                            }
                        }
                        LimeDaapServerNIO.this.processTimeout();
                    }
                });
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    public void bind() throws IOException {
        InetSocketAddress inetSocketAddress = this.config.getInetSocketAddress();
        int n = this.config.getBacklog();
        this.serverSocket = SocketFactory.newServerSocket(new DaapDispatcher());
        this.serverSocket.setReuseAddress(false);
        try {
            this.serverSocket.bind(inetSocketAddress, n);
        }
        catch (SocketException socketException) {
            throw new BindException(socketException.getMessage());
        }
    }

    public synchronized void run() {
        this.running = true;
    }

    protected void cancelConnection(final DaapConnectionNIO daapConnectionNIO) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            public void run() {
                SocketChannel socketChannel = daapConnectionNIO.getChannel();
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public void disconnectAll() {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                for (DaapConnectionNIO daapConnectionNIO : LimeDaapServerNIO.this.allConnections.keySet()) {
                    SocketChannel socketChannel = daapConnectionNIO.getChannel();
                    try {
                        socketChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    LimeDaapServerNIO limeDaapServerNIO = LimeDaapServerNIO.this;
                    synchronized (limeDaapServerNIO) {
                        LimeDaapServerNIO.this.libraryQueue.clear();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.disconnectAll();
        LimeDaapServerNIO limeDaapServerNIO = this;
        synchronized (limeDaapServerNIO) {
            this.running = false;
        }
    }

    protected void update() {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LimeDaapServerNIO limeDaapServerNIO = LimeDaapServerNIO.this;
                synchronized (limeDaapServerNIO) {
                    for (DaapConnectionNIO daapConnectionNIO : LimeDaapServerNIO.this.getDaapConnections()) {
                        for (int i = 0; i < LimeDaapServerNIO.this.libraryQueue.size(); ++i) {
                            daapConnectionNIO.enqueueLibrary((Library)LimeDaapServerNIO.this.libraryQueue.get(i));
                        }
                        SocketChannel socketChannel = daapConnectionNIO.getChannel();
                        try {
                            daapConnectionNIO.update();
                            DaapController daapController = (DaapController)LimeDaapServerNIO.this.allConnections.get(daapConnectionNIO);
                            daapController.setOps();
                        }
                        catch (IOException iOException) {
                            try {
                                socketChannel.close();
                            }
                            catch (IOException iOException2) {}
                        }
                    }
                    LimeDaapServerNIO.this.libraryQueue.clear();
                }
            }
        });
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private class DaapController
    implements ChannelReadObserver,
    ChannelWriter {
        private DaapConnectionNIO conn;
        private InterestReadableByteChannel readChannel;
        private InterestWritableByteChannel writeChannel;
        private boolean shutdown;

        DaapController(DaapConnectionNIO daapConnectionNIO) {
            this.conn = daapConnectionNIO;
        }

        public void handleRead() throws IOException {
            if (!this.conn.read()) {
                throw new IOException("finished");
            }
            this.setOps();
        }

        public void handleIOException(IOException iOException) {
        }

        public InterestReadableByteChannel getReadChannel() {
            return this.readChannel;
        }

        public void setReadChannel(InterestReadableByteChannel interestReadableByteChannel) {
            this.readChannel = interestReadableByteChannel;
            this.conn.setReadChannel(interestReadableByteChannel);
            this.setOps();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            DaapController daapController = this;
            synchronized (daapController) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
            }
            this.conn.close();
            LimeDaapServerNIO.this.allConnections.remove(this.conn);
            try {
                LimeDaapServerNIO.this.removeConnection(this.conn);
            }
            catch (IllegalStateException illegalStateException) {
                LOG.error("ISE", illegalStateException);
            }
        }

        public InterestWritableByteChannel getWriteChannel() {
            return this.writeChannel;
        }

        public void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
            this.conn.setWriteChannel(interestWritableByteChannel);
            this.writeChannel = interestWritableByteChannel;
            this.setOps();
        }

        public boolean handleWrite() throws IOException {
            if (!this.conn.write()) {
                throw new IOException("finished");
            }
            return this.setOps();
        }

        private boolean setOps() {
            boolean bl;
            int n = this.conn.interrestOps();
            boolean bl2 = false;
            if (this.writeChannel != null) {
                bl2 = bl = (n & 4) != 0;
                this.writeChannel.interestWrite(this, bl);
            }
            if (this.readChannel != null) {
                bl = (n & 1) != 0;
                this.readChannel.interestRead(bl);
            }
            return bl2;
        }
    }

    private class DaapDispatcher
    implements AcceptObserver {
        private DaapDispatcher() {
        }

        public void handleIOException(IOException iOException) {
        }

        public void shutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleAccept(Socket socket) throws IOException {
            Object object = this;
            synchronized (object) {
                if (!LimeDaapServerNIO.this.running) {
                    IOUtils.close(socket);
                    return;
                }
            }
            object = new DaapConnectionNIO(LimeDaapServerNIO.this, socket.getChannel());
            DaapController daapController = new DaapController((DaapConnectionNIO)object);
            socket.setSoTimeout(0);
            LimeDaapServerNIO.this.allConnections.put(object, daapController);
            LimeDaapServerNIO.this.addPendingConnection((DaapConnection)object);
            ((NIOMultiplexor)((Object)socket)).setReadObserver(daapController);
            ((NIOMultiplexor)((Object)socket)).setWriteObserver(daapController);
        }
    }
}

