/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.util.Launcher;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;
import org.limewire.util.VersionUtils;

class JavaVersionNotice {
    static final String REQUIRED = "1.5.0";
    static final String JAVA_16_BETA_VERSION = "1.6.0-beta";
    static final String JAVA_16_RC_VERSION = "1.6.0-rc";
    private static final String URL = "http://www.frostwire.com/download";

    JavaVersionNotice() {
    }

    public static boolean upgradeRequired(String string) {
        try {
            Version version = new Version(REQUIRED);
            Version version2 = new Version(string);
            if (version2.compareTo(version) < 0) {
                return true;
            }
        }
        catch (VersionFormatException versionFormatException) {
            // empty catch block
        }
        return false;
    }

    public static void showUpgradeRequiredDialog() {
        new UpgradeRequiredDialog().setVisible(true);
    }

    public static JDialog getUpgradeRecommendedDialog(String string) {
        if (QuestionsHandler.LAST_CHECKED_JAVA_VERSION.getValue().equals(string)) {
            return null;
        }
        if (string.startsWith(JAVA_16_BETA_VERSION) || string.startsWith(JAVA_16_RC_VERSION)) {
            String string2 = I18n.tr(I18nMarker.marktr("You are currently using a beta or pre-release version of Java 1.6.0. This version is known to have caused problems with FrostWire. Please upgrade to the final 1.6.0 release.\n"));
            return new UpgradeRecommendedDialog(string2);
        }
        return null;
    }

    private static class UpgradeRecommendedDialog
    extends JDialog {
        private UpgradeRecommendedDialog(String string) {
            this.setTitle(I18n.tr("Upgrade Java"));
            this.setSize(new Dimension(100, 500));
            this.setModal(true);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            MultiLineLabel multiLineLabel = new MultiLineLabel(string, 500);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createHorizontalGlue());
            jPanel2.add(multiLineLabel);
            JPanel jPanel3 = new JPanel();
            JButton jButton = new JButton(I18n.tr("More Information"));
            jButton.setToolTipText(I18n.tr(I18nMarker.marktr("Visit {0}"), JavaVersionNotice.URL));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UpgradeRecommendedDialog.this.dispose();
                    GUIMediator.openURL(JavaVersionNotice.URL);
                }
            });
            JButton jButton2 = new JButton(I18n.tr("Remind Me Later"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UpgradeRecommendedDialog.this.dispose();
                }
            });
            JButton jButton3 = new JButton(I18n.tr("Do not Show Again"));
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    QuestionsHandler.LAST_CHECKED_JAVA_VERSION.setValue(VersionUtils.getJavaVersion());
                    UpgradeRecommendedDialog.this.dispose();
                }
            });
            jPanel3.add(jButton);
            jPanel3.add(jButton2);
            jPanel3.add(jButton3);
            jPanel.add(jPanel2);
            jPanel.add(GUIMediator.getVerticalSeparator());
            jPanel.add(jPanel3);
            this.getContentPane().add(jPanel);
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        }
    }

    private static class UpgradeRequiredDialog
    extends JDialog {
        private UpgradeRequiredDialog() {
            this.setTitle("Upgrade Java");
            this.setSize(new Dimension(100, 300));
            this.setModal(true);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            String string = "FrostWire requires Java 1.5.0 or higher in order to run. You are currently running an out-of-date version of Java.  Please visit http://www.frostwire.com/download in order to upgrade your version of Java.\n\nCurrent Java Version : " + VersionUtils.getJavaVersion() + "\n" + "Required Java Version: " + JavaVersionNotice.REQUIRED + "\n\n";
            MultiLineLabel multiLineLabel = new MultiLineLabel(string, 500);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createHorizontalGlue());
            jPanel2.add(multiLineLabel);
            JPanel jPanel3 = new JPanel();
            JButton jButton = new JButton("Upgrade Java");
            jButton.setToolTipText("Visit http://www.frostwire.com/download");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Launcher.openURL(JavaVersionNotice.URL);
                    }
                    catch (IOException iOException) {
                        UpgradeRequiredDialog.this.openURLFailed();
                    }
                    System.exit(1);
                }
            });
            JButton jButton2 = new JButton("Upgrade Later");
            jButton2.setToolTipText("Exit FrostWire");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(1);
                }
            });
            jPanel3.add(jButton);
            jPanel3.add(jButton2);
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            this.getContentPane().add(jPanel);
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        }

        private void openURLFailed() {
            JOptionPane.showMessageDialog(this, "To update, please direct your web-browser to http://www.frostwire.com/download.", "Unable to open browser", 0);
        }
    }
}

