/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.filters.AllowFilter;
import com.limegroup.gnutella.filters.CompositeFilter;
import com.limegroup.gnutella.filters.DuplicateFilter;
import com.limegroup.gnutella.filters.GUIDFilter;
import com.limegroup.gnutella.filters.GreedyQueryFilter;
import com.limegroup.gnutella.filters.HashFilter;
import com.limegroup.gnutella.filters.HostileFilter;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.LocalIPFilter;
import com.limegroup.gnutella.filters.MutableGUIDFilter;
import com.limegroup.gnutella.filters.RequeryFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.filters.SpamFilterFactory;
import com.limegroup.gnutella.filters.SpamReplyFilter;
import com.limegroup.gnutella.settings.FilterSettings;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SpamFilterFactoryImpl
implements SpamFilterFactory {
    private final Provider<MutableGUIDFilter> mutableGUIDFilter;
    private final Provider<HostileFilter> hostileFilter;
    private final Provider<LocalIPFilter> ipFilter;

    @Inject
    public SpamFilterFactoryImpl(Provider<MutableGUIDFilter> provider, Provider<HostileFilter> provider2, Provider<LocalIPFilter> provider3) {
        this.mutableGUIDFilter = provider;
        this.hostileFilter = provider2;
        this.ipFilter = provider3;
    }

    @Override
    public SpamFilter createPersonalFilter() {
        SpamFilter spamFilter;
        Vector<SpamFilter> vector = new Vector<SpamFilter>();
        LocalIPFilter localIPFilter = this.ipFilter.get();
        if (localIPFilter.hasBlacklistedHosts()) {
            vector.add(localIPFilter);
        }
        String[] stringArray = FilterSettings.BANNED_WORDS.getValue();
        boolean bl = FilterSettings.FILTER_ADULT.getValue();
        boolean bl2 = FilterSettings.FILTER_VBS.getValue();
        boolean bl3 = FilterSettings.FILTER_HTML.getValue();
        boolean bl4 = FilterSettings.FILTER_WMV_ASF.getValue();
        if (stringArray.length != 0 || bl || bl2 || bl3) {
            spamFilter = new KeywordFilter();
            ((KeywordFilter)spamFilter).disallow("has shaking orgasm");
            ((KeywordFilter)spamFilter).disallow("teenfuns xxx");
            for (int i = 0; i < stringArray.length; ++i) {
                ((KeywordFilter)spamFilter).disallow(stringArray[i]);
            }
            if (bl) {
                ((KeywordFilter)spamFilter).disallowAdult();
            }
            if (bl2) {
                ((KeywordFilter)spamFilter).disallowVbs();
            }
            if (bl3) {
                ((KeywordFilter)spamFilter).disallowHtml();
            }
            if (bl4) {
                ((KeywordFilter)spamFilter).disallowWMVASF();
            }
            vector.add(spamFilter);
        }
        spamFilter = new SpamReplyFilter();
        vector.add(spamFilter);
        vector.add(this.mutableGUIDFilter.get());
        return SpamFilterFactoryImpl.compose(vector);
    }

    @Override
    public SpamFilter createRouteFilter() {
        Vector<SpamFilter> vector = new Vector<SpamFilter>();
        vector.add(new RequeryFilter());
        vector.add(new GUIDFilter());
        if (FilterSettings.FILTER_DUPLICATES.getValue()) {
            vector.add(new DuplicateFilter());
        }
        if (FilterSettings.FILTER_GREEDY_QUERIES.getValue()) {
            vector.add(new GreedyQueryFilter());
        }
        if (FilterSettings.FILTER_HASH_QUERIES.getValue()) {
            vector.add(new HashFilter());
        }
        vector.add(this.hostileFilter.get());
        return SpamFilterFactoryImpl.compose(vector);
    }

    private static SpamFilter compose(Vector<? extends SpamFilter> vector) {
        if (vector.size() == 0) {
            return new AllowFilter();
        }
        if (vector.size() == 1) {
            return vector.get(0);
        }
        Object[] objectArray = new SpamFilter[vector.size()];
        vector.copyInto(objectArray);
        return new CompositeFilter((SpamFilter[])objectArray);
    }
}

