/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.filters.AbstractIPFilter;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.IPList;
import com.limegroup.gnutella.settings.FilterSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IP;
import org.limewire.io.NetworkInstanceUtils;

@Singleton
public class HostileFilter
extends AbstractIPFilter {
    private static final Log LOG = LogFactory.getLog(HostileFilter.class);
    private volatile IPList hostileHosts = new IPList();
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public HostileFilter(NetworkInstanceUtils networkInstanceUtils) {
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public void refreshHosts(IPFilter.IPFilterCallback iPFilterCallback) {
        this.refreshHosts();
        iPFilterCallback.ipFiltersLoaded();
    }

    public void refreshHosts() {
        LOG.info(this.hashCode() + " refreshing hosts at hostile level");
        IPList iPList = new IPList();
        String[] stringArray = FilterSettings.HOSTILE_IPS.getValue();
        try {
            for (String string : stringArray) {
                iPList.add(new IP(string));
            }
            if (iPList.isValidFilter(false, this.networkInstanceUtils)) {
                this.hostileHosts = iPList;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public boolean hasBlacklistedHosts() {
        return !this.hostileHosts.isEmpty();
    }

    public int logMinDistanceTo(IP iP) {
        return this.hostileHosts.logMinDistanceTo(iP);
    }

    protected boolean allowImpl(IP iP) {
        return !this.hostileHosts.contains(iP);
    }

    public void forceRefreshHosts() {
        this.refreshHosts();
    }
}

