/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader.serial.conversion;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.downloader.serial.conversion.SerialRemoteFileDesc;
import com.limegroup.gnutella.xml.SerialXml;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerialRemoteFileDesc4x16
implements Serializable,
SerialRemoteFileDesc {
    private static final long serialVersionUID = 6619479308616716538L;
    private String _host;
    private int _port;
    private String _filename;
    private long _index;
    private byte[] _clientGUID;
    private int _speed;
    private int _size;
    private boolean _chatEnabled;
    private int _quality;
    private boolean _replyToMulticast;
    private SerialXml[] _xmlDocs;
    private Set<URN> _urns;
    private boolean _browseHostEnabled;
    private boolean _firewalled;
    private String _vendor;
    private boolean _http11;
    private Map<String, Serializable> propertiesMap;
    private transient long longSize;
    private transient boolean tlsCapable;
    private transient String httpPushAddr;

    SerialRemoteFileDesc4x16() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        if (this._urns != null && this._urns != (object = GenericsUtils.scanForSet(this._urns, URN.class, GenericsUtils.ScanMode.NEW_COPY_REMOVED, UrnSet.class))) {
            this._urns = Collections.unmodifiableSet(object);
        }
        if (this.propertiesMap != null) {
            Long l;
            String string;
            object = (Boolean)this.propertiesMap.get("CONNECT_TYPE");
            if (object != null) {
                this.tlsCapable = (Boolean)object;
            }
            if ((string = (String)((Object)this.propertiesMap.get("PUSH_ADDR"))) == null) {
                string = (String)((Object)this.propertiesMap.get("_pushAddr"));
            }
            this.longSize = (l = (Long)this.propertiesMap.get("LONG_SIZE")) == null ? (long)this._size : l;
        } else {
            this.longSize = this._size;
        }
    }

    @Override
    public boolean isTlsCapable() {
        return this.tlsCapable;
    }

    @Override
    public String getHttpPushAddr() {
        return this.httpPushAddr;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    @Override
    public long getIndex() {
        return this._index;
    }

    @Override
    public byte[] getClientGUID() {
        return this._clientGUID;
    }

    @Override
    public int getSpeed() {
        return this._speed;
    }

    @Override
    public long getSize() {
        return this.longSize;
    }

    @Override
    public boolean isChatEnabled() {
        return this._chatEnabled;
    }

    @Override
    public int getQuality() {
        return this._quality;
    }

    @Override
    public boolean isReplyToMulticast() {
        return this._replyToMulticast;
    }

    @Override
    public String getXml() {
        return this._xmlDocs != null && this._xmlDocs.length > 0 ? this._xmlDocs[0].getXml(false) : null;
    }

    @Override
    public Set<URN> getUrns() {
        return this._urns;
    }

    @Override
    public boolean isBrowseHostEnabled() {
        return this._browseHostEnabled;
    }

    @Override
    public boolean isFirewalled() {
        return this._firewalled;
    }

    @Override
    public String getVendor() {
        return this._vendor;
    }

    @Override
    public boolean isHttp11() {
        return this._http11;
    }

    @Override
    public Map<String, Serializable> getPropertiesMap() {
        return this.propertiesMap;
    }
}

