/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.AltLocFinder;
import com.limegroup.gnutella.dht.db.AltLocSearchListener;
import com.limegroup.gnutella.downloader.RequeryListener;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.settings.LookupSettings;
import org.limewire.nio.observer.Shutdownable;

class RequeryManager
implements DHTEventListener,
AltLocSearchListener {
    private static final Log LOG = LogFactory.getLog(RequeryManager.class);
    static long TIME_BETWEEN_REQUERIES = 300000L;
    private final RequeryListener requeryListener;
    private final DownloadManager downloadManager;
    private final AltLocFinder altLocFinder;
    private final DHTManager dhtManager;
    private volatile QueryType lastQueryType;
    private volatile int numDHTQueries;
    private volatile long lastQuerySent;
    protected volatile boolean sentGnutellaQuery;
    protected volatile boolean activated;
    private volatile Shutdownable dhtQuery;
    private final ConnectionServices connectionServices;
    private static final int CONNECTING_WAIT_TIME = 750;
    private static final int MIN_NUM_CONNECTIONS = 2;
    private static final int MIN_CONNECTION_MESSAGES = 6;
    private static final int MIN_TOTAL_MESSAGES = 45;
    static boolean NO_DELAY = false;

    RequeryManager(RequeryListener requeryListener, DownloadManager downloadManager, AltLocFinder altLocFinder, DHTManager dHTManager, ConnectionServices connectionServices) {
        this.requeryListener = requeryListener;
        this.downloadManager = downloadManager;
        this.altLocFinder = altLocFinder;
        this.dhtManager = dHTManager;
        this.connectionServices = connectionServices;
        dHTManager.addEventListener(this);
    }

    boolean isWaitingForResults() {
        if (this.lastQueryType == null) {
            return false;
        }
        switch (this.lastQueryType) {
            case DHT: {
                return this.dhtQuery != null && this.getTimeLeftInQuery() > 0L;
            }
            case GNUTELLA: {
                return this.getTimeLeftInQuery() > 0L;
            }
        }
        return false;
    }

    QueryType getLastQueryType() {
        return this.lastQueryType;
    }

    long getTimeLeftInQuery() {
        return TIME_BETWEEN_REQUERIES - (System.currentTimeMillis() - this.lastQuerySent);
    }

    void sendQuery() {
        if (this.canSendQueryNow()) {
            if (this.canSendDHTQueryNow()) {
                this.sendDHTQuery();
            } else if (!this.sentGnutellaQuery) {
                this.sendGnutellaQuery();
            } else {
                LOG.debug("Can send a query now, but not sending it?!");
            }
        } else {
            LOG.debug("Tried to send query, but cannot do it now.");
        }
    }

    boolean canSendQueryAfterActivate() {
        return !this.sentGnutellaQuery || this.canSendDHTQueryNow();
    }

    boolean canSendQueryNow() {
        if (LimeWireUtils.isPro()) {
            return this.canSendDHTQueryNow() || this.activated && this.canSendQueryAfterActivate();
        }
        return this.activated && this.canSendQueryAfterActivate();
    }

    void activate() {
        this.activated = true;
    }

    void cleanUp() {
        Shutdownable shutdownable = this.dhtQuery;
        this.dhtQuery = null;
        if (shutdownable != null) {
            shutdownable.shutdown();
        }
        this.dhtManager.removeEventListener(this);
    }

    public void handleDHTEvent(DHTEvent dHTEvent) {
        if (dHTEvent.getType() == DHTEvent.Type.STOPPED) {
            this.handleAltLocSearchDone(false);
            this.numDHTQueries = 0;
        }
    }

    public void handleAltLocSearchDone(boolean bl) {
        this.dhtQuery = null;
        this.requeryListener.lookupFinished(QueryType.DHT);
    }

    private boolean isDHTUp() {
        return DHTSettings.ENABLE_DHT_ALT_LOC_QUERIES.getValue() && this.dhtManager.isMemberOfDHT();
    }

    private boolean canSendDHTQueryNow() {
        if (!this.isDHTUp()) {
            return false;
        }
        return this.numDHTQueries == 0 || this.numDHTQueries < DHTSettings.MAX_DHT_ALT_LOC_QUERY_ATTEMPTS.getValue() && System.currentTimeMillis() - this.lastQuerySent >= DHTSettings.TIME_BETWEEN_DHT_ALT_LOC_QUERIES.getValue();
    }

    private void sendDHTQuery() {
        LOG.debug("Sending a DHT requery!");
        this.lastQuerySent = System.currentTimeMillis();
        this.lastQueryType = QueryType.DHT;
        ++this.numDHTQueries;
        this.requeryListener.lookupStarted(QueryType.DHT, Math.max(TIME_BETWEEN_REQUERIES, LookupSettings.FIND_VALUE_LOOKUP_TIMEOUT.getValue()));
        this.dhtQuery = this.altLocFinder.findAltLocs(this.requeryListener.getSHA1Urn(), this);
    }

    private void sendGnutellaQuery() {
        if (this.hasStableConnections()) {
            QueryRequest queryRequest = this.requeryListener.createQuery();
            if (queryRequest != null) {
                this.downloadManager.sendQuery(queryRequest);
                LOG.debug("Sent a gnutella requery!");
                this.sentGnutellaQuery = true;
                this.lastQueryType = QueryType.GNUTELLA;
                this.lastQuerySent = System.currentTimeMillis();
                this.requeryListener.lookupStarted(QueryType.GNUTELLA, TIME_BETWEEN_REQUERIES);
            } else {
                this.sentGnutellaQuery = true;
                this.requeryListener.lookupFinished(QueryType.GNUTELLA);
            }
        } else {
            LOG.debug("Tried to send a gnutella requery, but no stable connections.");
            this.requeryListener.lookupPending(QueryType.GNUTELLA, 750);
        }
    }

    private boolean hasStableConnections() {
        if (NO_DELAY) {
            return true;
        }
        return this.connectionServices.countConnectionsWithNMessages(6) >= 2 && this.connectionServices.getActiveConnectionMessages() >= 45;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueryType {
        DHT,
        GNUTELLA;

    }
}

