/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SocketProcessor;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.downloader.PushedSocketHandler;
import com.limegroup.gnutella.downloader.PushedSocketHandlerRegistry;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PushRequestImpl;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.util.MultiShutdownable;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.collection.IntWrapper;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.io.Connectable;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.net.ConnectionAcceptor;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.channel.AbstractChannelInterestReader;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.rudp.UDPSelectorProvider;
import org.limewire.util.Base32;
import org.limewire.util.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class PushDownloadManager
implements ConnectionAcceptor,
PushedSocketHandlerRegistry {
    private static final Log LOG = LogFactory.getLog(PushDownloadManager.class);
    private static long UDP_PUSH_FAILTIME = 5000L;
    private final ExecutorService PUSH_THREAD_POOL = ExecutorsHelper.newFixedSizeThreadPool(10, "PushProxy Requests");
    private final Map<byte[], IntWrapper> UDP_FAILOVER = new TreeMap<byte[], IntWrapper>(new GUID.GUIDByteComparator());
    private final Provider<SocketProcessor> socketProcessor;
    private final Provider<HttpExecutor> httpExecutor;
    private final Provider<HttpParams> defaultParams;
    private final ScheduledExecutorService backgroundExecutor;
    private final NetworkManager networkManager;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<IPFilter> ipFilter;
    private final Provider<UDPService> udpService;
    private final CopyOnWriteArrayList<PushedSocketHandler> pushHandlers = new CopyOnWriteArrayList();
    private final Provider<UDPSelectorProvider> udpSelectorProvider;

    @Inject
    public PushDownloadManager(Provider<MessageRouter> provider, Provider<HttpExecutor> provider2, @Named(value="defaults") Provider<HttpParams> provider3, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<SocketProcessor> provider4, NetworkManager networkManager, Provider<IPFilter> provider5, Provider<UDPService> provider6, Provider<UDPSelectorProvider> provider7) {
        this.messageRouter = provider;
        this.httpExecutor = provider2;
        this.defaultParams = provider3;
        this.backgroundExecutor = scheduledExecutorService;
        this.socketProcessor = provider4;
        this.networkManager = networkManager;
        this.ipFilter = provider5;
        this.udpService = provider6;
        this.udpSelectorProvider = provider7;
    }

    @Override
    public void register(PushedSocketHandler pushedSocketHandler) {
        this.pushHandlers.add(pushedSocketHandler);
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public void acceptConnection(String string, Socket socket) {
        ((NIOMultiplexor)((Object)socket)).setReadObserver(new GivParser(socket));
    }

    public void sendPush(RemoteFileDesc remoteFileDesc) {
        this.sendPush(remoteFileDesc, new NullMultiShutdownable());
    }

    public void sendPush(RemoteFileDesc remoteFileDesc, MultiShutdownable multiShutdownable) {
        byte[] byArray = this.networkManager.getAddress();
        int n = this.networkManager.getPort();
        if (!NetworkUtils.isValidAddress(byArray) || !NetworkUtils.isValidPort(n)) {
            if (multiShutdownable != null) {
                multiShutdownable.shutdown();
            }
            return;
        }
        byte[] byArray2 = GUID.makeGuid();
        if (this.sendPushMulticast(remoteFileDesc, byArray2)) {
            return;
        }
        if (!this.networkManager.acceptedIncomingConnection()) {
            if (this.networkManager.canDoFWT()) {
                this.sendPushTCP(remoteFileDesc, byArray2, multiShutdownable);
            } else if (multiShutdownable != null) {
                multiShutdownable.shutdown();
            }
            return;
        }
        if (!remoteFileDesc.isFromAlternateLocation()) {
            this.addUDPFailover(remoteFileDesc);
            this.backgroundExecutor.schedule(new PushFailoverRequestor(remoteFileDesc, byArray2, multiShutdownable), UDP_PUSH_FAILTIME, TimeUnit.MILLISECONDS);
        }
        this.sendPushUDP(remoteFileDesc, byArray2);
    }

    private boolean sendPushMulticast(RemoteFileDesc remoteFileDesc, byte[] byArray) {
        if (remoteFileDesc.isReplyToMulticast()) {
            byte[] byArray2 = this.networkManager.getNonForcedAddress();
            int n = this.networkManager.getNonForcedPort();
            if (NetworkUtils.isValidAddress(byArray2) && NetworkUtils.isValidPort(n)) {
                PushRequestImpl pushRequestImpl = new PushRequestImpl(byArray, 1, remoteFileDesc.getClientGUID(), remoteFileDesc.getIndex(), byArray2, n, Message.Network.MULTICAST, SSLSettings.isIncomingTLSEnabled());
                this.messageRouter.get().sendMulticastPushRequest(pushRequestImpl);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Sending push request through multicast " + pushRequestImpl);
                }
                return true;
            }
        }
        return false;
    }

    private boolean sendPushUDP(RemoteFileDesc remoteFileDesc, byte[] byArray) {
        PushRequestImpl pushRequestImpl = new PushRequestImpl(byArray, 2, remoteFileDesc.getClientGUID(), remoteFileDesc.getIndex(), this.networkManager.getAddress(), this.networkManager.getPort(), Message.Network.UDP, SSLSettings.isIncomingTLSEnabled());
        if (LOG.isInfoEnabled()) {
            LOG.info("Sending push request through udp " + pushRequestImpl);
        }
        UDPService uDPService = this.udpService.get();
        try {
            InetAddress inetAddress = InetAddress.getByName(remoteFileDesc.getHost());
            if (NetworkUtils.isValidAddress(inetAddress) && NetworkUtils.isValidPort(remoteFileDesc.getPort())) {
                uDPService.send(pushRequestImpl, inetAddress, remoteFileDesc.getPort());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        for (IpPort ipPort : remoteFileDesc.getPushProxies()) {
            if (!this.ipFilter.get().allow(ipPort.getAddress())) continue;
            uDPService.send((Message)pushRequestImpl, ipPort.getInetSocketAddress());
        }
        return true;
    }

    private void sendPushTCP(RemoteFileDesc remoteFileDesc, byte[] byArray, MultiShutdownable multiShutdownable) {
        boolean bl = remoteFileDesc.supportsFWTransfer() && this.networkManager.canDoFWT() && !this.networkManager.acceptedIncomingConnection();
        PushData pushData = new PushData(multiShutdownable, remoteFileDesc, byArray, bl);
        Set<? extends IpPort> set = remoteFileDesc.getPushProxies();
        if (set.isEmpty()) {
            this.sendPushThroughNetwork(pushData);
            return;
        }
        this.sendPushThroughProxies(pushData, set);
    }

    private void sendPushThroughNetwork(PushData pushData) {
        int n;
        pushData.getMultiShutdownable().addShutdownable(null);
        if (pushData.isFWTransfer() && !this.networkManager.acceptedIncomingConnection()) {
            pushData.getMultiShutdownable().shutdown();
            return;
        }
        byte[] byArray = this.networkManager.getAddress();
        if (!NetworkUtils.isValidAddressAndPort(byArray, n = this.networkManager.getPort())) {
            pushData.getMultiShutdownable().shutdown();
            return;
        }
        PushRequestImpl pushRequestImpl = new PushRequestImpl(pushData.getGuid(), ConnectionSettings.TTL.getValue(), pushData.getFile().getClientGUID(), pushData.getFile().getIndex(), byArray, n, Message.Network.TCP, SSLSettings.isIncomingTLSEnabled());
        if (LOG.isInfoEnabled()) {
            LOG.info("Sending push request through Gnutella: " + pushRequestImpl);
        }
        try {
            this.messageRouter.get().sendPushRequest(pushRequestImpl);
        }
        catch (IOException iOException) {
            pushData.getMultiShutdownable().shutdown();
        }
    }

    private void sendPushThroughProxies(PushData pushData, Set<? extends IpPort> set) {
        Object object;
        byte[] byArray = this.networkManager.getExternalAddress();
        if (pushData.isFWTransfer() && !NetworkUtils.isValidAddress(byArray)) {
            pushData.getMultiShutdownable().shutdown();
            return;
        }
        byte[] byArray2 = this.networkManager.getAddress();
        int n = this.networkManager.getPort();
        String string = "/gnutella/push-proxy?ServerID=" + Base32.encode(pushData.getFile().getClientGUID()) + (pushData.isFWTransfer() ? "&file=2147483645" : "") + (SSLSettings.isIncomingTLSEnabled() ? "&tls=true" : "");
        String string2 = NetworkUtils.ip2string(pushData.isFWTransfer() ? byArray : byArray2) + ":" + n;
        ArrayList<HttpHead> arrayList = new ArrayList<HttpHead>();
        for (IpPort object2 : set) {
            if (!this.ipFilter.get().allow(object2.getAddress())) continue;
            object = "http://";
            if (object2 instanceof Connectable && ((Connectable)object2).isTLSCapable()) {
                object = "tls://";
            }
            String string3 = (String)object + object2.getAddress() + ":" + object2.getPort() + string;
            HttpHead httpHead = null;
            try {
                httpHead = new HttpHead(string3);
                httpHead.addHeader("X-Node", string2);
                httpHead.addHeader("Cache-Control", "no-cache");
                arrayList.add(httpHead);
            }
            catch (Exception exception) {
                LOG.error(exception);
            }
        }
        if (!arrayList.isEmpty()) {
            PushHttpClientListener pushHttpClientListener = new PushHttpClientListener(arrayList, pushData);
            BasicHttpParams basicHttpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout(basicHttpParams, 5000);
            HttpConnectionParams.setSoTimeout(basicHttpParams, 5000);
            DefaultedHttpParams defaultedHttpParams = new DefaultedHttpParams(basicHttpParams, this.defaultParams.get());
            object = this.httpExecutor.get().executeAny(pushHttpClientListener, this.PUSH_THREAD_POOL, arrayList, defaultedHttpParams, pushData.getMultiShutdownable());
            pushData.getMultiShutdownable().addShutdownable((Shutdownable)object);
        } else {
            this.sendPushThroughNetwork(pushData);
        }
    }

    void handleGIV(Socket socket, GIVLine gIVLine) {
        String string = gIVLine.file;
        int n = 0;
        byte[] byArray = gIVLine.clientGUID;
        this.cancelUDPFailover(byArray);
        boolean bl = false;
        for (PushedSocketHandler pushedSocketHandler : this.pushHandlers) {
            if (!pushedSocketHandler.acceptPushedSocket(string, n, byArray, socket)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            IOUtils.close(socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUDPFailover(RemoteFileDesc remoteFileDesc) {
        Map<byte[], IntWrapper> map = this.UDP_FAILOVER;
        synchronized (map) {
            byte[] byArray = remoteFileDesc.getClientGUID();
            IntWrapper intWrapper = this.UDP_FAILOVER.get(byArray);
            if (intWrapper == null) {
                intWrapper = new IntWrapper(0);
                this.UDP_FAILOVER.put(byArray, intWrapper);
            }
            intWrapper.addInt(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelUDPFailover(byte[] byArray) {
        Map<byte[], IntWrapper> map = this.UDP_FAILOVER;
        synchronized (map) {
            byte[] byArray2 = byArray;
            IntWrapper intWrapper = this.UDP_FAILOVER.get(byArray2);
            if (intWrapper != null) {
                intWrapper.addInt(-1);
                if (intWrapper.getInt() <= 0) {
                    this.UDP_FAILOVER.remove(byArray2);
                }
            }
        }
    }

    private static class NullMultiShutdownable
    implements MultiShutdownable {
        private NullMultiShutdownable() {
        }

        public void shutdown() {
        }

        public void addShutdownable(Shutdownable shutdownable) {
        }

        public boolean isCancelled() {
            return false;
        }
    }

    private static class FWTConnectObserver
    implements ConnectObserver {
        private final SocketProcessor processor;

        FWTConnectObserver(SocketProcessor socketProcessor) {
            this.processor = socketProcessor;
        }

        public void handleIOException(IOException iOException) {
        }

        public void handleConnect(Socket socket) throws IOException {
            this.processor.processSocket(socket, "GIV");
        }

        public void shutdown() {
        }
    }

    static final class GIVLine {
        final String file;
        final int index;
        final byte[] clientGUID;

        GIVLine(String string, int n, byte[] byArray) {
            this.file = string;
            this.index = n;
            this.clientGUID = byArray;
        }
    }

    private class GivParser
    extends AbstractChannelInterestReader {
        private final Socket socket;
        private final StringBuilder givSB;
        private final StringBuilder blankSB;
        private boolean readBlank;
        private GIVLine giv;

        GivParser(Socket socket) {
            super(1024);
            this.givSB = new StringBuilder();
            this.blankSB = new StringBuilder();
            this.socket = socket;
        }

        public void handleRead() throws IOException {
            block6: {
                do {
                    int n = 0;
                    while (this.buffer.hasRemaining() && (n = this.source.read(this.buffer)) > 0) {
                    }
                    if (this.buffer.position() == 0) {
                        if (n != -1) break block6;
                        this.close();
                        break block6;
                    }
                    this.buffer.flip();
                    if (this.giv == null && BufferUtils.readLine(this.buffer, this.givSB)) {
                        this.giv = this.parseLine(this.givSB.toString());
                    }
                    if (this.giv != null && !this.readBlank) {
                        this.readBlank = BufferUtils.readLine(this.buffer, this.blankSB);
                        if (this.blankSB.length() > 0) {
                            throw new IOException("didn't read blank line");
                        }
                    }
                    this.buffer.compact();
                } while (!this.readBlank);
                PushDownloadManager.this.handleGIV(this.socket, this.giv);
            }
        }

        private GIVLine parseLine(String string) throws IOException {
            try {
                int n = string.indexOf(":");
                int n2 = Integer.parseInt(string.substring(0, n));
                int n3 = string.indexOf("/", n);
                byte[] byArray = GUID.fromHexString(string.substring(n + 1, n3));
                String string2 = URLDecoder.decode(string.substring(n3 + 1));
                return new GIVLine(string2, n2, byArray);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IOException();
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException();
            }
        }
    }

    private class PushFailoverRequestor
    implements Runnable {
        final RemoteFileDesc _file;
        final byte[] _guid;
        final MultiShutdownable connector;

        public PushFailoverRequestor(RemoteFileDesc remoteFileDesc, byte[] byArray, MultiShutdownable multiShutdownable) {
            this._file = remoteFileDesc;
            this._guid = byArray;
            this.connector = multiShutdownable;
        }

        public void run() {
            if (this.shouldProceed()) {
                PushDownloadManager.this.sendPushTCP(this._file, this._guid, this.connector);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean shouldProceed() {
            byte[] byArray = this._file.getClientGUID();
            Map map = PushDownloadManager.this.UDP_FAILOVER;
            synchronized (map) {
                IntWrapper intWrapper = (IntWrapper)PushDownloadManager.this.UDP_FAILOVER.get(byArray);
                if (intWrapper != null && intWrapper.getInt() > 0) {
                    intWrapper.addInt(-1);
                    if (intWrapper.getInt() == 0) {
                        PushDownloadManager.this.UDP_FAILOVER.remove(byArray);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private class PushData {
        private final MultiShutdownable observer;
        private final RemoteFileDesc file;
        private final byte[] guid;
        private final boolean shouldDoFWTransfer;

        PushData(MultiShutdownable multiShutdownable, RemoteFileDesc remoteFileDesc, byte[] byArray, boolean bl) {
            this.observer = multiShutdownable;
            this.file = remoteFileDesc;
            this.guid = byArray;
            this.shouldDoFWTransfer = bl;
        }

        public RemoteFileDesc getFile() {
            return this.file;
        }

        public byte[] getGuid() {
            return this.guid;
        }

        public MultiShutdownable getMultiShutdownable() {
            return this.observer;
        }

        public boolean isFWTransfer() {
            return this.shouldDoFWTransfer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PushHttpClientListener
    implements HttpClientListener {
        private final Collection<HttpUriRequest> methods;
        private final PushData data;

        PushHttpClientListener(Collection<? extends HttpUriRequest> collection, PushData pushData) {
            this.methods = new LinkedList<HttpUriRequest>(collection);
            this.data = pushData;
        }

        @Override
        public boolean requestFailed(HttpUriRequest httpUriRequest, HttpResponse httpResponse, IOException iOException) {
            LOG.warn("PushProxy request exception", iOException);
            ((HttpExecutor)PushDownloadManager.this.httpExecutor.get()).releaseResources(httpResponse);
            this.methods.remove(httpUriRequest);
            if (this.methods.isEmpty()) {
                PushDownloadManager.this.sendPushThroughNetwork(this.data);
            }
            return true;
        }

        @Override
        public boolean requestComplete(HttpUriRequest httpUriRequest, HttpResponse httpResponse) {
            this.methods.remove(httpUriRequest);
            int n = httpResponse.getStatusLine().getStatusCode();
            ((HttpExecutor)PushDownloadManager.this.httpExecutor.get()).releaseResources(httpResponse);
            if (n == 202) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Succesful push proxy: " + httpUriRequest);
                }
                if (this.data.isFWTransfer()) {
                    AbstractNBSocket abstractNBSocket = ((UDPSelectorProvider)PushDownloadManager.this.udpSelectorProvider.get()).openSocketChannel().socket();
                    this.data.getMultiShutdownable().addShutdownable(abstractNBSocket);
                    abstractNBSocket.connect(this.data.getFile().getInetSocketAddress(), 20000, new FWTConnectObserver((SocketProcessor)PushDownloadManager.this.socketProcessor.get()));
                }
                return false;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Invalid push proxy: " + httpUriRequest + ", response: " + httpResponse.getStatusLine().getStatusCode());
            }
            if (this.methods.isEmpty()) {
                PushDownloadManager.this.sendPushThroughNetwork(this.data);
            }
            return true;
        }
    }
}

