/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AbstractSourceRanker;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.settings.DownloadSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Cancellable;
import org.limewire.collection.DualIterator;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingRanker
extends AbstractSourceRanker
implements MessageListener,
Cancellable {
    private static final Log LOG = LogFactory.getLog(PingRanker.class);
    private static final Comparator<RemoteFileDesc> RFD_COMPARATOR = new RFDComparator();
    private static final Comparator<RemoteFileDesc> ALT_DEPRIORITIZER = new RFDAltDeprioritizer();
    private Set<RemoteFileDesc> newHosts;
    private TreeMap<IpPort, RemoteFileDesc> pingedHosts;
    private Set<RemoteFileDesc> testedLocations;
    private TreeSet<RemoteFileDesc> verifiedHosts;
    private URN sha1;
    private GUID myGUID;
    private boolean running;
    private long lastPingTime;
    private final NetworkManager networkManager;
    private final UDPPinger udpPinger;
    private final MessageRouter messageRouter;
    private final RemoteFileDescFactory remoteFileDescFactory;

    protected PingRanker(NetworkManager networkManager, UDPPinger uDPPinger, MessageRouter messageRouter, RemoteFileDescFactory remoteFileDescFactory) {
        this.networkManager = networkManager;
        this.udpPinger = uDPPinger;
        this.messageRouter = messageRouter;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.pingedHosts = new TreeMap(IpPort.COMPARATOR);
        this.testedLocations = new HashSet<RemoteFileDesc>();
        this.newHosts = new HashSet<RemoteFileDesc>();
        this.verifiedHosts = new TreeSet<RemoteFileDesc>(RFD_COMPARATOR);
    }

    @Override
    public synchronized boolean addToPool(Collection<? extends RemoteFileDesc> collection) {
        ArrayList<? extends RemoteFileDesc> arrayList = collection instanceof List ? (ArrayList<? extends RemoteFileDesc>)collection : new ArrayList<RemoteFileDesc>(collection);
        Collections.sort(arrayList, ALT_DEPRIORITIZER);
        return this.addInternal(arrayList);
    }

    private boolean addInternal(Collection<? extends RemoteFileDesc> collection) {
        boolean bl = false;
        for (RemoteFileDesc remoteFileDesc : collection) {
            if (!this.addInternal(remoteFileDesc)) continue;
            bl = true;
        }
        this.pingNewHosts();
        return bl;
    }

    @Override
    public synchronized boolean addToPool(RemoteFileDesc remoteFileDesc) {
        boolean bl = this.addInternal(remoteFileDesc);
        this.pingNewHosts();
        return bl;
    }

    private boolean addInternal(RemoteFileDesc remoteFileDesc) {
        if (this.sha1 == null) {
            if (remoteFileDesc.getSHA1Urn() != null) {
                this.sha1 = remoteFileDesc.getSHA1Urn();
            } else {
                return this.testedLocations.add(remoteFileDesc);
            }
        }
        if (this.running && this.knowsAboutHost(remoteFileDesc)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding new host " + remoteFileDesc + " " + remoteFileDesc.getPushAddr());
        }
        boolean bl = false;
        bl = remoteFileDesc.isReplyToMulticast() ? this.verifiedHosts.add(remoteFileDesc) : this.newHosts.add(remoteFileDesc);
        bl |= !this.running;
        if (this.myGUID == null && this.meshHandler != null) {
            this.myGUID = new GUID(GUID.makeGuid());
            this.messageRouter.registerMessageListener(this.myGUID.bytes(), this);
        }
        return bl;
    }

    private boolean knowsAboutHost(RemoteFileDesc remoteFileDesc) {
        return this.newHosts.contains(remoteFileDesc) || this.verifiedHosts.contains(remoteFileDesc) || this.testedLocations.contains(remoteFileDesc);
    }

    @Override
    public synchronized RemoteFileDesc getBest() throws NoSuchElementException {
        RemoteFileDesc remoteFileDesc;
        if (!this.hasMore()) {
            return null;
        }
        if (!this.verifiedHosts.isEmpty()) {
            LOG.debug("getting a verified host");
            remoteFileDesc = this.verifiedHosts.first();
            this.verifiedHosts.remove(remoteFileDesc);
        } else {
            LOG.debug("getting a non-verified host");
            DualIterator<RemoteFileDesc> dualIterator = new DualIterator<RemoteFileDesc>(this.testedLocations.iterator(), this.newHosts.iterator());
            remoteFileDesc = LegacyRanker.getBest(dualIterator);
            this.newHosts.remove(remoteFileDesc);
            this.testedLocations.remove(remoteFileDesc);
            if (remoteFileDesc.needsPush()) {
                for (IpPort ipPort : remoteFileDesc.getPushProxies()) {
                    this.pingedHosts.remove(ipPort);
                }
            } else {
                this.pingedHosts.remove(remoteFileDesc);
            }
        }
        this.pingNewHosts();
        if (LOG.isDebugEnabled()) {
            LOG.debug("the best host we came up with is " + remoteFileDesc + " " + remoteFileDesc.getPushAddr());
        }
        return remoteFileDesc;
    }

    private void pingNewHosts() {
        if (this.isCancelled()) {
            return;
        }
        if (!this.hasNonBusy()) {
            return;
        }
        if (this.sha1 == null) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastPingTime < (long)DownloadSettings.WORKER_INTERVAL.getValue()) {
            return;
        }
        HeadPing headPing = new HeadPing(this.myGUID, this.sha1, this.getPingFlags());
        int n = DownloadSettings.PING_BATCH.getValue();
        ArrayList<RemoteFileDesc> arrayList = new ArrayList<RemoteFileDesc>(n);
        int n2 = 0;
        Iterator<RemoteFileDesc> iterator = this.newHosts.iterator();
        while (iterator.hasNext() && n2 < n) {
            RemoteFileDesc remoteFileDesc = iterator.next();
            if (remoteFileDesc.isBusy(l)) continue;
            iterator.remove();
            if (remoteFileDesc.needsPush()) {
                if (remoteFileDesc.getPushProxies().size() > 0 && remoteFileDesc.getSHA1Urn() != null) {
                    this.pingProxies(remoteFileDesc);
                }
            } else {
                this.pingedHosts.put(remoteFileDesc, remoteFileDesc);
                arrayList.add(remoteFileDesc);
            }
            this.testedLocations.add(remoteFileDesc);
            ++n2;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\nverified hosts " + this.verifiedHosts.size() + "\npingedHosts " + this.pingedHosts.values().size() + "\nnewHosts " + this.newHosts.size() + "\npinging hosts: " + n2);
        }
        this.udpPinger.rank(arrayList, null, this, headPing);
        this.lastPingTime = l;
    }

    @Override
    protected Collection<RemoteFileDesc> getPotentiallyBusyHosts() {
        return this.newHosts;
    }

    private void pingProxies(RemoteFileDesc remoteFileDesc) {
        if (this.networkManager.acceptedIncomingConnection() || this.networkManager.canDoFWT() && remoteFileDesc.supportsFWTransfer()) {
            HeadPing headPing = new HeadPing(this.myGUID, remoteFileDesc.getSHA1Urn(), new GUID(remoteFileDesc.getPushAddr().getClientGUID()), this.getPingFlags());
            for (IpPort ipPort : remoteFileDesc.getPushProxies()) {
                this.pingedHosts.put(ipPort, remoteFileDesc);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("pinging push location " + remoteFileDesc.getPushAddr());
            }
            this.udpPinger.rank(remoteFileDesc.getPushProxies(), null, this, headPing);
        }
    }

    private int getPingFlags() {
        int n = 3;
        if (this.networkManager.acceptedIncomingConnection() || this.networkManager.canDoFWT()) {
            n |= 4;
        }
        return n;
    }

    @Override
    public synchronized boolean hasMore() {
        return !this.verifiedHosts.isEmpty() || !this.newHosts.isEmpty() || !this.testedLocations.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(Message message, ReplyHandler replyHandler) {
        MeshHandler meshHandler;
        RemoteFileDesc remoteFileDesc;
        Set<RemoteFileDesc> set = null;
        PingRanker pingRanker = this;
        synchronized (pingRanker) {
            if (!this.running) {
                return;
            }
            if (!(message instanceof HeadPong)) {
                return;
            }
            HeadPong headPong = (HeadPong)message;
            if (!this.pingedHosts.containsKey(replyHandler)) {
                return;
            }
            remoteFileDesc = this.pingedHosts.remove(replyHandler);
            this.testedLocations.remove(remoteFileDesc);
            if (LOG.isDebugEnabled()) {
                LOG.debug("received a pong " + headPong + " from " + replyHandler + " for rfd " + remoteFileDesc + " with PE " + remoteFileDesc.getPushAddr());
            }
            if (!headPong.hasFile() && headPong.isRoutingBroken() && remoteFileDesc.needsPush()) {
                return;
            }
            if (headPong.isFirewalled()) {
                for (IpPort ipPort : remoteFileDesc.getPushProxies()) {
                    this.pingedHosts.remove(ipPort);
                }
            }
            meshHandler = this.meshHandler;
            if (headPong.hasFile()) {
                headPong.updateRFD(remoteFileDesc);
                if (remoteFileDesc.isBusy()) {
                    this.newHosts.add(remoteFileDesc);
                } else {
                    this.verifiedHosts.add(remoteFileDesc);
                }
                set = headPong.getAllLocsRFD(remoteFileDesc, this.remoteFileDescFactory);
            }
        }
        if (set == null) {
            meshHandler.informMesh(remoteFileDesc, false);
        } else {
            meshHandler.addPossibleSources(set);
        }
    }

    @Override
    public synchronized void registered(byte[] byArray) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ranker registered with guid " + new GUID(byArray).toHexString());
        }
        this.running = true;
    }

    @Override
    public synchronized void unregistered(byte[] byArray) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ranker unregistered with guid " + new GUID(byArray).toHexString());
        }
        this.running = false;
        this.newHosts.addAll(this.verifiedHosts);
        this.newHosts.addAll(this.testedLocations);
        this.verifiedHosts.clear();
        this.pingedHosts.clear();
        this.testedLocations.clear();
        this.lastPingTime = 0L;
    }

    @Override
    public synchronized boolean isCancelled() {
        return !this.running || this.verifiedHosts.size() >= DownloadSettings.MAX_VERIFIED_HOSTS.getValue();
    }

    @Override
    protected synchronized void clearState() {
        if (this.myGUID != null) {
            this.messageRouter.unregisterMessageListener(this.myGUID.bytes(), this);
            this.myGUID = null;
        }
    }

    @Override
    public synchronized Collection<RemoteFileDesc> getShareableHosts() {
        ArrayList<RemoteFileDesc> arrayList = new ArrayList<RemoteFileDesc>(this.verifiedHosts.size() + this.newHosts.size() + this.testedLocations.size());
        arrayList.addAll(this.verifiedHosts);
        arrayList.addAll(this.newHosts);
        arrayList.addAll(this.testedLocations);
        return arrayList;
    }

    @Override
    public synchronized int getNumKnownHosts() {
        return this.verifiedHosts.size() + this.newHosts.size() + this.testedLocations.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RFDAltDeprioritizer
    implements Comparator<RemoteFileDesc> {
        private RFDAltDeprioritizer() {
        }

        @Override
        public int compare(RemoteFileDesc remoteFileDesc, RemoteFileDesc remoteFileDesc2) {
            if (remoteFileDesc.isFromAlternateLocation() != remoteFileDesc2.isFromAlternateLocation()) {
                if (remoteFileDesc.isFromAlternateLocation()) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RFDComparator
    implements Comparator<RemoteFileDesc> {
        private RFDComparator() {
        }

        @Override
        public int compare(RemoteFileDesc remoteFileDesc, RemoteFileDesc remoteFileDesc2) {
            if (remoteFileDesc.isReplyToMulticast() != remoteFileDesc2.isReplyToMulticast()) {
                if (remoteFileDesc.isReplyToMulticast()) {
                    return -1;
                }
                return 1;
            }
            if (remoteFileDesc.getQueueStatus() > remoteFileDesc2.getQueueStatus()) {
                return 1;
            }
            if (remoteFileDesc.getQueueStatus() < remoteFileDesc2.getQueueStatus()) {
                return -1;
            }
            if (remoteFileDesc.needsPush() != remoteFileDesc2.needsPush()) {
                if (remoteFileDesc.needsPush()) {
                    return -1;
                }
                return 1;
            }
            if (remoteFileDesc.isPartialSource() != remoteFileDesc2.isPartialSource()) {
                if (remoteFileDesc.isPartialSource()) {
                    return -1;
                }
                return 1;
            }
            return remoteFileDesc.hashCode() - remoteFileDesc2.hashCode();
        }
    }
}

