/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.SaveLocationManager;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.ManagedDownloaderImpl;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RequeryManagerFactory;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.downloader.SourceRankerFactory;
import com.limegroup.gnutella.downloader.VerifyingFileFactory;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.InNetworkDownloadMemento;
import com.limegroup.gnutella.downloader.serial.InNetworkDownloadMementoImpl;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.version.DownloadInformation;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.io.InvalidDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InNetworkDownloaderImpl
extends ManagedDownloaderImpl
implements InNetworkDownloader {
    private String tigerTreeRoot;
    private long startTime;
    private int downloadAttempts;

    @Inject
    InNetworkDownloaderImpl(SaveLocationManager saveLocationManager, DownloadManager downloadManager, FileManager fileManager, IncompleteFileManager incompleteFileManager, DownloadCallback downloadCallback, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, RequeryManagerFactory requeryManagerFactory, QueryRequestFactory queryRequestFactory, OnDemandUnicaster onDemandUnicaster, DownloadWorkerFactory downloadWorkerFactory, AltLocManager altLocManager, ContentManager contentManager, SourceRankerFactory sourceRankerFactory, UrnCache urnCache, SavedFileManager savedFileManager, VerifyingFileFactory verifyingFileFactory, DiskController diskController, IPFilter iPFilter, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<MessageRouter> provider, Provider<HashTreeCache> provider2, ApplicationServices applicationServices, RemoteFileDescFactory remoteFileDescFactory, Provider<PushList> provider3) throws SaveLocationException {
        super(saveLocationManager, downloadManager, fileManager, incompleteFileManager, downloadCallback, networkManager, alternateLocationFactory, requeryManagerFactory, queryRequestFactory, onDemandUnicaster, downloadWorkerFactory, altLocManager, contentManager, sourceRankerFactory, urnCache, savedFileManager, verifyingFileFactory, diskController, iPFilter, scheduledExecutorService, provider, provider2, applicationServices, remoteFileDescFactory, provider3);
    }

    @Override
    public void initDownloadInformation(DownloadInformation downloadInformation, long l) {
        if (downloadInformation.getSize() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size too big for now.");
        }
        this.setContentLength(downloadInformation.getSize());
        if (downloadInformation.getUpdateURN() != null) {
            this.setSha1Urn(downloadInformation.getUpdateURN());
        }
        this.setTigerTreeRoot(downloadInformation.getTTRoot());
        this.setStartTime(l);
        this.setDownloadAttempts(0);
    }

    protected synchronized void setDownloadAttempts(int n) {
        this.downloadAttempts = n;
    }

    protected synchronized void setStartTime(long l) {
        this.startTime = l;
    }

    protected synchronized void setTigerTreeRoot(String string) {
        this.tigerTreeRoot = string;
    }

    @Override
    protected File getIncompleteFile(String string, URN uRN, long l) throws IOException {
        return this.incompleteFileManager.getFile(string, uRN, l, new File(SharingUtils.PREFERENCE_SHARE, "Incomplete"));
    }

    @Override
    protected SourceRanker getSourceRanker(SourceRanker sourceRanker) {
        if (sourceRanker != null) {
            return sourceRanker;
        }
        return new LegacyRanker();
    }

    @Override
    public synchronized void startDownload() {
        this.incrementDownloadAttempts();
        super.startDownload();
    }

    private synchronized void incrementDownloadAttempts() {
        ++this.downloadAttempts;
    }

    @Override
    protected boolean shouldValidate() {
        return false;
    }

    @Override
    protected void initializeVerifyingFile() throws IOException {
        super.initializeVerifyingFile();
        if (this.commonOutFile != null) {
            this.commonOutFile.setExpectedHashTreeRoot(this.getTigerTreeRoot());
        }
    }

    protected synchronized String getTigerTreeRoot() {
        return this.tigerTreeRoot;
    }

    @Override
    public synchronized QueryRequest newRequery() throws CantResumeException {
        QueryRequest queryRequest = super.newRequery();
        queryRequest.setTTL((byte)2);
        return queryRequest;
    }

    @Override
    public synchronized int getDownloadAttempts() {
        return this.downloadAttempts;
    }

    @Override
    public synchronized long getStartTime() {
        return this.startTime;
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.INNETWORK;
    }

    @Override
    protected void fillInMemento(DownloadMemento downloadMemento) {
        super.fillInMemento(downloadMemento);
        InNetworkDownloadMemento inNetworkDownloadMemento = (InNetworkDownloadMemento)downloadMemento;
        inNetworkDownloadMemento.setTigerTreeRoot(this.getTigerTreeRoot());
        inNetworkDownloadMemento.setStartTime(this.getStartTime());
        inNetworkDownloadMemento.setDownloadAttempts(this.getDownloadAttempts());
    }

    @Override
    protected DownloadMemento createMemento() {
        return new InNetworkDownloadMementoImpl();
    }

    @Override
    public synchronized void initFromMemento(DownloadMemento downloadMemento) throws InvalidDataException {
        super.initFromMemento(downloadMemento);
        InNetworkDownloadMemento inNetworkDownloadMemento = (InNetworkDownloadMemento)downloadMemento;
        this.setTigerTreeRoot(inNetworkDownloadMemento.getTigerTreeRoot());
        this.setStartTime(inNetworkDownloadMemento.getStartTime());
        this.setDownloadAttempts(inNetworkDownloadMemento.getDownloadAttempts());
    }
}

