/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.bittorrent.BTDownloader;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.CoreDownloaderFactory;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.MagnetDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.downloader.StoreDownloader;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.version.DownloadInformation;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import org.limewire.io.InvalidDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CoreDownloaderFactoryImpl
implements CoreDownloaderFactory {
    private final Provider<ManagedDownloader> managedDownloaderFactory;
    private final Provider<MagnetDownloader> magnetDownloaderFactory;
    private final Provider<InNetworkDownloader> inNetworkDownloaderFactory;
    private final Provider<ResumeDownloader> resumeDownloaderFactory;
    private final Provider<StoreDownloader> storeDownloaderFactory;
    private final Provider<BTDownloader> btDownloaderFactory;

    @Inject
    public CoreDownloaderFactoryImpl(Provider<ManagedDownloader> provider, Provider<MagnetDownloader> provider2, Provider<InNetworkDownloader> provider3, Provider<ResumeDownloader> provider4, Provider<StoreDownloader> provider5, Provider<BTDownloader> provider6) {
        this.managedDownloaderFactory = provider;
        this.magnetDownloaderFactory = provider2;
        this.inNetworkDownloaderFactory = provider3;
        this.resumeDownloaderFactory = provider4;
        this.storeDownloaderFactory = provider5;
        this.btDownloaderFactory = provider6;
    }

    @Override
    public ManagedDownloader createManagedDownloader(RemoteFileDesc[] remoteFileDescArray, GUID gUID, File file, String string, boolean bl) throws SaveLocationException {
        ManagedDownloader managedDownloader = this.managedDownloaderFactory.get();
        managedDownloader.addInitialSources(Arrays.asList(remoteFileDescArray), string);
        managedDownloader.setQueryGuid(gUID);
        managedDownloader.setSaveFile(file, string, bl);
        return managedDownloader;
    }

    @Override
    public MagnetDownloader createMagnetDownloader(MagnetOptions magnetOptions, boolean bl, File file, String string) throws SaveLocationException {
        if (!magnetOptions.isDownloadable()) {
            throw new IllegalArgumentException("magnet not downloadable");
        }
        if (string == null) {
            string = magnetOptions.getFileNameForSaving();
        }
        MagnetDownloader magnetDownloader = this.magnetDownloaderFactory.get();
        magnetDownloader.addInitialSources(null, string);
        magnetDownloader.setSaveFile(file, string, bl);
        magnetDownloader.setMagnet(magnetOptions);
        return magnetDownloader;
    }

    @Override
    public InNetworkDownloader createInNetworkDownloader(DownloadInformation downloadInformation, File file, long l) throws SaveLocationException {
        InNetworkDownloader inNetworkDownloader = this.inNetworkDownloaderFactory.get();
        inNetworkDownloader.addInitialSources(null, downloadInformation.getUpdateFileName());
        inNetworkDownloader.setSaveFile(file, downloadInformation.getUpdateFileName(), true);
        inNetworkDownloader.initDownloadInformation(downloadInformation, l);
        return inNetworkDownloader;
    }

    @Override
    public ResumeDownloader createResumeDownloader(File file, String string, long l) throws SaveLocationException {
        ResumeDownloader resumeDownloader = this.resumeDownloaderFactory.get();
        resumeDownloader.addInitialSources(null, string);
        resumeDownloader.setSaveFile(null, string, false);
        resumeDownloader.initIncompleteFile(file, l);
        return resumeDownloader;
    }

    @Override
    public StoreDownloader createStoreDownloader(RemoteFileDesc remoteFileDesc, File file, String string, boolean bl) throws SaveLocationException {
        StoreDownloader storeDownloader = this.storeDownloaderFactory.get();
        storeDownloader.addInitialSources(Collections.singletonList(remoteFileDesc), string);
        storeDownloader.setSaveFile(file, string, bl);
        return storeDownloader;
    }

    @Override
    public BTDownloader createBTDownloader(BTMetaInfo bTMetaInfo) {
        BTDownloader bTDownloader = this.btDownloaderFactory.get();
        bTDownloader.initBtMetaInfo(bTMetaInfo);
        return bTDownloader;
    }

    @Override
    public CoreDownloader createFromMemento(DownloadMemento downloadMemento) throws InvalidDataException {
        try {
            Provider<? extends CoreDownloader> provider = this.providerForMemento(downloadMemento);
            CoreDownloader coreDownloader = provider.get();
            coreDownloader.initFromMemento(downloadMemento);
            return coreDownloader;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidDataException("invalid memento!", classCastException);
        }
    }

    private Provider<? extends CoreDownloader> providerForMemento(DownloadMemento downloadMemento) throws InvalidDataException {
        switch (downloadMemento.getDownloadType()) {
            case BTDOWNLOADER: {
                return this.btDownloaderFactory;
            }
            case INNETWORK: {
                return this.inNetworkDownloaderFactory;
            }
            case MAGNET: {
                return this.magnetDownloaderFactory;
            }
            case MANAGED: {
                return this.managedDownloaderFactory;
            }
            case STORE: {
                return this.storeDownloaderFactory;
            }
        }
        throw new InvalidDataException("invalid memento type: " + (Object)((Object)downloadMemento.getDownloadType()));
    }
}

