/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.dime.AsyncDimeWriter;
import com.limegroup.gnutella.dime.DIMERecord;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DIMEGenerator {
    private final List<DIMERecord> RECORDS = new LinkedList<DIMERecord>();
    private int _length = 0;

    public void add(DIMERecord dIMERecord) {
        this.RECORDS.add(dIMERecord);
        this._length += dIMERecord.getRecordLength();
    }

    public int getLength() {
        return this._length;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.RECORDS.isEmpty()) {
            return;
        }
        Iterator<DIMERecord> iterator = this.RECORDS.iterator();
        int n = this.RECORDS.size();
        for (int i = 0; i < n; ++i) {
            DIMERecord dIMERecord = iterator.next();
            if (i == 0) {
                dIMERecord.setFirstRecord(true);
            } else {
                dIMERecord.setFirstRecord(false);
            }
            if (i == n - 1) {
                dIMERecord.setLastRecord(true);
            } else {
                dIMERecord.setLastRecord(false);
            }
            dIMERecord.write(outputStream);
        }
    }

    public AsyncDimeWriter createAsyncWriter() {
        return new AsyncDimeWriter(this.RECORDS);
    }
}

