/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.dime.DIMERecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.List;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.nio.statemachine.WriteState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncDimeWriter
extends WriteState {
    private final Iterator<DIMERecord> recordIt;
    private final ByteBufferOutputStream out;
    public boolean isFirstRecord = true;
    private long amountProcessed;
    private boolean flipped;

    public AsyncDimeWriter(List<DIMERecord> list) {
        this.recordIt = list.iterator();
        this.out = new ByteBufferOutputStream();
    }

    @Override
    protected boolean processWrite(WritableByteChannel writableByteChannel, ByteBuffer byteBuffer) throws IOException {
        boolean bl;
        if (this.writeRemaining(writableByteChannel)) {
            return true;
        }
        boolean bl2 = bl = !this.recordIt.hasNext();
        while (!bl) {
            DIMERecord dIMERecord = this.recordIt.next();
            if (this.isFirstRecord) {
                dIMERecord.setFirstRecord(true);
                this.isFirstRecord = false;
            } else {
                dIMERecord.setFirstRecord(false);
            }
            bl = !this.recordIt.hasNext();
            dIMERecord.setLastRecord(bl);
            dIMERecord.write(this.out);
            if (!this.writeRemaining(writableByteChannel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getAmountProcessed() {
        return this.amountProcessed;
    }

    private boolean writeRemaining(WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer = this.out.getBuffer();
        if (this.flipped || byteBuffer.position() > 0) {
            if (!this.flipped) {
                byteBuffer.flip();
                this.flipped = true;
            }
            int n = writableByteChannel.write(byteBuffer);
            this.amountProcessed += (long)n;
            if (byteBuffer.hasRemaining()) {
                return true;
            }
            this.flipped = false;
            byteBuffer.clear();
        }
        return false;
    }
}

