/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.dht.db.AltLocValue;
import com.limegroup.gnutella.dht.db.AltLocValueFactory;
import com.limegroup.gnutella.dht.db.AltLocValueForSelf;
import com.limegroup.gnutella.dht.db.AltLocValueImpl;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.exceptions.DHTValueException;
import org.limewire.mojito.routing.Version;

@Singleton
public class AltLocValueFactoryImpl
implements AltLocValueFactory {
    private final NetworkManager networkManager;
    private final ApplicationServices applicationServices;

    @Inject
    public AltLocValueFactoryImpl(NetworkManager networkManager, ApplicationServices applicationServices) {
        this.networkManager = networkManager;
        this.applicationServices = applicationServices;
    }

    public AltLocValue createDHTValue(DHTValueType dHTValueType, Version version, byte[] byArray) throws DHTValueException {
        return this.createFromData(version, byArray);
    }

    public AltLocValue createAltLocValueForSelf(long l, byte[] byArray) {
        return new AltLocValueForSelf(l, byArray, this.networkManager, this.applicationServices);
    }

    public AltLocValue createFromData(Version version, byte[] byArray) throws DHTValueException {
        return new AltLocValueImpl(version, byArray);
    }

    AltLocValue createAltLocValue(Version version, byte[] byArray, int n, long l, byte[] byArray2, boolean bl) {
        return new AltLocValueImpl(version, byArray, n, l, byArray2, bl, false);
    }
}

