/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.RoutedConnection;
import java.util.EventObject;

public class ConnectionLifecycleEvent
extends EventObject {
    private final RoutedConnection connection;
    private final EventType type;

    public ConnectionLifecycleEvent(Object object, EventType eventType, RoutedConnection routedConnection) {
        super(object);
        this.connection = routedConnection;
        this.type = eventType;
    }

    public ConnectionLifecycleEvent(Object object, EventType eventType) {
        this(object, eventType, null);
    }

    public EventType getType() {
        return this.type;
    }

    public RoutedConnection getConnection() {
        return this.connection;
    }

    public boolean isConnectingEvent() {
        return this.type.equals((Object)EventType.CONNECTING);
    }

    public boolean isConnectedEvent() {
        return this.type.equals((Object)EventType.CONNECTED);
    }

    public boolean isDisconnectedEvent() {
        return this.type.equals((Object)EventType.DISCONNECTED);
    }

    public boolean isNoInternetEvent() {
        return this.type.equals((Object)EventType.NO_INTERNET);
    }

    public boolean isConnectionInitializingEvent() {
        return this.type.equals((Object)EventType.CONNECTION_INITIALIZING);
    }

    public boolean isConnectionClosedEvent() {
        return this.type.equals((Object)EventType.CONNECTION_CLOSED);
    }

    public boolean isConnectionInitializedEvent() {
        return this.type.equals((Object)EventType.CONNECTION_INITIALIZED);
    }

    public boolean isConnectionCapabilitiesEvent() {
        return this.type.equals((Object)EventType.CONNECTION_CAPABILITIES);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ConnectionLifecycleEvent: [event=");
        stringBuffer.append((Object)this.type);
        stringBuffer.append(", connection=");
        if (this.connection != null) {
            stringBuffer.append(this.connection.toString());
        } else {
            stringBuffer.append(", connection= null");
        }
        return stringBuffer.append("]").toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        CONNECTING,
        CONNECTED,
        DISCONNECTED,
        NO_INTERNET,
        CONNECTION_INITIALIZING,
        CONNECTION_INITIALIZED,
        CONNECTION_CLOSED,
        CONNECTION_CAPABILITIES;

    }
}

